/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.playlist;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.info.Player;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.WaterPlayerPlaylist;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;

public class Playlist {
    public String title;
    public String author;
    public Boolean isPublic;
    public JsonArray urlsJSON;
    public List<String> urls = new ArrayList<String>();
    public Path path;
    public String icon;
    public String fileName = "Unknown";

    public Playlist(String name) throws IOException {
        this(AlinLib.MINECRAFT.field_1697.toPath().resolve(WaterPlayer.getPath() + "/playlists/" + name + ".json"));
    }

    public Playlist(Path path) throws IOException {
        this(path.toFile().exists() ? class_3518.method_15285((String)Files.readString(path)) : new JsonObject());
        this.path = path;
        this.fileName = path.getFileName().toString();
        this.fileName = this.fileName.substring(0, this.fileName.length() - 5);
    }

    public Playlist(JsonObject data) {
        this.title = data.has("title") ? data.get("title").getAsString() : "Example title";
        this.author = data.has("author") ? data.get("author").getAsString() : Player.getName();
        this.urlsJSON = data.has("urls") ? data.get("urls").getAsJsonArray() : class_3518.method_43679((String)"[\"https://www.youtube.com/watch?v=2bjBl-nX1oc\"]");
        this.icon = data.has("icon") ? data.get("icon").getAsString() : null;
        this.isPublic = data.has("public") && data.get("public").getAsBoolean();
        for (int i = 0; i < this.urlsJSON.size(); ++i) {
            this.urls.add(this.urlsJSON.get(i).getAsString());
        }
    }

    public static boolean isValid(JsonObject data) {
        return data.has("title") && data.has("author") && data.has("urls");
    }

    public void save() {
        if (this.path == null) {
            return;
        }
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.writeString(this.path, (CharSequence)this.toJSON().toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            WaterPlayer.log(e.getLocalizedMessage(), Level.ERROR);
        }
    }

    public Playlist addUrl(String url) {
        this.urls.add(url);
        this.save();
        return this;
    }

    public Playlist setUrl(String url, int position) {
        this.urls.set(position, url);
        this.save();
        return this;
    }

    public void setIcon(File path) {
        try {
            BufferedImage bufferedImage = ImageIO.read(path);
            if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                int x = (bufferedImage.getWidth() - bufferedImage.getHeight()) / 2;
                bufferedImage = bufferedImage.getSubimage(x, 0, bufferedImage.getHeight(), bufferedImage.getHeight());
            }
            BufferedImage scaleImage = TextureHelper.toBufferedImage(bufferedImage.getScaledInstance(128, 128, 2));
            if (TextureHelper.resourceLocationMap.containsKey(String.format("playlist-%s", this.fileName))) {
                TextureHelper.remove$Base64(String.format("playlist-%s", this.fileName), this.icon);
            }
            this.icon = this.encodeToString(scaleImage);
            this.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String encodeToString(BufferedImage image) {
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", bos);
            byte[] imageBytes = bos.toByteArray();
            imageString = Base64.getEncoder().encodeToString(imageBytes);
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageString;
    }

    public JsonObject toJSON() {
        JsonObject data = new JsonObject();
        data.addProperty("title", this.title);
        data.addProperty("author", this.author);
        data.addProperty("public", this.isPublic);
        if (this.icon != null) {
            data.addProperty("icon", this.icon);
        }
        data.add("urls", this.getUrlsJSON());
        return data;
    }

    public WaterPlayerPlaylist getLavaplayerPlaylist() {
        return new WaterPlayerPlaylist(this);
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JsonArray getUrlsJSON() {
        JsonArray array = new JsonArray();
        for (String url : this.urls) {
            if (url.isBlank()) continue;
            array.add(url);
        }
        return array;
    }
}

