/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.playlist;

import com.google.gson.JsonObject;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.WaterPlayerAPI;
import ru.kelcuprum.waterplayer.backend.exception.WebPlaylistException;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.WaterPlayerPlaylist;

public class WebPlaylist {
    public String id;
    public String url;
    public Playlist playlist;

    public WebPlaylist(JsonObject data) throws WebPlaylistException {
        if (!WebPlaylist.isValid(data)) {
            throw new WebPlaylistException("Incorrect web playlist format");
        }
        this.id = data.has("id") ? data.get("id").getAsString() : "Example title";
        this.url = data.has("url") ? data.get("url").getAsString() : "";
        this.playlist = new Playlist(data.getAsJsonObject("data"));
    }

    public static boolean isValid(JsonObject data) {
        return data.has("id") && data.has("url") && data.has("data") && Playlist.isValid(data.getAsJsonObject("data"));
    }

    public WebPlaylist save() throws WebPlaylistException {
        Path path = AlinLib.MINECRAFT.field_1697.toPath().resolve(WaterPlayer.getPath() + "/playlists/" + this.id + ".json");
        if (path.toFile().exists()) {
            path = AlinLib.MINECRAFT.field_1697.toPath().resolve(WaterPlayer.getPath() + "/playlists/" + this.url + ".json");
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)this.playlist.toJSON().toString(), new OpenOption[0]);
            this.playlist = new Playlist(path);
        }
        catch (IOException e) {
            WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            throw new WebPlaylistException("External error: " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
        return this;
    }

    public boolean delete() {
        return WaterPlayerAPI.deletePlaylist(this.url);
    }

    public List<AudioTrack> getTracks() {
        return new WaterPlayerPlaylist(this.playlist).getTracks();
    }
}

