/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.queue;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.kelcuprum.waterplayer.WaterPlayer;

public abstract class AbstractQueue {
    public List<AudioTrack> tracks;
    public AudioTrack currentTrack;
    public int position = 0;

    public AbstractQueue(List<AudioTrack> tracks) {
        this.tracks = tracks;
        if (!tracks.isEmpty()) {
            this.currentTrack = tracks.get(0);
        }
    }

    public AudioTrack getCurrentTrack() {
        return this.currentTrack == null ? null : this.currentTrack.makeClone();
    }

    public abstract Boolean addTrackAvailable();

    public abstract String getName();

    public void shuffle() {
        List<AudioTrack> queue = this.tracks;
        Collections.shuffle(queue);
        if (this.currentTrack != null) {
            AudioTrack first = queue.get(0);
            int i = queue.indexOf(this.currentTrack);
            queue.set(0, this.currentTrack);
            queue.set(i, first);
            this.position = 0;
        }
        this.tracks = queue;
    }

    public void nextTrack() {
        if (!this.tracks.isEmpty()) {
            ++this.position;
            if (this.position >= this.tracks.size() && WaterPlayer.player.getTrackScheduler().getRepeatStatus() == 1) {
                this.position = 0;
            }
            this.currentTrack = this.position >= this.tracks.size() ? null : this.tracks.get(this.position);
        } else {
            this.currentTrack = null;
        }
    }

    public void backTrack() {
        if (!this.tracks.isEmpty()) {
            --this.position;
            if (this.position < 0) {
                this.position = WaterPlayer.player.getTrackScheduler().getRepeatStatus() == 1 ? this.tracks.size() - 1 : 0;
            }
            this.currentTrack = this.position >= this.tracks.size() ? null : this.tracks.get(this.position);
        } else {
            this.currentTrack = null;
        }
    }

    public List<AudioTrack> getQueue() {
        ArrayList<AudioTrack> queue = new ArrayList<AudioTrack>();
        if (!this.tracks.isEmpty()) {
            int i;
            for (i = this.position + 1; i < this.tracks.size(); ++i) {
                queue.add(this.tracks.get(i));
            }
            if (WaterPlayer.player.getTrackScheduler().getRepeatStatus() == 1) {
                for (i = 0; i < this.position; ++i) {
                    queue.add(this.tracks.get(i));
                }
            }
        }
        return queue;
    }

    public void addTrack(AudioTrack audioTrack) {
        if (audioTrack != null && this.addTrackAvailable().booleanValue()) {
            if (this.tracks.isEmpty()) {
                this.currentTrack = audioTrack;
            }
            this.tracks.add(audioTrack);
        }
        if (WaterPlayer.player.getAudioPlayer().getPlayingTrack() == null) {
            WaterPlayer.player.getAudioPlayer().startTrack(audioTrack, false);
        }
    }
}

