/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.sources.directory;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.waterplayer.WaterPlayer;

public class DirectoryPlaylist
implements AudioPlaylist {
    protected final File file;
    List<AudioTrack> tracks = new ArrayList<AudioTrack>();

    public DirectoryPlaylist(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("File is not folder");
        }
        if (file.exists() && file.listFiles() != null) {
            for (final File url : Objects.requireNonNull(file.listFiles())) {
                if (!url.isFile()) continue;
                WaterPlayer.player.getAudioPlayerManager().loadItemSync(url.getPath(), new AudioLoadResultHandler(){

                    @Override
                    public void trackLoaded(AudioTrack track) {
                        DirectoryPlaylist.this.tracks.add(track);
                    }

                    @Override
                    public void playlistLoaded(AudioPlaylist playlist) {
                        DirectoryPlaylist.this.tracks.addAll(playlist.getTracks());
                    }

                    @Override
                    public void noMatches() {
                        WaterPlayer.log("Nothing Found by " + String.valueOf(url), Level.WARN);
                    }

                    @Override
                    public void loadFailed(FriendlyException exception) {
                        if (!exception.getMessage().toLowerCase().startsWith("unknown file format")) {
                            WaterPlayer.log(exception.getMessage(), Level.ERROR);
                        }
                    }
                });
            }
        }
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public List<AudioTrack> getTracks() {
        return this.tracks;
    }

    @Override
    public AudioTrack getSelectedTrack() {
        return this.getTracks().isEmpty() ? null : this.getTracks().get(0);
    }

    @Override
    public boolean isSearchResult() {
        return false;
    }
}

