/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.sources.waterplayer;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;

public class WaterPlayerPlaylist
implements AudioPlaylist {
    protected final Playlist playlist;
    List<AudioTrack> tracks = new ArrayList<AudioTrack>();

    public WaterPlayerPlaylist(Playlist playlist) {
        for (final String url : playlist.urls) {
            WaterPlayer.player.getAudioPlayerManager().loadItemSync(url, new AudioLoadResultHandler(){

                @Override
                public void trackLoaded(AudioTrack track) {
                    WaterPlayerPlaylist.this.tracks.add(track);
                }

                @Override
                public void playlistLoaded(AudioPlaylist playlist) {
                    WaterPlayerPlaylist.this.tracks.addAll(playlist.getTracks());
                }

                @Override
                public void noMatches() {
                    WaterPlayer.log("Nothing Found by " + url, Level.WARN);
                }

                @Override
                public void loadFailed(FriendlyException ex) {
                    WaterPlayer.log("ERROR: " + (ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage()), Level.DEBUG);
                }
            });
        }
        this.playlist = playlist;
    }

    @Override
    public String getName() {
        return this.playlist.title;
    }

    @Override
    public List<AudioTrack> getTracks() {
        return this.tracks;
    }

    @Override
    public AudioTrack getSelectedTrack() {
        return this.getTracks().isEmpty() ? null : this.getTracks().get(0);
    }

    @Override
    public boolean isSearchResult() {
        return false;
    }
}

