/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.plugins.convert.Base64Converter;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jetbrains.annotations.Async;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.waterplayer.WaterPlayer;

public class TextureHelper {
    public static HashMap<String, class_2960> resourceLocationMap = new HashMap();
    public static HashMap<String, Boolean> urls = new HashMap();
    public static HashMap<String, class_1043> urlsTextures = new HashMap();
    public static JsonArray map = new JsonArray();
    public static HashMap<File, Boolean> urls$file = new HashMap();
    public static HashMap<File, class_1043> urlsTextures$file = new HashMap();
    public static HashMap<String, Boolean> urls$Base64 = new HashMap();
    public static HashMap<String, class_1043> urlsTextures$Base64 = new HashMap();
    public static HashMap<class_2960, BufferedImage> dynamicTextures = new HashMap();

    public static class_2960 getTexture(String url, String id) {
        if (resourceLocationMap.containsKey(id = TextureHelper.formatUrls(id.toLowerCase()))) {
            return resourceLocationMap.get(id);
        }
        if (!urls.getOrDefault(id, false).booleanValue()) {
            urls.put(id, true);
            String finalId = id;
            new Thread(() -> TextureHelper.registerTexture(Type.INTERNET, url, finalId, AlinLib.MINECRAFT.method_1531(), GuiUtils.getResourceLocation((String)"waterplayer", (String)finalId))).start();
        }
        return WaterPlayer.Icons.NO_ICON;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Async.Execute
    public static void registerTexture(Type type, String url, String id, class_1060 textureManager, class_2960 textureId) {
        JsonObject data;
        WaterPlayer.log(String.format("REGISTER: %s %s", url, id), Level.DEBUG);
        AtomicReference<class_1043> texture = new AtomicReference<class_1043>();
        if (urlsTextures.containsKey(url)) {
            data = new JsonObject();
            data.addProperty("url", url);
            data.addProperty("id", id);
            if (!map.contains(data)) {
                map.add(data);
            }
            texture.set(urlsTextures.get(url));
        } else {
            class_1011 image;
            File textureFile = TextureHelper.getTextureFile(id);
            boolean isFileExists = textureFile.exists();
            try {
                BufferedImage bufferedImage;
                if (isFileExists) {
                    bufferedImage = ImageIO.read(TextureHelper.getTextureFile(id));
                } else if (type == Type.FILE) {
                    File file = new File(url);
                    AudioFile f = AudioFileIO.read(file);
                    if (f.getTag().getArtworkList().isEmpty()) {
                        resourceLocationMap.put(id, WaterPlayer.Icons.FILE_ICON);
                        return;
                    }
                    bufferedImage = (BufferedImage)f.getTag().getFirstArtwork().getImage();
                } else if (type == Type.BASE64) {
                    byte[] imageBytes = Base64Converter.parseBase64Binary((String)url);
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
                } else {
                    bufferedImage = ImageIO.read(new URL(url));
                }
                if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                    int x = (bufferedImage.getWidth() - bufferedImage.getHeight()) / 2;
                    bufferedImage = bufferedImage.getSubimage(x, 0, bufferedImage.getHeight(), bufferedImage.getHeight());
                }
                int size = Math.min(bufferedImage.getHeight(), TextureHelper.getMinSize(bufferedImage.getHeight()));
                BufferedImage scaleImage = TextureHelper.toBufferedImage(bufferedImage.getScaledInstance(size, size, 2));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)scaleImage, "png", byteArrayOutputStream);
                ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                image = class_1011.method_4309((InputStream)is);
                dynamicTextures.put(textureId, scaleImage);
                if (!isFileExists) {
                    Files.createDirectories(textureFile.toPath().getParent(), new FileAttribute[0]);
                    Files.write(textureFile.toPath(), byteArrayOutputStream.toByteArray(), new OpenOption[0]);
                }
            }
            catch (Exception e) {
                WaterPlayer.log("Error loading image from URL: " + url + " - " + e.getMessage());
                resourceLocationMap.put(id, WaterPlayer.Icons.NO_ICON);
                return;
            }
            class_310.method_1551().execute(() -> texture.set(new class_1043(() -> id, image)));
        }
        if (textureManager != null) {
            AlinLib.MINECRAFT.execute(() -> class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture.get()));
            resourceLocationMap.put(id, textureId);
            data = new JsonObject();
            data.addProperty("url", url);
            data.addProperty("id", id);
            if (!map.contains(data)) {
                map.add(data);
            }
        }
    }

    public static int getMinSize(int height) {
        return switch (WaterPlayer.config.getNumber("TEXTURE_HELPER.MIN_SIZE", (Number)1).intValue()) {
            case 1 -> 128;
            case 2 -> 256;
            case 3 -> 512;
            case 4 -> height;
            default -> 64;
        };
    }

    public static class_2960 getTexture$File(File file, String id) {
        if (resourceLocationMap.containsKey(id = TextureHelper.formatUrls(id.toLowerCase()))) {
            return resourceLocationMap.get(id);
        }
        if (!urls$file.getOrDefault(file, false).booleanValue()) {
            urls$file.put(file, true);
            String finalId = id;
            new Thread(() -> TextureHelper.registerTexture(Type.FILE, file.toPath().toString(), finalId, AlinLib.MINECRAFT.method_1531(), GuiUtils.getResourceLocation((String)"waterplayer", (String)finalId))).start();
        }
        return WaterPlayer.Icons.FILE_ICON;
    }

    public static void removeTexture$File(File file) {
        File fileIcon;
        String id = TextureHelper.formatUrls("local_" + file.getAbsolutePath());
        if (urlsTextures$file.containsKey(file)) {
            urlsTextures$file.remove(file);
        }
        if (resourceLocationMap.containsKey(file.toPath().toString())) {
            resourceLocationMap.remove(file.toPath().toString());
        }
        if (urls$file.containsKey(file)) {
            urls$file.remove(file);
        }
        if ((fileIcon = TextureHelper.getTextureFile(id)).exists()) {
            fileIcon.delete();
        }
        JsonObject data = new JsonObject();
        data.addProperty("url", file.toPath().toString());
        data.addProperty("id", id);
        if (map.contains(data)) {
            map.remove(data);
        }
    }

    public static class_2960 getTexture$Base64(String base, String id) {
        if (resourceLocationMap.containsKey(id = TextureHelper.formatUrls(id.toLowerCase()))) {
            return resourceLocationMap.get(id);
        }
        if (!urls$Base64.getOrDefault(id, false).booleanValue()) {
            urls$Base64.put(id, true);
            String finalId = id;
            new Thread(() -> TextureHelper.registerTexture(Type.BASE64, base, finalId, AlinLib.MINECRAFT.method_1531(), GuiUtils.getResourceLocation((String)"waterplayer", (String)finalId))).start();
        }
        return WaterPlayer.Icons.FILE_ICON;
    }

    public static void remove$Base64(String id, String base) {
        if (base != null) {
            urlsTextures$Base64.remove(base);
        }
        urls$Base64.remove(id);
        resourceLocationMap.remove(id);
        File file = TextureHelper.getTextureFile(id);
        if (file.exists()) {
            file.delete();
        }
        JsonObject data = new JsonObject();
        data.addProperty("url", base);
        data.addProperty("id", id);
        map.remove(data);
    }

    public static File getTextureFile(String url) {
        return new File(WaterPlayer.getPath() + "/textures/" + url + ".png");
    }

    public static void saveMap() {
        try {
            Path path = new File(WaterPlayer.getPath() + "/textures/map.json").toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)map.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            WaterPlayer.log(e.getLocalizedMessage(), Level.ERROR);
        }
    }

    public static void loadTextures(class_1060 textureManager) {
        TextureHelper.loadMap();
        try {
            JsonArray finalMap = map;
            for (JsonElement json2 : finalMap) {
                JsonObject data = json2.getAsJsonObject();
                class_2960 l = GuiUtils.getResourceLocation((String)"waterplayer", (String)data.get("id").getAsString());
                if (new File(data.get("url").getAsString()).exists()) {
                    TextureHelper.registerTexture(Type.FILE, data.get("url").getAsString(), data.get("id").getAsString(), textureManager, l);
                    continue;
                }
                if (data.get("id").getAsString().startsWith("playlist-") || data.get("id").getAsString().startsWith("webplaylist-")) {
                    TextureHelper.registerTexture(Type.BASE64, data.get("url").getAsString(), data.get("id").getAsString(), textureManager, l);
                    continue;
                }
                TextureHelper.registerTexture(Type.INTERNET, data.get("url").getAsString(), data.get("id").getAsString(), textureManager, l);
            }
        }
        catch (Exception e) {
            WaterPlayer.log("MAP ERROR!", Level.ERROR);
            e.printStackTrace();
        }
    }

    public static void loadMap() {
        File mapFile = new File(WaterPlayer.getPath() + "/textures/map.json");
        if (mapFile.exists() && mapFile.isFile()) {
            try {
                map = class_3518.method_43679((String)Files.readString(mapFile.toPath()));
            }
            catch (Exception e) {
                map = new JsonArray();
                WaterPlayer.log(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), Level.ERROR);
            }
        } else {
            map = new JsonArray();
        }
    }

    public static String formatUrls(String url) {
        return url.toLowerCase().replaceAll(" ", "-").replaceAll("[^A-Za-z0-9_-]", "_");
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static void removePlaylistsIconCache() {
        File directory = new File(WaterPlayer.getPath() + "/textures");
        resourceLocationMap.clear();
        urls$Base64.clear();
        urlsTextures$Base64.clear();
        ArrayList<JsonElement> removed = new ArrayList<JsonElement>();
        for (JsonElement element : map) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (!jsonObject.get("url").getAsString().equals("base64")) continue;
            removed.add(element);
        }
        for (JsonElement element : removed) {
            map.remove(element);
        }
        for (Iterator<JsonElement> iterator2 : directory.listFiles()) {
            if (!((File)((Object)iterator2)).getName().startsWith("playlist") && !((File)((Object)iterator2)).getName().startsWith("webplaylist")) continue;
            ((File)((Object)iterator2)).delete();
        }
        TextureHelper.saveMap();
    }

    public static void removeTracksCache() {
        File directory = new File(WaterPlayer.getPath() + "/textures");
        resourceLocationMap.clear();
        urls.clear();
        urlsTextures.clear();
        urls$file.clear();
        urlsTextures$file.clear();
        ArrayList<JsonElement> removed = new ArrayList<JsonElement>();
        for (JsonElement element : map) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (jsonObject.get("url").getAsString().equals("base64")) continue;
            removed.add(element);
        }
        for (JsonElement element : removed) {
            map.remove(element);
        }
        for (Iterator<JsonElement> iterator2 : directory.listFiles()) {
            if (((File)((Object)iterator2)).getName().startsWith("playlist") || ((File)((Object)iterator2)).getName().startsWith("webplaylist") || ((File)((Object)iterator2)).getName().equals("map.json")) continue;
            ((File)((Object)iterator2)).delete();
        }
        TextureHelper.saveMap();
    }

    public static enum Type {
        INTERNET(0),
        FILE(1),
        BASE64(2);

        final int type;

        private Type(Integer color) {
            this.type = color;
        }
    }
}

