/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.screens.editor;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.images.StandardArtwork;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.editbox.EditBoxBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.kelcuprum.alinlib.gui.screens.AbstractConfigScreen;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.screens.config.PlaylistsScreen;

public class TrackEditorScreen
extends class_437 {
    @NotNull
    protected final File file;
    protected AudioFile audioFile;
    public final class_437 parent;
    public Button icon;
    public int panelHeight = 0;
    boolean artworkChanged = false;
    private ConfigureScrolWidget scroller;
    private List<class_339> widgets = new ArrayList<class_339>();
    public class_2960 lastIcon = this.getIcon();

    public TrackEditorScreen(class_437 parent, File file) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.file = file;
        try {
            this.audioFile = AudioFileIO.read(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.dont_open") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
            AlinLib.MINECRAFT.method_1507(parent);
        }
    }

    protected void method_25426() {
        this.initPanel();
        this.initLyrics();
    }

    public void initPanel() {
        int x = 10;
        int size = 200;
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor")).setPosition(x, 5).setSize(size, 20).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43469((String)"waterplayer.editor.file", (Object[])new Object[]{this.file.getName()})).setPosition(x, 30).setSize(size, 20).build());
        int y = 60;
        this.icon = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43473(), s -> this.showOpenFileDialog$icon()).setSprite(this.getIcon()).setPosition(x, y).setSize(36, 36).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit.drag_and_drop"), s -> this.showOpenFileDialog$icon()).setStyle(GuiUtils.getStyleByID((String)"flat")).setPosition(x + 41, y).setSize(size - 41, 18).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit.drag_and_drop.second"), s -> this.showOpenFileDialog$icon()).setStyle(GuiUtils.getStyleByID((String)"flat")).setPosition(x + 41, y + 18).setSize(size - 41, 18).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.title"), s -> {
            try {
                this.audioFile.getTag().setField(FieldKey.TITLE, (String)s);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.error") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
                AlinLib.MINECRAFT.method_1507(this.parent);
            }
        }).setSecret(false).setValue(this.audioFile.getTag().getFirst(FieldKey.TITLE)).setPosition(x, y += 41).setSize(size, 20).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.author"), s -> {
            try {
                this.audioFile.getTag().setField(FieldKey.ARTIST, (String)s);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.error") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
                AlinLib.MINECRAFT.method_1507(this.parent);
            }
        }).setSecret(false).setValue(this.audioFile.getTag().getFirst(FieldKey.ARTIST)).setPosition(x, y += 25).setSize(size, 20).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor.save"), s -> {
            try {
                this.audioFile.commit();
                if (this.artworkChanged) {
                    this.artworkChanged = false;
                    TextureHelper.removeTexture$File(this.file);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.error") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
                AlinLib.MINECRAFT.method_1507(this.parent);
            }
        }).setPosition(x, y += 25).setSize(size, 20).build());
        TextBox msg = (TextBox)this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor.upload_text"), s -> this.showOpenFileDialog$lyrics()).setPosition(x, y += 25).setSize(size, 20).build());
        this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, e -> this.method_25419()).setPosition(x, y += 25).setSize(size, 20).build());
        this.panelHeight = y += 25;
    }

    public void initLyrics() {
        this.widgets = new ArrayList<class_339>();
        this.scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(this.field_22789 - 4, 0, 4, this.field_22790, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 5;
            for (class_339 widget : this.widgets) {
                if (widget.field_22764) {
                    widget.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
        }));
        int x = 220;
        this.widgets.add(new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor.lyrics")).setPosition(x, 5).setSize(this.field_22789 - 225, 20).build());
        if (this.audioFile.getTag().getFirst(FieldKey.LYRICS).isBlank()) {
            this.widgets.add(new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor.lyrics.no")).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, 5).setSize(this.field_22789 - 225, 20).build());
        } else {
            this.widgets.add(new TextBuilder((class_2561)class_2561.method_43470((String)this.audioFile.getTag().getFirst(FieldKey.LYRICS))).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, 5).setSize(this.field_22789 - 225, 20).build());
        }
        this.addRenderableWidgets(this.widgets);
    }

    public void method_29638(List<Path> list) {
        if (this.isValidImageType(list.get(0).toFile().getAbsolutePath())) {
            File file = list.get(0).toFile();
            try {
                if (file.exists()) {
                    this.audioFile.getTag().deleteArtworkField();
                    this.audioFile.getTag().setField(StandardArtwork.createArtworkFromFile(file));
                    this.artworkChanged = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.error") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
            }
        } else if (this.isValidLyricsType(list.get(0).toFile().getAbsolutePath())) {
            File file = list.get(0).toFile();
            try {
                if (file.exists()) {
                    this.audioFile.getTag().deleteField(FieldKey.LYRICS);
                    this.audioFile.getTag().setField(FieldKey.LYRICS, Files.readString(file.toPath()));
                    this.rebuildWidgetsList();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.dont_open") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
            }
        }
    }

    public boolean isValidImageType(String name) {
        return (name = name.toLowerCase()).endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    public boolean isValidLyricsType(String name) {
        return (name = name.toLowerCase()).endsWith(".txt") || name.endsWith(".srt") || name.endsWith(".lrc");
    }

    public void showOpenFileDialog$icon() {
        String result;
        MemoryStack stack = MemoryStack.stackPush();
        PointerBuffer filters = stack.mallocPointer(3);
        filters.put(stack.UTF8((CharSequence)"*.png"));
        filters.put(stack.UTF8((CharSequence)"*.jpg"));
        filters.put(stack.UTF8((CharSequence)"*.jpeg"));
        filters.flip();
        File defaultPath = new File(System.getProperty("user.home")).getAbsoluteFile();
        Object defaultString = defaultPath.getAbsolutePath();
        if (defaultPath.isDirectory() && !((String)defaultString).endsWith(File.separator)) {
            defaultString = (String)defaultString + File.separator;
        }
        if ((result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector.icon").getString(), (CharSequence)defaultString, (PointerBuffer)filters, (CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector.icon.filter_description").getString(), (boolean)false)) == null) {
            return;
        }
        File file = new File(result);
        WaterPlayer.log(result);
        try {
            if (file.exists()) {
                this.audioFile.getTag().deleteArtworkField();
                this.audioFile.getTag().setField(StandardArtwork.createArtworkFromFile(file));
                this.artworkChanged = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.dont_open") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
        }
    }

    public void showOpenFileDialog$lyrics() {
        String result;
        MemoryStack stack = MemoryStack.stackPush();
        PointerBuffer filters = stack.mallocPointer(3);
        filters.put(stack.UTF8((CharSequence)"*.txt"));
        filters.put(stack.UTF8((CharSequence)"*.srt"));
        filters.put(stack.UTF8((CharSequence)"*.lrc"));
        filters.flip();
        File defaultPath = new File(System.getProperty("user.home")).getAbsoluteFile();
        Object defaultString = defaultPath.getAbsolutePath();
        if (defaultPath.isDirectory() && !((String)defaultString).endsWith(File.separator)) {
            defaultString = (String)defaultString + File.separator;
        }
        if ((result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector.lyrics").getString(), (CharSequence)defaultString, (PointerBuffer)filters, (CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector.lyrics.filter_description").getString(), (boolean)false)) == null) {
            return;
        }
        File file = new File(result);
        WaterPlayer.log(result);
        try {
            if (file.exists()) {
                this.audioFile.getTag().deleteField(FieldKey.LYRICS);
                this.audioFile.getTag().setField(FieldKey.LYRICS, Files.readString(file.toPath()));
                this.rebuildWidgetsList();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WaterPlayer.getToast().setIcon(Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)(ex.getMessage() == null ? class_2561.method_43471((String)"waterplayer.editor.dont_open") : class_2561.method_43470((String)ex.getMessage()))).buildAndShow();
            AlinLib.MINECRAFT.method_1507(this.parent);
        }
    }

    protected void addRenderableWidgets(@NotNull List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.method_37063((class_364)widget);
        }
    }

    public class_2960 getIcon() {
        if (this.file == null || !this.file.exists()) {
            return WaterPlayer.Icons.NO_ICON;
        }
        return TextureHelper.getTexture$File(this.file, "local_" + this.file.getAbsolutePath());
    }

    public void method_25393() {
        if (this.lastIcon != this.getIcon()) {
            this.lastIcon = this.getIcon();
            this.method_37066((class_364)this.icon);
            this.icon = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43473(), s -> this.showOpenFileDialog$icon()).setSprite(this.getIcon()).setPosition(10, 60).setSize(36, 36).build());
        }
        if (this.scroller != null) {
            this.scroller.onScroll.accept(this.scroller);
        }
        super.method_25393();
    }

    protected void rebuildWidgetsList() {
        this.method_37066((class_364)this.scroller);
        this.scroller = null;
        for (class_339 widget : this.widgets) {
            this.method_37066((class_364)widget);
        }
        this.initLyrics();
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 5, 5, 215, 25);
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 5, 30, 215, 50);
        GuiUtils.getSelected().renderBackground(guiGraphics, 5, 55, 215, this.panelHeight);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!scr && this.scroller != null) {
            scr = this.scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25419() {
        if (this.parent instanceof AbstractConfigScreen) {
            PlaylistsScreen.assetsSize = 0;
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256 && this.method_25399() != null && this.method_25399().method_25370()) {
            this.method_25399().method_25365(false);
            return true;
        }
        return super.method_25404(i, j, k);
    }
}

