/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.screens.playlist;

import com.google.gson.JsonElement;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBooleanBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.editbox.EditBoxBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.screens.playlist.ConfirmAddedFiles;
import ru.kelcuprum.waterplayer.frontend.gui.screens.playlist.ViewPlaylistScreen;

public class EditPlaylistScreen
extends class_437 {
    @NotNull
    protected final Playlist playlist;
    private class_437 parent;
    boolean isEnable = false;
    boolean isInit = false;
    public Button icon;
    public boolean isDeleted = false;
    public int maxY = 35;
    private ConfigureScrolWidget scroller;
    private List<class_339> widgets = new ArrayList<class_339>();
    public class_2960 lastIcon = this.getIcon();
    private int lastSize = 0;

    public EditPlaylistScreen(class_437 parent, @NotNull Playlist playlist) {
        super((class_2561)class_2561.method_43473());
        this.playlist = playlist;
        this.parent = parent;
    }

    public void showOpenFileDialog() {
        String result;
        MemoryStack stack = MemoryStack.stackPush();
        PointerBuffer filters = stack.mallocPointer(3);
        filters.put(stack.UTF8((CharSequence)"*.png"));
        filters.put(stack.UTF8((CharSequence)"*.jpg"));
        filters.put(stack.UTF8((CharSequence)"*.jpeg"));
        filters.flip();
        File defaultPath = new File(System.getProperty("user.home")).getAbsoluteFile();
        Object defaultString = defaultPath.getAbsolutePath();
        if (defaultPath.isDirectory() && !((String)defaultString).endsWith(File.separator)) {
            defaultString = (String)defaultString + File.separator;
        }
        if ((result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2561.method_43471((String)"waterplayer.playlist.edit.filedialog.title").getString(), (CharSequence)defaultString, (PointerBuffer)filters, (CharSequence)class_2561.method_43471((String)"waterplayer.playlist.edit.filedialog.filter_description").getString(), (boolean)false)) == null) {
            return;
        }
        File file = new File(result);
        WaterPlayer.log(result);
        if (file.exists()) {
            this.playlist.setIcon(file);
        }
    }

    public void method_29638(List<Path> list) {
        if (this.isValidImageType(list.get(0).toFile().getAbsolutePath())) {
            File file = list.get(0).toFile();
            WaterPlayer.log(file.getName());
            if (file.exists()) {
                this.playlist.setIcon(file);
            }
        } else if (list.size() == 1) {
            this.playlist.addUrl(list.get(0).toString());
        } else {
            AlinLib.MINECRAFT.method_1507((class_437)new ConfirmAddedFiles(list, this, this.playlist));
        }
    }

    public boolean isValidImageType(String name) {
        return (name = name.toLowerCase()).endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    protected void method_25426() {
        this.initPanel();
        this.initTracks();
    }

    public void initPanel() {
        int x = 10;
        int size = 200;
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit")).setPosition(x, 5).setSize(size, 20).build());
        int y = 35;
        this.icon = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43473(), s -> this.showOpenFileDialog()).setSprite(this.getIcon()).setPosition(x, y).setSize(36, 36).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit.drag_and_drop"), s -> this.showOpenFileDialog()).setStyle(GuiUtils.getStyleByID((String)"flat")).setPosition(x + 41, y).setSize(size - 41, 18).build());
        this.method_37063((class_364)new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.edit.drag_and_drop.second"), s -> this.showOpenFileDialog()).setStyle(GuiUtils.getStyleByID((String)"flat")).setPosition(x + 41, y + 18).setSize(size - 41, 18).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.title"), s -> {
            this.playlist.title = s;
            this.playlist.save();
        }).setSecret(false).setValue(this.playlist.title).setPosition(x, y += 41).setSize(size, 20).build());
        this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.author"), s -> {
            this.playlist.author = s;
            this.playlist.save();
        }).setSecret(false).setValue(this.playlist.author).setPosition(x, y += 25).setSize(size, 20).build());
        this.method_37063((class_364)new ButtonBooleanBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.public"), this.playlist.isPublic.booleanValue(), s -> {
            this.playlist.isPublic = s;
            this.playlist.save();
        }).setSize(size, 20).setPosition(x, y += 25).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.save"), s -> {
            this.playlist.save();
            this.method_25419();
        }).setPosition(x, y += 25).setSize(size, 20).build());
        this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, e -> this.method_25419()).setPosition(x, y += 25).setSize(size - 25, 20).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.remove"), s -> {
            this.playlist.path.toFile().delete();
            this.isDeleted = true;
            if (this.parent instanceof ViewPlaylistScreen) {
                this.parent = ((ViewPlaylistScreen)this.parent).parent;
                this.method_25419();
            }
        }).setSprite(WaterPlayer.Icons.RECYCLE_BIN).setPosition(x + size - 20, y).setSize(20, 20).build());
        this.maxY = y += 25;
    }

    public void initTracks() {
        this.widgets = new ArrayList<class_339>();
        this.scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(this.field_22789 - 4, 0, 4, this.field_22790, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 5;
            for (class_339 widget : this.widgets) {
                if (widget.field_22764) {
                    widget.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
        }));
        int x = 220;
        this.widgets.add(new TextBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.urls")).setPosition(x, 5).setSize(this.field_22789 - 225, 20).build());
        int i = 0;
        for (JsonElement element : this.playlist.getUrlsJSON()) {
            String url = element.getAsString();
            int finalI = i;
            this.widgets.add(new EditBoxBuilder((class_2561)class_2561.method_43470((String)String.format("%s. ", i + 1)), s -> {
                this.playlist.setUrl((String)s, finalI);
                this.playlist.save();
            }).setSecret(false).setValue(url).setPosition(x, -20).setSize(this.field_22789 - 230, 20).build());
            ++i;
        }
        this.widgets.add(new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlist.add"), e -> {
            this.playlist.urls.add("https://youtube.com/");
            this.playlist.save();
        }).setIcon(Icons.ADD).setPosition(x, -20).setSize(this.field_22789 - 225, 20).build());
        this.addRenderableWidgets(this.widgets);
    }

    protected void addRenderableWidgets(@NotNull List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.method_37063((class_364)widget);
        }
    }

    public class_2960 getIcon() {
        if (this.playlist == null) {
            return WaterPlayer.Icons.NO_PLAYLIST_ICON;
        }
        return this.playlist.icon == null ? WaterPlayer.Icons.NO_PLAYLIST_ICON : TextureHelper.getTexture$Base64(this.playlist.icon, String.format("playlist-%s", this.playlist.fileName));
    }

    public void method_25393() {
        if (this.lastIcon != this.getIcon()) {
            this.lastIcon = this.getIcon();
            this.method_37066((class_364)this.icon);
            this.icon = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43473(), s -> this.showOpenFileDialog()).setSprite(this.getIcon()).setPosition(10, 35).setSize(36, 36).build());
        }
        if (this.scroller != null) {
            this.scroller.onScroll.accept(this.scroller);
        }
        if (!(this.lastSize == this.playlist.getUrlsJSON().size() || this.method_25399() != null && this.method_25399().method_25370() && this.method_25399() instanceof class_342)) {
            this.lastSize = this.playlist.getUrlsJSON().size();
            this.rebuildWidgetsList();
        }
        super.method_25393();
    }

    protected void rebuildWidgetsList() {
        this.method_37066((class_364)this.scroller);
        this.scroller = null;
        for (class_339 widget : this.widgets) {
            this.method_37066((class_364)widget);
        }
        this.initTracks();
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 5, 5, 215, 25);
        GuiUtils.getSelected().renderBackground(guiGraphics, 5, 30, 215, this.maxY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!scr && this.scroller != null) {
            scr = this.scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25419() {
        if (!this.isDeleted) {
            this.playlist.save();
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256 && this.method_25399() != null && this.method_25399().method_25370()) {
            this.method_25399().method_25365(false);
            return true;
        }
        return super.method_25404(i, j, k);
    }
}

