/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.localization;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.File;
import java.util.HashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.TrackScheduler;
import ru.kelcuprum.waterplayer.backend.WaterPlayerAPI;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;

public class MusicHelper {
    private static final HashMap<String, Boolean> noFiles = new HashMap();
    private static final HashMap<AudioTrack, String> apiResponse = new HashMap();
    private static final HashMap<AudioTrack, Boolean> apiURLS = new HashMap();

    public static boolean trackIsNull() {
        return MusicHelper.trackIsNull(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static boolean trackIsNull(AudioTrack track) {
        return track == null;
    }

    public static boolean isAuthorNull(AudioTrack info) {
        return MusicHelper.trackIsNull(info) || info.getInfo().author.isBlank() || info.getInfo().author.equals("Unknown artist") || info.getInfo().author.equals("Unknown");
    }

    public static boolean isAuthorNull() {
        return MusicHelper.isAuthorNull(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static String getAuthor(AudioTrack info) {
        String author;
        String string = author = MusicHelper.isAuthorNull(info) ? "" : info.getInfo().author;
        if (author.endsWith(" - Topic")) {
            author = author.replace(" - Topic", "");
        }
        return author;
    }

    public static String getAuthor() {
        return MusicHelper.getAuthor(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static boolean isTitleNull(AudioTrack info) {
        return MusicHelper.trackIsNull(info) || info.getInfo().title.isBlank() || info.getInfo().title.equals("Unknown title");
    }

    public static String getTitle(AudioTrack info) {
        if (MusicHelper.trackIsNull(info)) {
            return "";
        }
        String[] fileArgs = info.getInfo().uri.split("/");
        if (fileArgs.length == 1) {
            fileArgs = info.getInfo().uri.split("\\\\");
        }
        String file = fileArgs[fileArgs.length - 1];
        return MusicHelper.isTitleNull(info) ? file : info.getInfo().title;
    }

    public static String getTitle() {
        return MusicHelper.getTitle(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static int getVolume() {
        return WaterPlayer.player.getVolume();
    }

    public static String getSpeakerVolume() {
        return MusicHelper.getVolume() <= 0 ? "\ud83d\udd07" : (MusicHelper.getVolume() <= 1 ? "\ud83d\udd08" : (MusicHelper.getVolume() <= 70 ? "\ud83d\udd09" : "\ud83d\udd0a"));
    }

    public static class_2960 getSpeakerVolumeIcon() {
        return MusicHelper.getVolume() <= 0 ? WaterPlayer.Icons.VOLUME_MUTE : (MusicHelper.getVolume() <= 1 ? WaterPlayer.Icons.VOLUME_LOW : (MusicHelper.getVolume() <= 70 ? WaterPlayer.Icons.VOLUME_OK : WaterPlayer.Icons.VOLUME_MAX));
    }

    public static String getRepeatState() {
        return WaterPlayer.player.getTrackScheduler().getRepeatStatus() == 0 ? "" : (WaterPlayer.player.getTrackScheduler().getRepeatStatus() == 1 ? " \ud83d\udd01" : " \ud83d\udd02");
    }

    public static String getPauseState() {
        return WaterPlayer.player.isPaused() ? "\u23f8" : "\u25b6";
    }

    public static boolean isFile(AudioTrack info) {
        if (MusicHelper.trackIsNull(info)) {
            return false;
        }
        if (noFiles.containsKey(info.getInfo().uri)) {
            return noFiles.getOrDefault(info.getInfo().uri, false);
        }
        File track = new File(info.getInfo().uri);
        boolean state = track.exists() && track.isFile();
        noFiles.put(info.getInfo().uri, state);
        return state;
    }

    public static class_2960 getThumbnail() {
        return MusicHelper.trackIsNull() ? WaterPlayer.Icons.NO_ICON : MusicHelper.getThumbnail(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    private static String getApiIcon(AudioTrack info) {
        if (apiResponse.containsKey(info)) {
            return apiResponse.get(info);
        }
        if (!apiURLS.getOrDefault(info, false).booleanValue()) {
            apiURLS.put(info, true);
            new Thread(() -> {
                String icon = WaterPlayerAPI.getArtwork(info);
                apiResponse.put(info, icon);
            }).start();
        }
        return "notloaded";
    }

    public static class_2960 getThumbnail(AudioTrack info) {
        String icon;
        if (MusicHelper.trackIsNull(info)) {
            return WaterPlayer.Icons.NO_ICON;
        }
        if (MusicHelper.isFile(info) && !TextureHelper.urlsTextures.containsKey(info.getInfo().uri)) {
            return TextureHelper.getTexture$File(new File(info.getInfo().uri), info.getSourceManager().getSourceName() + "_" + info.getInfo().identifier);
        }
        String string = icon = info.getInfo().artworkUrl == null ? info.getInfo().uri : info.getInfo().artworkUrl;
        if (WaterPlayer.config.getBoolean("API.REPLACE_ARTWORK", false) && !MusicHelper.isAuthorNull(info) && !MusicHelper.isTitleNull(info)) {
            String apiIcon = MusicHelper.getApiIcon(info);
            if (apiIcon.startsWith("notloaded")) {
                return WaterPlayer.Icons.NO_ICON;
            }
            return TextureHelper.getTexture(apiIcon.isBlank() ? icon : apiIcon, (apiIcon.isBlank() ? "" : "wpapi-artwork_") + info.getSourceManager().getSourceName() + "_" + info.getInfo().identifier);
        }
        return TextureHelper.getTexture(icon, info.getSourceManager().getSourceName() + "_" + info.getInfo().identifier);
    }

    public static boolean isFile() {
        return MusicHelper.trackIsNull() || MusicHelper.isFile(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static long getPosition(AudioTrack track) {
        if (WaterPlayer.config.getBoolean("EXPERIMENT.FILTERS", false) && TrackScheduler.trackSpeed != 1.0 && WaterPlayer.player.getAudioPlayer().getPlayingTrack() == track) {
            return TrackScheduler.trackPosition;
        }
        return MusicHelper.trackIsNull(track) ? 0L : track.getPosition();
    }

    public static long getPosition() {
        return MusicHelper.getPosition(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static long getDuration(AudioTrack track) {
        return MusicHelper.trackIsNull(track) ? 0L : track.getDuration();
    }

    public static long getDuration() {
        return MusicHelper.getDuration(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static String getService(AudioTrack track) {
        return MusicHelper.trackIsNull(track) ? "" : track.getSourceManager().getSourceName();
    }

    public static String getService() {
        return MusicHelper.getService(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static class_2561 getServiceName(String service) {
        return switch (service.toLowerCase()) {
            case "youtube" -> class_2561.method_43471((String)"waterplayer.config.services.youtube");
            case "soundcloud" -> class_2561.method_43471((String)"waterplayer.config.services.soundcloud");
            case "bandcamp" -> class_2561.method_43471((String)"waterplayer.config.services.bandcamp");
            case "vimeo" -> class_2561.method_43471((String)"waterplayer.config.services.vimeo");
            case "twitch" -> class_2561.method_43471((String)"waterplayer.config.services.twitch");
            case "beam.pro" -> class_2561.method_43471((String)"waterplayer.config.services.beam");
            case "vkmusic" -> class_2561.method_43471((String)"waterplayer.config.services.vk");
            case "yandexmusic" -> class_2561.method_43471((String)"waterplayer.config.services.yandex");
            case "spotify" -> class_2561.method_43471((String)"waterplayer.config.services.spotify");
            case "deezer" -> class_2561.method_43471((String)"waterplayer.config.services.deezer");
            case "applemusic" -> class_2561.method_43471((String)"waterplayer.config.services.apple");
            case "flowery-tts" -> class_2561.method_43471((String)"waterplayer.config.services.flowery");
            case "http" -> class_2561.method_43471((String)"waterplayer.config.services.http");
            case "local" -> class_2561.method_43471((String)"waterplayer.config.services.local");
            default -> class_2561.method_43470((String)service);
        };
    }

    public static boolean getIsLive() {
        return MusicHelper.getIsLive(WaterPlayer.player.getAudioPlayer().getPlayingTrack());
    }

    public static boolean getIsLive(AudioTrack track) {
        return !MusicHelper.trackIsNull(track) && WaterPlayer.player.getAudioPlayer().getPlayingTrack().getInfo().isStream;
    }
}

