/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.tremolo;

import com.github.natanbc.lavadsp.util.FloatToFloatFunction;
import com.github.natanbc.lavadsp.util.VectorSupport;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class TremoloPcmAudioFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private final int sampleRate;
    private final float[] phases;
    private float frequency = 2.0f;
    private float depth = 0.5f;

    public TremoloPcmAudioFilter(FloatPcmAudioFilter downstream, int channelCount, int sampleRate) {
        if (sampleRate < 1) {
            throw new IllegalArgumentException("Sample rate < 1");
        }
        this.downstream = downstream;
        this.sampleRate = sampleRate;
        this.phases = new float[channelCount];
    }

    public float getFrequency() {
        return this.frequency;
    }

    public TremoloPcmAudioFilter setFrequency(float frequency) {
        if (frequency <= 0.0f) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        this.frequency = frequency;
        return this;
    }

    public TremoloPcmAudioFilter updateFrequency(FloatToFloatFunction function) {
        return this.setFrequency(function.apply(this.frequency));
    }

    public float getDepth() {
        return this.depth * 2.0f;
    }

    public TremoloPcmAudioFilter setDepth(float depth) {
        if (depth <= 0.0f) {
            throw new IllegalArgumentException("Depth <= 0");
        }
        if (depth > 1.0f) {
            throw new IllegalArgumentException("Depth > 1");
        }
        this.depth = depth / 2.0f;
        return this;
    }

    public TremoloPcmAudioFilter updateDepth(FloatToFloatFunction function) {
        return this.setDepth(function.apply(this.depth * 2.0f));
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        for (int channel = 0; channel < input.length; ++channel) {
            this.phases[channel] = VectorSupport.tremolo(input[channel], offset, length, this.sampleRate, this.frequency, this.depth, this.phases[channel]);
        }
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

