/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasearch;

import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SearchManager {
    private final List<AudioSearchManager> searchManagers = new ArrayList<AudioSearchManager>();

    public void registerSearchManager(AudioSearchManager sourceManager) {
        this.searchManagers.add(sourceManager);
    }

    @Nullable
    public <T extends AudioSearchManager> T search(Class<T> klass) {
        for (AudioSearchManager sourceManager : this.searchManagers) {
            if (!klass.isAssignableFrom(sourceManager.getClass())) continue;
            return (T)((AudioSearchManager)klass.cast(sourceManager));
        }
        return null;
    }

    public List<AudioSearchManager> getSearchManagers() {
        return this.searchManagers;
    }

    public void shutdown() {
        for (AudioSearchManager sourceManager : this.searchManagers) {
            sourceManager.shutdown();
        }
    }

    @Nullable
    public AudioSearchResult loadSearch(String query, Set<AudioSearchResult.Type> types) {
        if (this.searchManagers.isEmpty()) {
            throw new IllegalStateException("No search managers registered");
        }
        for (AudioSearchManager sourceManager : this.searchManagers) {
            AudioSearchResult searchResults = sourceManager.loadSearch(query, types);
            if (searchResults == null) continue;
            return searchResults;
        }
        return null;
    }
}

