/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.lrclib;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.lyrics.BasicAudioLyrics;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LrcLibLyricsManager
implements AudioLyricsManager {
    private static final String API_BASE = "https://lrclib.net/api/";
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();

    @Override
    @NotNull
    public String getSourceName() {
        return "";
    }

    @Override
    @Nullable
    public AudioLyrics loadLyrics(@NotNull AudioTrack audioTrack) {
        try {
            return this.searchLyrics(null, audioTrack.getInfo().title, audioTrack.getInfo().author, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AudioLyrics searchLyrics(String query, String trackName, String artistName, String albumName) throws IOException {
        JsonBrowser json2;
        URI uri;
        try {
            URIBuilder uriBuilder = new URIBuilder("https://lrclib.net/api/search");
            if (query != null) {
                uriBuilder.addParameter("q", query);
            }
            if (trackName != null) {
                uriBuilder.addParameter("track_name", trackName);
            }
            if (artistName != null) {
                uriBuilder.addParameter("artist_name", artistName);
            }
            if (albumName != null) {
                uriBuilder.addParameter("album_name", albumName);
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            json2 = LavaSrcTools.fetchResponseAsJson(httpInterface, new HttpGet(uri));
        }
        if (json2 == null || json2.values().isEmpty()) {
            return null;
        }
        JsonBrowser result = json2.index(0);
        String lyricsText = result.get("plainLyrics").text();
        ArrayList<AudioLyrics.Line> lyrics = new ArrayList<AudioLyrics.Line>();
        for (String line : result.get("syncedLyrics").safeText().split("\\n")) {
            Duration timestamp;
            String timePart;
            String[] timeParts;
            String[] parts = line.split(" ", 2);
            if (parts.length < 2 || (timeParts = (timePart = parts[0].substring(1, parts[0].length() - 1)).split(":")).length != 2) continue;
            try {
                timestamp = Duration.ofMinutes(Integer.parseInt(timeParts[0])).plusMillis((long)(Double.parseDouble(timeParts[1]) * 1000.0));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid timestamp format: " + timePart, e);
            }
            lyrics.add(new BasicAudioLyrics.BasicLine(timestamp, null, parts[1]));
        }
        return new BasicAudioLyrics("LRCLIB", "LRCLIB", lyricsText, lyrics);
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

