/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePayloadHelper;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import org.json.JSONObject;

public class YoutubeClientConfig
extends JSONObject {
    public static final AndroidVersion DEFAULT_ANDROID_VERSION = AndroidVersion.ANDROID_11;
    public static YoutubeClientConfig ANDROID = new YoutubeClientConfig().withApiKey("AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w").withUserAgent(String.format("com.google.android.youtube/%s (Linux; U; Android %s) gzip", "18.06.35", DEFAULT_ANDROID_VERSION.getOsVersion())).withClientName("ANDROID").withClientField("clientVersion", "18.06.35").withClientField("androidSdkVersion", DEFAULT_ANDROID_VERSION.getSdkVersion()).withClientDefaultScreenParameters();
    public static YoutubeClientConfig TV_EMBEDDED = new YoutubeClientConfig().withApiKey("AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8").withClientName("TVHTML5_SIMPLY_EMBEDDED_PLAYER").withClientField("clientVersion", "2.0").withClientField("clientScreen", "EMBED").withClientDefaultScreenParameters().withThirdPartyEmbedUrl("https://google.com");
    public static YoutubeClientConfig WEB = new YoutubeClientConfig().withApiKey("AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8").withClientName("WEB").withClientField("clientVersion", "2.20220801.00.00");
    public static YoutubeClientConfig MUSIC = new YoutubeClientConfig().withApiKey("AIzaSyC9XL3ZjWddXya6X74dJoCTL-WEYFDNX30").withClientName("WEB_REMIX").withClientField("clientVersion", "1.20220727.01.00");
    private String name;
    private String userAgent;
    private String apiKey;
    private final JSONObject root;

    public YoutubeClientConfig() {
        this.root = new JSONObject();
        this.userAgent = null;
        this.name = null;
    }

    private YoutubeClientConfig(JSONObject context, String userAgent, String name) {
        this.root = context;
        this.userAgent = userAgent;
        this.name = name;
    }

    public YoutubeClientConfig copy() {
        return new YoutubeClientConfig(new JSONObject(this.root.toMap()), this.userAgent, this.name);
    }

    public YoutubeClientConfig withClientName(String name) {
        this.name = name;
        this.withClientField("clientName", name);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public YoutubeClientConfig withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public YoutubeClientConfig withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public YoutubeClientConfig withClientDefaultScreenParameters() {
        this.withClientField("screenDensityFloat", 1);
        this.withClientField("screenHeightPoints", 1080);
        this.withClientField("screenPixelDensity", 1);
        return this.withClientField("screenWidthPoints", 1920);
    }

    public YoutubeClientConfig withThirdPartyEmbedUrl(String embedUrl) {
        JSONObject context = YoutubePayloadHelper.putOnceAndJoin(this.root, "context");
        JSONObject thirdParty = YoutubePayloadHelper.putOnceAndJoin(context, "thirdParty");
        thirdParty.put("embedUrl", embedUrl);
        return this;
    }

    public YoutubeClientConfig withPlaybackSignatureTimestamp(String signatureTimestamp) {
        JSONObject playbackContext = YoutubePayloadHelper.putOnceAndJoin(this.root, "playbackContext");
        JSONObject contentPlaybackContext = YoutubePayloadHelper.putOnceAndJoin(playbackContext, "contentPlaybackContext");
        contentPlaybackContext.put("signatureTimestamp", signatureTimestamp);
        return this;
    }

    public YoutubeClientConfig withRootField(String key, Object value) {
        this.root.put(key, value);
        return this;
    }

    public YoutubeClientConfig withClientField(String key, Object value) {
        JSONObject context = YoutubePayloadHelper.putOnceAndJoin(this.root, "context");
        JSONObject client = YoutubePayloadHelper.putOnceAndJoin(context, "client");
        client.put(key, value);
        return this;
    }

    public YoutubeClientConfig withUserField(String key, Object value) {
        JSONObject context = YoutubePayloadHelper.putOnceAndJoin(this.root, "context");
        JSONObject user = YoutubePayloadHelper.putOnceAndJoin(context, "user");
        user.put(key, value);
        return this;
    }

    public YoutubeClientConfig setAttribute(HttpInterface httpInterface) {
        if (this.userAgent != null) {
            httpInterface.getContext().setAttribute("isUserAgentSpecified", this.userAgent);
        }
        return this;
    }

    public String toJsonString() {
        return this.root.toString();
    }

    public static enum AndroidVersion {
        ANDROID_11("11", 30);

        private final String osVersion;
        private final int sdkVersion;

        private AndroidVersion(String osVersion, int sdkVersion) {
            this.osVersion = osVersion;
            this.sdkVersion = sdkVersion;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public int getSdkVersion() {
            return this.sdkVersion;
        }
    }
}

