/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.InputStream;

public class ResettableBoundedInputStream
extends InputStream {
    private final InputStream delegate;
    private long limit;
    private long position;

    public ResettableBoundedInputStream(InputStream delegate) {
        this.delegate = delegate;
        this.limit = Long.MAX_VALUE;
        this.position = 0L;
    }

    public void resetLimit(long limit) {
        this.position = 0L;
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.limit) {
            return -1;
        }
        int result = this.delegate.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.position >= this.limit) {
            return -1;
        }
        int chunk = (int)Math.min((long)length, this.limit - this.position);
        int read = this.delegate.read(buffer, offset, chunk);
        if (read == -1) {
            return -1;
        }
        this.position += (long)read;
        return read;
    }

    @Override
    public long skip(long distance) throws IOException {
        int chunk = (int)Math.min(distance, this.limit - this.position);
        long skipped = this.delegate.skip(chunk);
        this.position += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.limit - this.position, (long)this.delegate.available());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

