/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.audio.ogg.util.VorbisPacketType;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public Tag read(RandomAccessFile raf) throws CannotReadException, IOException {
        byte[] rawVorbisCommentData = this.readRawPacketData(raf);
        VorbisCommentTag tag = this.vorbisCommentReader.read(rawVorbisCommentData, true, null);
        return tag;
    }

    public int readOggVorbisRawSize(RandomAccessFile raf) throws CannotReadException, IOException {
        byte[] rawVorbisCommentData = this.readRawPacketData(raf);
        return rawVorbisCommentData.length + 1 + 6;
    }

    public byte[] readRawPacketData(RandomAccessFile raf) throws CannotReadException, IOException {
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
        pageHeader = OggPageHeader.read(raf);
        byte[] b = new byte[7];
        raf.read(b);
        if (!this.isVorbisCommentHeader(b)) {
            throw new CannotReadException("Cannot find comment block (no vorbiscomment header)");
        }
        byte[] rawVorbisCommentData = this.convertToVorbisCommentPacket(pageHeader, raf);
        return rawVorbisCommentData;
    }

    public boolean isVorbisCommentHeader(byte[] headerData) {
        String vorbis = new String(headerData, 1, 6, StandardCharsets.ISO_8859_1);
        return headerData[0] == VorbisPacketType.COMMENT_HEADER.getType() && vorbis.equals("vorbis");
    }

    public boolean isVorbisSetupHeader(byte[] headerData) {
        String vorbis = new String(headerData, 1, 6, StandardCharsets.ISO_8859_1);
        return headerData[0] == VorbisPacketType.SETUP_HEADER.getType() && vorbis.equals("vorbis");
    }

    private byte[] convertToVorbisCommentPacket(OggPageHeader startVorbisCommentPage, RandomAccessFile raf) throws IOException, CannotReadException {
        OggPageHeader nextPageHeader;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[startVorbisCommentPage.getPacketList().get(0).getLength() - 7];
        raf.read(b);
        baos.write(b);
        if (startVorbisCommentPage.getPacketList().size() > 1) {
            return baos.toByteArray();
        }
        if (!startVorbisCommentPage.isLastPacketIncomplete()) {
            return baos.toByteArray();
        }
        do {
            nextPageHeader = OggPageHeader.read(raf);
            b = new byte[nextPageHeader.getPacketList().get(0).getLength()];
            raf.read(b);
            baos.write(b);
            if (nextPageHeader.getPacketList().size() <= 1) continue;
            return baos.toByteArray();
        } while (nextPageHeader.isLastPacketIncomplete());
        return baos.toByteArray();
    }

    public byte[] convertToVorbisSetupHeaderPacket(long fileOffsetOfStartingOggPage, RandomAccessFile raf) throws IOException, CannotReadException {
        OggPageHeader nextPageHeader;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        raf.seek(fileOffsetOfStartingOggPage);
        OggPageHeader setupPageHeader = OggPageHeader.read(raf);
        if (setupPageHeader.getPacketList().size() > 1) {
            raf.skipBytes(setupPageHeader.getPacketList().get(0).getLength());
        }
        byte[] b = new byte[7];
        raf.read(b);
        if (!this.isVorbisSetupHeader(b)) {
            throw new CannotReadException("Unable to find setup header(2), unable to write ogg file");
        }
        raf.seek(raf.getFilePointer() - 7L);
        if (setupPageHeader.getPacketList().size() > 1) {
            b = new byte[setupPageHeader.getPacketList().get(1).getLength()];
            raf.read(b);
            baos.write(b);
        } else {
            b = new byte[setupPageHeader.getPacketList().get(0).getLength()];
            raf.read(b);
            baos.write(b);
        }
        if (!setupPageHeader.isLastPacketIncomplete() || setupPageHeader.getPacketList().size() > 2) {
            return baos.toByteArray();
        }
        do {
            nextPageHeader = OggPageHeader.read(raf);
            b = new byte[nextPageHeader.getPacketList().get(0).getLength()];
            raf.read(b);
            baos.write(b);
            if (nextPageHeader.getPacketList().size() <= 1) continue;
            return baos.toByteArray();
        } while (nextPageHeader.isLastPacketIncomplete());
        return baos.toByteArray();
    }

    public byte[] convertToVorbisSetupHeaderPacketAndAdditionalPackets(long fileOffsetOfStartingOggPage, RandomAccessFile raf) throws IOException, CannotReadException {
        OggPageHeader nextPageHeader;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        raf.seek(fileOffsetOfStartingOggPage);
        OggPageHeader setupPageHeader = OggPageHeader.read(raf);
        if (setupPageHeader.getPacketList().size() > 1) {
            raf.skipBytes(setupPageHeader.getPacketList().get(0).getLength());
        }
        byte[] b = new byte[7];
        raf.read(b);
        if (!this.isVorbisSetupHeader(b)) {
            throw new CannotReadException("Unable to find setup header(2), unable to write ogg file");
        }
        raf.seek(raf.getFilePointer() - 7L);
        if (setupPageHeader.getPacketList().size() > 1) {
            b = new byte[setupPageHeader.getPacketList().get(1).getLength()];
            raf.read(b);
            baos.write(b);
        } else {
            b = new byte[setupPageHeader.getPacketList().get(0).getLength()];
            raf.read(b);
            baos.write(b);
        }
        if (!setupPageHeader.isLastPacketIncomplete() || setupPageHeader.getPacketList().size() > 2) {
            if (setupPageHeader.getPacketList().size() > 2) {
                for (int i = 2; i < setupPageHeader.getPacketList().size(); ++i) {
                    b = new byte[setupPageHeader.getPacketList().get(i).getLength()];
                    raf.read(b);
                    baos.write(b);
                }
            }
            return baos.toByteArray();
        }
        do {
            nextPageHeader = OggPageHeader.read(raf);
            b = new byte[nextPageHeader.getPacketList().get(0).getLength()];
            raf.read(b);
            baos.write(b);
            if (nextPageHeader.getPacketList().size() <= 1) continue;
            return baos.toByteArray();
        } while (nextPageHeader.isLastPacketIncomplete());
        return baos.toByteArray();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public OggVorbisHeaderSizes readOggVorbisHeaderSizes(RandomAccessFile raf) throws CannotReadException, IOException {
        block15: {
            filepointer = raf.getFilePointer();
            extraPackets /* !! */  = new ArrayList<E>();
            commentHeaderSize = 0;
            pageHeader = OggPageHeader.read(raf);
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
            pageHeader = OggPageHeader.read(raf);
            commentHeaderStartPosition = raf.getFilePointer() - (long)(27 + pageHeader.getSegmentTable().length);
            b = new byte[7];
            raf.read(b);
            if (!this.isVorbisCommentHeader(b)) {
                throw new CannotReadException("Cannot find comment block (no vorbiscomment header)");
            }
            raf.seek(raf.getFilePointer() - 7L);
            while (true) {
                packetList = pageHeader.getPacketList();
                commentHeaderSize += packetList.get(0).getLength();
                raf.skipBytes(packetList.get(0).getLength());
                if (packetList.size() > 1 || !pageHeader.isLastPacketIncomplete()) break;
                pageHeader = OggPageHeader.read(raf);
            }
            if (pageHeader.getPacketList().size() != 1) ** GOTO lbl52
            pageHeader = OggPageHeader.read(raf);
            packetList = pageHeader.getPacketList();
            packet = pageHeader.getPacketList().get(0);
            b = new byte[7];
            raf.read(b);
            if (!this.isVorbisSetupHeader(b)) {
                throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_VORBIS_HEADER_FOUND.getMsg());
            }
            raf.seek(raf.getFilePointer() - 7L);
            setupHeaderStartPosition = raf.getFilePointer() - (long)(27 + pageHeader.getSegmentTable().length);
            setupHeaderSize = packet.getLength();
            raf.skipBytes(packet.getLength());
            if (packetList.size() > 1 || !pageHeader.isLastPacketIncomplete()) {
                if (packetList.size() > 1) {
                    extraPackets /* !! */  = packetList.subList(1, packetList.size());
                }
            } else {
                pageHeader = OggPageHeader.read(raf);
                packetList = pageHeader.getPacketList();
                while (true) {
                    setupHeaderSize += packetList.get(0).getLength();
                    raf.skipBytes(packetList.get(0).getLength());
                    if (packetList.size() > 1 || !pageHeader.isLastPacketIncomplete()) {
                        if (packetList.size() > 1) {
                            extraPackets /* !! */  = packetList.subList(1, packetList.size());
                        }
                        break block15;
                    }
                    pageHeader = OggPageHeader.read(raf);
                }
lbl52:
                // 1 sources

                packet = pageHeader.getPacketList().get(1);
                packetList = pageHeader.getPacketList();
                b = new byte[7];
                raf.read(b);
                if (!this.isVorbisSetupHeader(b)) {
                    throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_VORBIS_HEADER_FOUND.getMsg());
                }
                raf.seek(raf.getFilePointer() - 7L);
                setupHeaderStartPosition = raf.getFilePointer() - (long)(27 + pageHeader.getSegmentTable().length) - (long)pageHeader.getPacketList().get(0).getLength();
                setupHeaderSize = packet.getLength();
                raf.skipBytes(packet.getLength());
                if (packetList.size() > 2 || !pageHeader.isLastPacketIncomplete()) {
                    if (packetList.size() > 2) {
                        extraPackets /* !! */  = packetList.subList(2, packetList.size());
                    }
                } else {
                    pageHeader = OggPageHeader.read(raf);
                    packetList = pageHeader.getPacketList();
                    while (true) {
                        setupHeaderSize += packetList.get(0).getLength();
                        raf.skipBytes(packetList.get(0).getLength());
                        if (packetList.size() > 1 || !pageHeader.isLastPacketIncomplete()) {
                            if (packetList.size() <= 1) break;
                            extraPackets /* !! */  = packetList.subList(1, packetList.size());
                            break;
                        }
                        pageHeader = OggPageHeader.read(raf);
                    }
                }
            }
        }
        raf.seek(filepointer);
        return new OggVorbisHeaderSizes(commentHeaderStartPosition, setupHeaderStartPosition, commentHeaderSize, setupHeaderSize, extraPackets /* !! */ );
    }

    public static class OggVorbisHeaderSizes {
        private long commentHeaderStartPosition;
        private long setupHeaderStartPosition;
        private int commentHeaderSize;
        private int setupHeaderSize;
        private List<OggPageHeader.PacketStartAndLength> packetList;

        OggVorbisHeaderSizes(long commentHeaderStartPosition, long setupHeaderStartPosition, int commentHeaderSize, int setupHeaderSize, List<OggPageHeader.PacketStartAndLength> packetList) {
            this.packetList = packetList;
            this.commentHeaderStartPosition = commentHeaderStartPosition;
            this.setupHeaderStartPosition = setupHeaderStartPosition;
            this.commentHeaderSize = commentHeaderSize;
            this.setupHeaderSize = setupHeaderSize;
        }

        public int getCommentHeaderSize() {
            return this.commentHeaderSize;
        }

        public int getSetupHeaderSize() {
            return this.setupHeaderSize;
        }

        public int getExtraPacketDataSize() {
            int extraPacketSize = 0;
            for (OggPageHeader.PacketStartAndLength packet : this.packetList) {
                extraPacketSize += packet.getLength();
            }
            return extraPacketSize;
        }

        public long getCommentHeaderStartPosition() {
            return this.commentHeaderStartPosition;
        }

        public long getSetupHeaderStartPosition() {
            return this.setupHeaderStartPosition;
        }

        public List<OggPageHeader.PacketStartAndLength> getExtraPacketList() {
            return this.packetList;
        }
    }
}

