/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public abstract class AbstractString
extends AbstractDataType {
    protected AbstractString(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public AbstractString(String identifier, AbstractTagFrameBody frameBody, String value) {
        super(identifier, frameBody, value);
    }

    protected AbstractString(AbstractString object) {
        super(object);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    public String toString() {
        return (String)this.value;
    }

    public boolean canBeEncoded() {
        byte textEncoding = this.getBody().getTextEncoding();
        TextEncoding encoding = TextEncoding.getInstanceOf();
        Charset charset = encoding.getCharsetForId(textEncoding);
        CharsetEncoder encoder2 = charset.newEncoder();
        return encoder2.canEncode((String)this.value);
    }

    protected CharsetDecoder getCorrectDecoder(ByteBuffer inBuffer) {
        CharsetDecoder decoder = null;
        if (inBuffer.remaining() <= 2) {
            decoder = this.getTextEncodingCharSet().newDecoder();
            decoder.reset();
            return decoder;
        }
        if (this.getTextEncodingCharSet() == StandardCharsets.UTF_16) {
            if (inBuffer.getChar(0) == '\ufffe' || inBuffer.getChar(0) == '\ufeff') {
                decoder = this.getTextEncodingCharSet().newDecoder();
                decoder.reset();
            } else if (inBuffer.get(0) == 0) {
                decoder = StandardCharsets.UTF_16BE.newDecoder();
                decoder.reset();
            } else {
                decoder = StandardCharsets.UTF_16LE.newDecoder();
                decoder.reset();
            }
        } else {
            decoder = this.getTextEncodingCharSet().newDecoder();
            decoder.reset();
        }
        return decoder;
    }

    protected Charset getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        Charset charSetName = TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
        return charSetName;
    }
}

