/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_407;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.meteordev.starscript.Starscript;
import org.meteordev.starscript.value.Value;
import org.meteordev.starscript.value.ValueMap;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.api.KeyMappingHelper;
import ru.kelcuprum.alinlib.api.events.alinlib.LocalizationEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientTickEvents;
import ru.kelcuprum.alinlib.api.events.client.GuiRenderEvents;
import ru.kelcuprum.alinlib.api.events.client.ScreenEvents;
import ru.kelcuprum.alinlib.api.events.client.TextureManagerEvent;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.waterplayer.api.WebAPI;
import ru.kelcuprum.waterplayer.backend.KeyBind;
import ru.kelcuprum.waterplayer.backend.MusicPlayer;
import ru.kelcuprum.waterplayer.backend.WaterPlayerAPI;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.overlays.OverlayHandler;
import ru.kelcuprum.waterplayer.frontend.gui.overlays.SubtitlesHandler;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.ControlScreen;
import ru.kelcuprum.waterplayer.frontend.gui.screens.editor.TrackEditorScreen;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;
import ru.kelcuprum.waterplayer.frontend.rpc.DiscordIntegration;

public class WaterPlayer
implements ClientModInitializer {
    public static Config pathConfig = new Config("config/WaterPlayer/path.json");
    public static Config config = new Config(WaterPlayer.getPath() + "/config.json");
    public static Config apiConfig = new Config(WaterPlayer.getPath() + "/api.config.json");
    public static final Logger LOG = LogManager.getLogger((String)"WaterPlayer");
    public static MusicPlayer player;
    public static Localization localization;
    public static DiscordIntegration discordIntegration;
    public static List<KeyBind> keyBinds;

    public static String getPath() {
        String path = pathConfig.getBoolean("USE_GLOBAL", false) ? (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? pathConfig.getString("PATH", "{HOME}/WaterPlayer") : pathConfig.getString("PATH.UNIX", "/home/${USER}/WaterPlayer")) : "config/WaterPlayer";
        path = path.replace("{HOME}", System.getProperty("user.home")).replace("{USER}", System.getProperty("user.name"));
        return path;
    }

    public void onInitializeClient() {
        WaterPlayer.log("\u0417\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u0443\u0439\u0442\u0435, \u0442\u043e\u0432\u0430\u0440\u0438\u0449!");
        WaterPlayerAPI.loadConfig();
        player = new MusicPlayer();
        discordIntegration = new DiscordIntegration();
        WebAPI.run();
        WaterPlayer.registerBinds();
        FabricLoader.getInstance().getModContainer("waterplayer").ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)GuiUtils.getResourceLocation((String)"waterplayer", (String)"legacy"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcePack.waterplayer.legacy"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)GuiUtils.getResourceLocation((String)"waterplayer", (String)"walter"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcePack.waterplayer.walter"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            player.startAudioOutput();
            OverlayHandler hud = new OverlayHandler();
            SubtitlesHandler sub = new SubtitlesHandler();
            ScreenEvents.SCREEN_RENDER.register((Object)hud);
            GuiRenderEvents.RENDER.register((Object)hud);
            GuiRenderEvents.RENDER.register((Object)sub);
            ClientTickEvents.START_CLIENT_TICK.register((Object)hud);
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(e -> {
            player.getAudioPlayer().stopTrack();
            discordIntegration.exitApplication();
            config.setString("YOUTUBE_REFRESH_TOKEN", WaterPlayer.player.youtube.getOauth2RefreshToken());
            WebAPI.stop();
            TextureHelper.saveMap();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (KeyBind bind : keyBinds) {
                if (!bind.key().method_1436()) continue;
                bind.onExecute().run();
            }
        });
        TextureManagerEvent.INIT.register(TextureHelper::loadTextures);
        LocalizationEvents.DEFAULT_PARSER_INIT.register(starScript -> {
            Starscript ss = starScript.ss;
            ss.set("waterplayer", new ValueMap().set("player", new ValueMap().set("volume", () -> Value.number((double)MusicHelper.getVolume())).set("speaker_icon", () -> Value.string((String)MusicHelper.getSpeakerVolume())).set("repeat_icon", () -> Value.string((String)MusicHelper.getRepeatState())).set("pause_icon", () -> Value.string((String)MusicHelper.getPauseState()))).set("format", new ValueMap().set("time", () -> Value.string((String)(MusicHelper.getIsLive() ? localization.getLocalization("format.live", true) : localization.getLocalization("format.time", true)))).set("title", () -> Value.string((String)localization.getLocalization("format.title", true))).set("author", () -> Value.string((String)localization.getLocalization("format.author", true)))).set("track", new ValueMap().set("title", () -> Value.string((String)MusicHelper.getTitle())).set("author", () -> Value.string((String)MusicHelper.getAuthor())).set("time", new ValueMap().set("position", () -> Value.string((String)WaterPlayer.getTimestamp(MusicHelper.getPosition()))).set("duration", () -> Value.string((String)WaterPlayer.getTimestamp(MusicHelper.getDuration()))))));
        });
        ScreenEvents.KEY_PRESS.register((screen, code, scan, modifiers, var5) -> {
            if (!config.getBoolean("ENABLE_KEYBINDS", false)) {
                return;
            }
            if (screen instanceof class_442 || screen instanceof class_433 || screen instanceof ControlScreen) {
                for (KeyBind bind : keyBinds) {
                    if (!bind.key().method_1417(code, scan) && !bind.key().method_1433(code) || !bind.onExecute().run()) continue;
                    var5.setReturnValue((Object)true);
                    var5.cancel();
                    break;
                }
            }
        });
    }

    public static void openTrackEditor() {
        String result;
        MemoryStack stack = MemoryStack.stackPush();
        PointerBuffer filters = stack.mallocPointer(8);
        filters.put(stack.UTF8((CharSequence)"*.mp3"));
        filters.put(stack.UTF8((CharSequence)"*.mp4"));
        filters.put(stack.UTF8((CharSequence)"*.ogg"));
        filters.put(stack.UTF8((CharSequence)"*.flac"));
        filters.put(stack.UTF8((CharSequence)"*.wav"));
        filters.put(stack.UTF8((CharSequence)"*.aif"));
        filters.put(stack.UTF8((CharSequence)"*.dsf"));
        filters.put(stack.UTF8((CharSequence)"*.wma"));
        filters.flip();
        File defaultPath = new File(WaterPlayer.getPath()).getAbsoluteFile();
        Object defaultString = defaultPath.getAbsolutePath();
        if (defaultPath.isDirectory() && !((String)defaultString).endsWith(File.separator)) {
            defaultString = (String)defaultString + File.separator;
        }
        if ((result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector").getString(), (CharSequence)defaultString, (PointerBuffer)filters, (CharSequence)class_2561.method_43471((String)"waterplayer.editor.selector.filter_description").getString(), (boolean)false)) == null) {
            return;
        }
        File file = new File(result);
        if (file.exists()) {
            WaterPlayer.openTrackEditor(file);
        } else {
            WaterPlayer.getToast().setIcon(ru.kelcuprum.alinlib.gui.Icons.DONT).setType(ToastBuilder.Type.ERROR).setMessage((class_2561)class_2561.method_43471((String)"waterplayer.editor.file_not_exist")).buildAndShow();
        }
    }

    public static void openTrackEditor(File file) {
        AlinLib.MINECRAFT.method_1507((class_437)new TrackEditorScreen(AlinLib.MINECRAFT.field_1755, file));
    }

    public static String getTimestamp(long milliseconds) {
        int seconds = (int)(milliseconds / 1000L) % 60;
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static ToastBuilder getToast() {
        return new ToastBuilder().setIcon(class_1802.field_8065).setTitle((class_2561)class_2561.method_43471((String)"waterplayer.name"));
    }

    public static void registerBinds() {
        class_304 key1 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.control", 257, "waterplayer.name"));
        class_304 key2 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.pause", 80, "waterplayer.name"));
        class_304 key3 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.skip", 78, "waterplayer.name"));
        class_304 key9 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.back", 66, "waterplayer.name"));
        class_304 key4 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.reset", 261, "waterplayer.name"));
        class_304 key5 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.shuffle", 267, "waterplayer.name"));
        class_304 key6 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.repeating", 266, "waterplayer.name"));
        class_304 key7 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.volume.up", 265, "waterplayer.name"));
        class_304 key8 = KeyMappingHelper.register((class_304)new class_304("waterplayer.key.volume.down", 264, "waterplayer.name"));
        keyBinds.add(new KeyBind(key1, () -> {
            if (!(AlinLib.MINECRAFT.field_1755 instanceof ControlScreen)) {
                AlinLib.MINECRAFT.method_1507(WaterPlayer.getControlScreen(AlinLib.MINECRAFT.field_1755));
                return true;
            }
            return false;
        }));
        keyBinds.add(new KeyBind(key2, () -> {
            if (AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
                if (AlinLib.MINECRAFT.field_1755.method_25399() instanceof class_342) {
                    return false;
                }
                ((ControlScreen)AlinLib.MINECRAFT.field_1755).play.method_25306();
            } else {
                player.changePaused();
            }
            if (config.getBoolean("ENABLE_NOTICE", false)) {
                WaterPlayer.getToast().setMessage(Localization.getText((String)(player.isPaused() ? "waterplayer.message.pause" : "waterplayer.message.play"))).buildAndShow();
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key3, () -> {
            if (WaterPlayer.player.getTrackScheduler().queue.getQueue().isEmpty() && player.getAudioPlayer().getPlayingTrack() == null) {
                return false;
            }
            player.getTrackScheduler().nextTrack();
            if (config.getBoolean("ENABLE_NOTICE", false)) {
                WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.message.skip")).buildAndShow();
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key9, () -> {
            if (WaterPlayer.player.getTrackScheduler().queue.getQueue().isEmpty() && player.getAudioPlayer().getPlayingTrack() == null) {
                return false;
            }
            player.getTrackScheduler().backTrack();
            if (config.getBoolean("ENABLE_NOTICE", false)) {
                WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.message.back")).buildAndShow();
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key4, () -> {
            WaterPlayer.player.getTrackScheduler().skiping = false;
            if (!WaterPlayer.player.getTrackScheduler().queue.getQueue().isEmpty()) {
                player.getTrackScheduler().reset();
                if (config.getBoolean("ENABLE_NOTICE", false)) {
                    WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.message.reset")).buildAndShow();
                }
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key5, () -> {
            if (WaterPlayer.player.getTrackScheduler().queue.getQueue().size() >= 2) {
                if (AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
                    if (AlinLib.MINECRAFT.field_1755.method_25399() instanceof class_342) {
                        return false;
                    }
                    ((ControlScreen)AlinLib.MINECRAFT.field_1755).shuffle.method_25306();
                } else {
                    player.getTrackScheduler().shuffle();
                }
                if (config.getBoolean("ENABLE_NOTICE", false)) {
                    WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.message.shuffle")).buildAndShow();
                }
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key6, () -> {
            if (player.getAudioPlayer().getPlayingTrack() == null) {
                return false;
            }
            if (AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
                if (AlinLib.MINECRAFT.field_1755.method_25399() instanceof class_342) {
                    return false;
                }
                ((ControlScreen)AlinLib.MINECRAFT.field_1755).repeat.method_25306();
            } else {
                player.getTrackScheduler().changeRepeatStatus();
            }
            if (config.getBoolean("ENABLE_NOTICE", false)) {
                WaterPlayer.getToast().setIcon(player.getTrackScheduler().getRepeatIcon()).setMessage(Localization.getText((String)(player.getTrackScheduler().getRepeatStatus() == 0 ? "waterplayer.message.repeat.no" : (player.getTrackScheduler().getRepeatStatus() == 1 ? "waterplayer.message.repeat" : "waterplayer.message.repeat.one")))).buildAndShow();
            }
            return true;
        }));
        keyBinds.add(new KeyBind(key7, () -> {
            if (player.getAudioPlayer().getPlayingTrack() == null || AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
                return false;
            }
            int current = config.getNumber("CURRENT_MUSIC_VOLUME", (Number)3).intValue() + config.getNumber("SELECT_MUSIC_VOLUME", (Number)1).intValue();
            if (current >= 100) {
                current = 100;
            }
            config.setNumber("CURRENT_MUSIC_VOLUME", (Number)current);
            player.getAudioPlayer().setVolume(current);
            config.save();
            return true;
        }));
        keyBinds.add(new KeyBind(key8, () -> {
            if (player.getAudioPlayer().getPlayingTrack() == null || AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
                return false;
            }
            int current = config.getNumber("CURRENT_MUSIC_VOLUME", (Number)3).intValue() - config.getNumber("SELECT_MUSIC_VOLUME", (Number)1).intValue();
            if (current <= 0) {
                current = 0;
            }
            config.setNumber("CURRENT_MUSIC_VOLUME", (Number)current);
            player.getAudioPlayer().setVolume(current);
            config.save();
            return true;
        }));
    }

    public static class_437 getControlScreen(class_437 parent) {
        return new ControlScreen(parent);
    }

    public static void log(String message) {
        WaterPlayer.log(message, Level.INFO);
    }

    public static void log(String message, Level level) {
        LOG.log(level, "[" + LOG.getName() + "] " + message);
    }

    public static String parseFileSystem(String name) {
        return name.replaceAll("[<>:\"?|\\\\/*]", "_");
    }

    public static void confirmLinkNow(class_437 screen, String link) {
        class_310 minecraft = class_310.method_1551();
        minecraft.method_1507((class_437)new class_407(bl -> {
            if (bl) {
                class_156.method_668().method_670(link);
            }
            minecraft.method_1507(screen);
        }, link, true));
    }

    static {
        localization = new Localization("waterplayer", WaterPlayer.getPath() + "/lang");
        keyBinds = new ArrayList<KeyBind>();
    }

    public static interface Icons {
        public static final class_2960 REPEAT = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/repeat.png");
        public static final class_2960 REPEAT_ONE = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/one_repeat.png");
        public static final class_2960 REPEAT_NON = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/non_repeat.png");
        public static final class_2960 PLAY = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/play.png");
        public static final class_2960 PAUSE = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/pause.png");
        public static final class_2960 RESET_QUEUE = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/reset_queue.png");
        public static final class_2960 SKIP = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/skip.png");
        public static final class_2960 BACK = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/back.png");
        public static final class_2960 SHUFFLE = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/shuffle.png");
        public static final class_2960 HISTORY = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/history.png");
        public static final class_2960 VOLUME_MAX = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/volume_max.png");
        public static final class_2960 VOLUME_OK = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/volume_ok.png");
        public static final class_2960 VOLUME_LOW = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/volume_low.png");
        public static final class_2960 VOLUME_MUTE = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/player/volume_mute.png");
        public static final class_2960 FILE_ICON = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/file_icon.png");
        public static final class_2960 MUSIC = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/music.png");
        public static final class_2960 NO_ICON = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/no_icon.png");
        public static final class_2960 NO_PLAYLIST_ICON = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/no_playlist_icon.png");
        public static final class_2960 SEARCH = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/search.png");
        public static final class_2960 THINK = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/think.png");
        public static final class_2960 RECYCLE_BIN = GuiUtils.getResourceLocation((String)"waterplayer", (String)"textures/recycle_bin.png");

        public static class_2960 getPlayOrPause(boolean isPaused) {
            return isPaused ? PLAY : PAUSE;
        }
    }
}

