/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.output;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormatTools;
import com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.MusicPlayer;

public class AudioOutput
extends Thread {
    private final MusicPlayer musicPlayer;
    private final AudioFormat format;
    private final DataLine.Info speakerInfo;
    private Mixer mixer;
    private SourceDataLine sourceLine;

    public AudioOutput(MusicPlayer musicPlayer) {
        super("Audio Player");
        this.musicPlayer = musicPlayer;
        this.format = AudioDataFormatTools.toAudioFormat(musicPlayer.getAudioDataFormat());
        this.speakerInfo = new DataLine.Info(SourceDataLine.class, this.format);
        try {
            this.setMixer(WaterPlayer.config.getString("SPEAKER", ""));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setMixer("");
        }
    }

    @Override
    public void run() {
        try {
            AudioPlayer player = this.musicPlayer.getAudioPlayer();
            AudioDataFormat dataFormat = this.musicPlayer.getAudioDataFormat();
            AudioInputStream stream = AudioPlayerInputStream.createStream(player, dataFormat, dataFormat.frameDuration(), false);
            byte[] buffer = new byte[dataFormat.chunkSampleCount * dataFormat.channelCount * 2];
            long frameDuration = dataFormat.frameDuration();
            while (true) {
                if (this.sourceLine == null || !this.sourceLine.isOpen()) {
                    this.closeLine();
                    if (!this.createLine()) {
                        AudioOutput.sleep(500L);
                        continue;
                    }
                }
                if (!player.isPaused()) {
                    int chunkSize = stream.read(buffer);
                    if (chunkSize >= 0) {
                        this.sourceLine.write(buffer, 0, chunkSize);
                        continue;
                    }
                    throw new IllegalStateException("Audiostream ended. This should not happen.");
                }
                this.sourceLine.drain();
                AudioOutput.sleep(frameDuration);
            }
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
            return;
        }
    }

    public synchronized void setMixer(String name) {
        if (this.mixer != null && this.mixer.getMixerInfo().getName().equals(name)) {
            return;
        }
        Mixer oldMixer = this.mixer;
        this.mixer = this.findMixer(name, this.speakerInfo);
        this.closeLine();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (oldMixer != null && !AudioOutput.hasLinesOpen(oldMixer)) {
            oldMixer.close();
        }
    }

    private synchronized boolean createLine() {
        if (this.mixer != null) {
            try {
                SourceDataLine line = (SourceDataLine)this.mixer.getLine(this.speakerInfo);
                AudioDataFormat dataFormat = this.musicPlayer.getAudioDataFormat();
                line.open(this.format, dataFormat.chunkSampleCount * dataFormat.channelCount * 2 * 5);
                line.start();
                this.sourceLine = line;
                return true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        return false;
    }

    private synchronized void closeLine() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
            this.sourceLine.stop();
            this.sourceLine.close();
        }
    }

    public String[] getAudioDevices() {
        List<String> devicesList = this.getAudioDevicesList();
        String[] devices = new String[devicesList.size()];
        for (int i = 0; i < devicesList.size(); ++i) {
            devices[i] = devicesList.get(i);
        }
        return devices;
    }

    public List<String> getAudioDevicesList() {
        ArrayList<String> devicesList = new ArrayList<String>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            try {
                if (mixer == null || !((SourceDataLine)mixer.getLine(this.speakerInfo)).getFormat().isBigEndian()) continue;
                devicesList.add(mixerInfo.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return devicesList;
    }

    private Mixer findMixer(String name, Line.Info lineInfo) {
        Mixer defaultMixer = null;
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo)) continue;
            if (mixerInfo.getName().equals(name)) {
                return mixer;
            }
            if (defaultMixer != null) continue;
            defaultMixer = mixer;
        }
        return defaultMixer;
    }

    public static boolean hasLinesOpen(Mixer mixer) {
        return mixer.getSourceLines().length != 0 || mixer.getTargetLines().length != 0;
    }
}

