/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.components;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.TrackScheduler;
import ru.kelcuprum.waterplayer.frontend.gui.screens.TrackScreen;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class CurrentTrackButton
extends Button {
    protected class_437 screen;
    private final boolean isShort;

    public CurrentTrackButton(int x, int y, int width, boolean isShort, class_437 screen) {
        super(new ButtonBuilder().setTitle((class_2561)class_2561.method_43473()).setStyle(GuiUtils.getSelected()).setSize(width, isShort ? 20 : 40).setPosition(x, y));
        this.isShort = isShort;
        this.screen = screen;
    }

    public void method_25306() {
        if (this.isTrackEnable()) {
            AlinLib.MINECRAFT.method_1507((class_437)new TrackScreen(this.screen, WaterPlayer.player.getAudioPlayer().getPlayingTrack()));
        }
    }

    public int method_25364() {
        int i;
        int n = i = this.isShort ? 20 : 40;
        if (this.isTrackEnable()) {
            i += this.getTimelineSize();
        }
        this.field_22759 = i;
        return i;
    }

    protected boolean isTrackEnable() {
        return WaterPlayer.player.getAudioPlayer().getPlayingTrack() != null;
    }

    @NotNull
    public class_2561 method_25369() {
        if (this.isTrackEnable()) {
            AudioTrack track = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
            StringBuilder builder = new StringBuilder();
            if (!MusicHelper.isAuthorNull(track)) {
                builder.append(MusicHelper.getAuthor(track)).append(" - ");
            }
            builder.append(MusicHelper.getTitle(track)).append(" ").append((String)(track.getInfo().isStream ? WaterPlayer.localization.getLocalization("format.live") : WaterPlayer.getTimestamp(MusicHelper.getPosition(track)) + " / " + WaterPlayer.getTimestamp(MusicHelper.getDuration(track))));
            return class_2561.method_43470((String)builder.toString());
        }
        return class_2561.method_43471((String)"waterplayer.command.now_playing.notPlaying");
    }

    public int getTimelineSize() {
        return this.isTrackEnable() ? 4 : 0;
    }

    public void renderText(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isTrackEnable()) {
            int color;
            String time;
            this.field_22763 = true;
            AudioTrack track = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
            StringBuilder builder = new StringBuilder();
            if (!MusicHelper.isAuthorNull(track)) {
                builder.append(MusicHelper.getAuthor(track)).append(" - ");
            }
            builder.append(MusicHelper.getTitle(track));
            String string = time = track.getInfo().isStream ? WaterPlayer.localization.getLocalization("format.live") : WaterPlayer.getTimestamp(MusicHelper.getPosition(track)) + " / " + WaterPlayer.getTimestamp(MusicHelper.getDuration(track));
            int n = WaterPlayer.player.getAudioPlayer().isPaused() ? -938447 : (color = track.getInfo().isStream ? -255417 : -8796360);
            if (this.isShort) {
                if (GuiUtils.isDoesNotFit((class_2561)this.method_25369(), (Number)this.method_25368(), (Number)this.method_25364())) {
                    this.method_49604(guiGraphics, AlinLib.MINECRAFT.field_1772, 2, 0xFFFFFF);
                } else {
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, builder.toString(), this.method_46426() + (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                    guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, time, this.method_46426() + this.method_25368() - AlinLib.MINECRAFT.field_1772.method_1727(time) - (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, 0xFFFFFF);
                }
            } else {
                class_2960 icon = MusicHelper.getThumbnail(track);
                guiGraphics.method_25290(icon, this.method_46426() + 2, this.method_46427() + 2, 0.0f, 0.0f, 36, 36, 36, 36);
                this.renderString(guiGraphics, builder.toString(), this.method_46426() + 45, this.method_46427() + 8);
                String string2 = time + " | " + MusicHelper.getServiceName(MusicHelper.getService(track)).getString();
                int n2 = this.method_46426() + 45;
                int n3 = this.method_46427() + this.field_22759 - this.getTimelineSize() - 8;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                this.renderString(guiGraphics, string2, n2, n3 - 9);
            }
            double state = track.getInfo().isStream ? 1.0 : (double)TrackScheduler.trackPosition / (double)track.getDuration();
            guiGraphics.method_25294(this.method_46426(), this.method_46427() + this.method_25364() - this.getTimelineSize(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), color - -1308622848);
            guiGraphics.method_25294(this.method_46426(), this.method_46427() + this.method_25364() - this.getTimelineSize(), (int)((double)this.method_46426() + (double)this.method_25368() * state), this.method_46427() + this.method_25364(), color - 0x4D000000);
        } else {
            this.field_22763 = false;
            class_327 class_3272 = AlinLib.MINECRAFT.field_1772;
            class_5250 class_52502 = class_2561.method_43471((String)"waterplayer.command.now_playing.notPlaying");
            int n = this.method_46426() + this.method_25368() / 2;
            int n4 = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
            guiGraphics.method_27534(class_3272, (class_2561)class_52502, n, n4 - 9 / 2, -1);
        }
    }

    protected void renderString(class_332 guiGraphics, String text, int x, int y) {
        if (this.method_25368() - 50 < AlinLib.MINECRAFT.field_1772.method_1727(text)) {
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, (class_2561)class_2561.method_43470((String)text), 5, y - 1, -1);
        } else {
            guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, text, x, y, -1);
        }
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 message, int x, int y, int color) {
        int k = this.method_46426() + x;
        int l = this.method_46426() + this.method_25368() - x;
        if (!this.isShort) {
            k += 40;
        }
        Objects.requireNonNull(font);
        CurrentTrackButton.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)message, (int)k, (int)y, (int)l, (int)(y + 9), (int)color);
    }

    private void setValueFromMouse(double d) {
        if (this.isDragble()) {
            double pos = (d - (double)(this.method_46426() + 2)) / (double)(this.method_25368() - 4);
            long dur = WaterPlayer.player.getAudioPlayer().getPlayingTrack().getDuration();
            WaterPlayer.player.setPosition((long)((double)dur * pos));
        }
    }

    protected boolean isDragble() {
        return this.isTrackEnable() && !WaterPlayer.player.getAudioPlayer().getPlayingTrack().getInfo().isStream;
    }

    public void method_25348(double d, double e) {
        if (this.isDragble() && e > (double)(this.method_46427() + this.method_25364() - this.getTimelineSize() - 2)) {
            this.setValueFromMouse(d);
        } else {
            super.method_25348(d, e);
        }
    }

    protected void method_25349(double d, double e, double f, double g) {
        if (this.isDragble() && e > (double)(this.method_46427() + this.method_25364() - this.getTimelineSize() - 2)) {
            this.setValueFromMouse(d);
        } else {
            super.method_25349(d, e, f, g);
        }
    }
}

