/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.overlays;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.api.events.client.ClientTickEvents;
import ru.kelcuprum.alinlib.api.events.client.GuiRenderEvents;
import ru.kelcuprum.alinlib.api.events.client.ScreenEvents;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.frontend.gui.TextureHelper;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.ControlScreen;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class OverlayHandler
implements GuiRenderEvents,
ClientTickEvents.StartTick,
ScreenEvents.ScreenRender {
    private final List<class_5481> texts = new ObjectArrayList();
    private boolean isLive = false;
    private boolean isPause = true;
    double v = 0.0;
    public static HashMap<AudioTrack, Integer> commonColors = new HashMap();

    public void onStartTick(class_310 client) {
        this.updateTexts(true);
    }

    public void updateTexts(boolean bottom) {
        this.texts.clear();
        this.isLive = false;
        this.isPause = true;
        try {
            if (WaterPlayer.player.getAudioPlayer().getPlayingTrack() != null && (WaterPlayer.config.getBoolean("ENABLE_OVERLAY", true) || WaterPlayer.config.getBoolean("ENABLE_MENU_OVERLAY", true))) {
                int n;
                this.isLive = WaterPlayer.player.getAudioPlayer().getPlayingTrack().getInfo().isStream;
                this.isPause = WaterPlayer.player.getAudioPlayer().isPaused();
                this.v = this.isLive ? 1.0 : (double)WaterPlayer.player.getAudioPlayer().getPlayingTrack().getPosition() / (double)WaterPlayer.player.getAudioPlayer().getPlayingTrack().getDuration();
                class_5250 author = class_2561.method_43470((String)MusicHelper.getAuthor());
                class_5250 title = class_2561.method_43470((String)MusicHelper.getTitle());
                class_5250 state = class_2561.method_43470((String)WaterPlayer.localization.getParsedText("{waterplayer.player.speaker_icon} {waterplayer.player.volume}% {waterplayer.format.time}{waterplayer.player.repeat_icon}"));
                int pos = WaterPlayer.config.getNumber("OVERLAY.POSITION", (Number)0).intValue();
                int pos1 = WaterPlayer.config.getNumber("OVERLAY.POSITION", (Number)0).intValue();
                int n2 = AlinLib.MINECRAFT.field_1772.method_27525((class_5348)state);
                if (bottom ? pos == 0 || pos == 1 : pos1 == 0 || pos1 == 1) {
                    n = AlinLib.MINECRAFT.method_22683().method_4486() / 2;
                } else {
                    int n3;
                    int n4 = (AlinLib.MINECRAFT.method_22683().method_4486() - 280) / 2;
                    if (WaterPlayer.player.getAudioPlayer().getPlayingTrack().getInfo().artworkUrl != null || MusicHelper.isFile()) {
                        Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                        n3 = (9 + 3) * 3;
                    } else {
                        n3 = 0;
                    }
                    n = n4 - n3;
                }
                int maxWidth = Math.max(n2, n);
                this.texts.addAll(AlinLib.MINECRAFT.field_1772.method_1728((class_5348)title, maxWidth));
                if (!MusicHelper.isAuthorNull()) {
                    this.texts.addAll(AlinLib.MINECRAFT.field_1772.method_1728((class_5348)author, maxWidth));
                }
                this.texts.addAll(AlinLib.MINECRAFT.field_1772.method_1728((class_5348)state, maxWidth));
            }
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
        }
    }

    public void render(class_332 guiGraphics, int pos) {
        if ((AlinLib.MINECRAFT.field_1690.field_1842 || AlinLib.MINECRAFT.field_1705.method_53531().method_53536()) && WaterPlayer.config.getBoolean("ENABLE_OVERLAY.HIDE_IN_DEBUG", true)) {
            return;
        }
        if (WaterPlayer.player.getAudioPlayer().getPlayingTrack() == null) {
            return;
        }
        try {
            if (!this.texts.isEmpty()) {
                boolean top;
                int l = pos == 0 || pos == 1 ? 0 : this.texts.size() - 1;
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                int f = 9 + 3;
                int my = f * this.texts.size();
                int mx = 0;
                for (class_5481 text : this.texts) {
                    mx = Math.max(mx, AlinLib.MINECRAFT.field_1772.method_30880(text));
                }
                boolean caverEnable = false;
                int j = 0;
                if (WaterPlayer.config.getBoolean("OVERLAY.ENABLE_CAVER", true)) {
                    caverEnable = true;
                    j = f * Math.min(this.texts.size(), 3);
                    mx += j + 10;
                }
                boolean left = pos == 0 || pos == 2;
                boolean bl = top = pos == 0 || pos == 1;
                if (!top) {
                    my += 3;
                }
                int i = left ? mx + 10 : -(mx + 10);
                int i1 = top ? my + 5 : -(my + 5);
                guiGraphics.method_25294(left ? 5 : guiGraphics.method_51421() - 5, top ? 5 : guiGraphics.method_51443() - 6 + i1, (left ? 5 : guiGraphics.method_51421() - 5) + i, (top ? 5 + i1 : guiGraphics.method_51443() - 9) + 5, 0x7F000000);
                int state = this.getBarColor();
                guiGraphics.method_25294(left ? 8 : guiGraphics.method_51421() - 7, (top ? 3 + i1 : guiGraphics.method_51443() - 11) + 3, (left ? 2 : guiGraphics.method_51421() - 3) + i, (top ? 3 + i1 : guiGraphics.method_51443() - 11) + 5, 0x7F000000);
                guiGraphics.method_25294(left ? 8 : guiGraphics.method_51421() - 13 - mx, (top ? 3 + i1 : guiGraphics.method_51443() - 11) + 3, (int)((double)(left ? 8 : guiGraphics.method_51421() - 13 - mx) + (left ? (double)(i - 6) * this.v : (double)((i + 4) * -1) * this.v)), (top ? 3 + i1 : guiGraphics.method_51443() - 11) + 5, state);
                for (class_5481 text : this.texts) {
                    int n;
                    int x = (left ? 10 : guiGraphics.method_51421() - 10 - mx) + (caverEnable ? j + 5 : 0);
                    if (top) {
                        n = 10 + l * f;
                    } else {
                        int n2 = guiGraphics.method_51443() - 11;
                        Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                        n = n2 - 9 - l * f;
                    }
                    int y = n;
                    guiGraphics.method_35720(AlinLib.MINECRAFT.field_1772, text, x, y, -1);
                    if (top) {
                        ++l;
                        continue;
                    }
                    --l;
                }
                if (caverEnable) {
                    AudioTrack track = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
                    guiGraphics.method_25290(MusicHelper.getThumbnail(track), left ? 8 : guiGraphics.method_51421() - 12 - mx, top ? 8 : guiGraphics.method_51443() - 3 + i1, 0.0f, 0.0f, j - 1, j - 1, j - 1, j - 1);
                }
            }
        }
        catch (Exception ex) {
            WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
        }
    }

    public void onScreenRender(class_437 screen, class_332 guiGraphics, int mx130, int my, float tick) {
        if (screen instanceof class_442) {
            if (!WaterPlayer.config.getBoolean("ENABLE_MENU_OVERLAY", true)) {
                return;
            }
            int pos = WaterPlayer.config.getNumber("MENU_OVERLAY.POSITION", (Number)0).intValue();
            this.render(guiGraphics, pos);
        }
    }

    public void onRender(class_332 guiGraphics, float tickDelta) {
        if (!WaterPlayer.config.getBoolean("ENABLE_OVERLAY", true) || AlinLib.MINECRAFT.field_1755 instanceof ControlScreen) {
            return;
        }
        int pos = WaterPlayer.config.getNumber("OVERLAY.POSITION", (Number)0).intValue();
        this.render(guiGraphics, pos);
    }

    public int getBarColor() {
        int n;
        AudioTrack audio = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
        if (this.isPause) {
            n = -938447;
        } else if (this.isLive) {
            n = -255417;
        } else if (!WaterPlayer.config.getBoolean("OVERLAY.ACCENT_COLOR", false) || audio == null) {
            n = -8796360;
        } else {
            switch (MusicHelper.getTitle(audio)) {
                case "HEX OF PINK FF006E": {
                    n = -65426;
                    break;
                }
                default: {
                    int color = OverlayHandler.getCommonColor(audio);
                    if (color == -1) {
                        color = -8796360;
                    }
                    n = color;
                    break;
                }
            }
        }
        return n;
    }

    public static int getCommonColor(AudioTrack track) {
        return OverlayHandler.getCommonColor(track, -1);
    }

    public static int getCommonColor(AudioTrack track, int defaultColor) {
        if (track == null) {
            return defaultColor;
        }
        if (MusicHelper.getThumbnail(track) == WaterPlayer.Icons.NO_ICON) {
            return defaultColor;
        }
        if (commonColors.containsKey(track)) {
            return commonColors.get(track);
        }
        BufferedImage image = TextureHelper.dynamicTextures.get(MusicHelper.getThumbnail(track));
        if (image == null) {
            return defaultColor;
        }
        int height = image.getHeight();
        int width = image.getWidth();
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int rgb = image.getRGB(j, i);
                int[] rgbArr = OverlayHandler.getRGBArr(rgb);
                if (OverlayHandler.notCorrect(rgb)) continue;
                Integer counter = m.get(rgb);
                if (counter == null) {
                    counter = 0;
                }
                Integer n = counter;
                counter = counter + 1;
                m.put(rgb, counter);
            }
        }
        int color = OverlayHandler.getMostCommonColour(m, defaultColor);
        commonColors.put(track, color);
        return color;
    }

    public static int getMostCommonColour(HashMap<Integer, Integer> map, int defaultColor) {
        LinkedList<Map.Entry<Integer, Integer>> list = new LinkedList<Map.Entry<Integer, Integer>>(map.entrySet());
        if (list.isEmpty()) {
            return defaultColor;
        }
        list.sort((o1, o2) -> ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue()));
        Map.Entry<Integer, Integer> me = list.getLast();
        return me.getKey();
    }

    public static int[] getRGBArr(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new int[]{red, green, blue};
    }

    public static boolean notCorrect(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        if (red == green && green == blue) {
            return !OverlayHandler.checkColor(red, 100, 190);
        }
        return !OverlayHandler.checkColor(red, 100, 245) && !OverlayHandler.checkColor(green, 100, 245) && !OverlayHandler.checkColor(blue, 100, 245);
    }

    public static boolean checkColor(int color, int min, int max) {
        return min < color && color < max;
    }
}

