/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.screens.control;

import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.editbox.EditBoxBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.selector.SelectorBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.alinlib.gui.components.editbox.EditBox;
import ru.kelcuprum.alinlib.gui.screens.ConfirmScreen;
import ru.kelcuprum.alinlib.gui.styles.AbstractStyle;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.queue.AbstractQueue;
import ru.kelcuprum.waterplayer.frontend.gui.LyricsHelper;
import ru.kelcuprum.waterplayer.frontend.gui.components.LyricsBox;
import ru.kelcuprum.waterplayer.frontend.gui.components.TrackButton;
import ru.kelcuprum.waterplayer.frontend.gui.overlays.OverlayHandler;
import ru.kelcuprum.waterplayer.frontend.gui.screens.config.PlaylistsScreen;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.ConfirmLoadFiles;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.FullScreenTrackInfo;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.components.TimelineComponent;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.components.TrackIconButton;
import ru.kelcuprum.waterplayer.frontend.gui.screens.control.components.VolumeComponent;
import ru.kelcuprum.waterplayer.frontend.gui.screens.search.SearchScreen;
import ru.kelcuprum.waterplayer.frontend.gui.style.AirStyle;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class ControlScreen
extends class_437 {
    private final class_437 parent;
    public boolean showControlPanel = true;
    public final int controlPanelWidth = 180;
    public String value = "";
    public LyricsBox lyricsBox;
    public EditBox editBox;
    public Button load;
    public Button clear;
    public Button shuffle;
    public Button play;
    public Button skip;
    public Button repeat;
    public AirStyle nothingStyle = new AirStyle();
    public Button trackIcon;
    ConfigureScrolWidget queue;
    int lastCountQueue;
    public AbstractQueue queueTracks;
    AudioTrack lastTrack;
    AudioLyrics audioLyrics;
    long lastCheck;

    public ControlScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"waterplayer.control"));
        this.lastCountQueue = WaterPlayer.player.getTrackScheduler().queue.getQueue().size();
        this.queueTracks = WaterPlayer.player.getTrackScheduler().queue;
        this.lastTrack = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
        this.lastCheck = System.currentTimeMillis();
        this.parent = parent;
    }

    protected void method_25426() {
        if (this.showControlPanel) {
            this.initControlPanel();
        }
        this.initPlayerPanel();
        this.initQueue();
    }

    public void initControlPanel() {
        int cWidth = 170;
        int x = 10;
        int y = 35;
        this.method_37063((class_364)new TextBuilder(this.field_22785).setPosition(5, 5).setSize(cWidth, 20).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.load.url.copy"), s -> this.editBox.method_1852(WaterPlayer.config.getString("LAST_REQUEST_MUSIC", ""))).setSprite(Icons.RESET).setSize(20, 20).setPosition(x, y).build());
        this.editBox = (EditBox)this.method_37063((class_364)new EditBoxBuilder((class_2561)class_2561.method_43471((String)"waterplayer.load.url")).setValue(this.value).setResponder(s -> {
            this.value = s;
        }).setWidth(cWidth - 22).setPosition(x + 22, y).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.reset_queue"), e -> this.field_22787.method_1507((class_437)new ConfirmScreen(this.field_22787.field_1755, Icons.DONT, (class_2561)class_2561.method_43471((String)"waterplayer.control.reset_queue"), (class_2561)class_2561.method_43471((String)"waterplayer.control.reset_queue.warning"), s -> {
            if (s) {
                WaterPlayer.player.getTrackScheduler().reset();
            }
        }))).setSprite(Icons.DONT).setSize(20, 20).setPosition(x, y += 22).build());
        this.load = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.load.load"), e -> WaterPlayer.player.loadMusic(this.value, true)).setSize(cWidth - 22, 20).setPosition(x + 22, y).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.search"), s -> AlinLib.MINECRAFT.method_1507((class_437)new SearchScreen(this))).setCentered(false).setSprite(Icons.SEARCH).setSize(20, 20).setPosition(x, y += 22).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.playlists"), s -> AlinLib.MINECRAFT.method_1507(PlaylistsScreen.build(this))).setCentered(true).setSize(cWidth - 22, 20).setPosition(x + 22, y).build());
        y += 22;
        if (WaterPlayer.config.getBoolean("EXPERIMENT.FILTERS", false)) {
            String[] speed = new String[]{"0.25x", "0.5x", "0.75x", "1x", "1.5x", "2x", "2.5x", "3x", "3.5x", "4x", "4.5x", "5x"};
            List<Double> speedD = List.of(0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0);
            int pos = speedD.indexOf(WaterPlayer.player.speed);
            if (pos < 0) {
                pos = 3;
                WaterPlayer.player.speed = speedD.get(pos);
                WaterPlayer.config.setNumber("CURRENT_MUSIC_SPEED", (Number)WaterPlayer.player.speed);
                WaterPlayer.player.updateFilter();
            }
            this.method_37063((class_364)new SelectorBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.speed")).setList(speed).setValue(pos).setOnPress(s -> {
                WaterPlayer.player.speed = (Double)speedD.get(s.getPosition());
                WaterPlayer.config.setNumber("CURRENT_MUSIC_SPEED", (Number)WaterPlayer.player.speed);
                WaterPlayer.player.updateFilter();
            }).setPosition(x, y).setWidth(cWidth).build());
            y += 22;
            String[] pitch = new String[]{"0.25", "0.5", "0.75", "1", "1.25", "1.5", "1.75", "2"};
            List<Double> pitchD = List.of(Double.valueOf(0.25), Double.valueOf(0.5), Double.valueOf(0.75), Double.valueOf(1.0), Double.valueOf(1.25), Double.valueOf(1.5), Double.valueOf(1.75), Double.valueOf(2.0));
            int ppos = pitchD.indexOf(WaterPlayer.player.pitch);
            if (ppos < 0) {
                ppos = 3;
                WaterPlayer.player.pitch = speedD.get(ppos);
                WaterPlayer.config.setNumber("CURRENT_MUSIC_PITCH", (Number)WaterPlayer.player.pitch);
                WaterPlayer.player.updateFilter();
            }
            this.method_37063((class_364)new SelectorBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.pitch")).setList(pitch).setValue(ppos).setOnPress(s -> {
                WaterPlayer.player.pitch = (Double)pitchD.get(s.getPosition());
                WaterPlayer.config.setNumber("CURRENT_MUSIC_SPEED", (Number)WaterPlayer.player.speed);
                WaterPlayer.player.updateFilter();
            }).setPosition(x, y).setWidth(cWidth).build());
            y += 22;
        }
        this.lyricsBox = (LyricsBox)this.method_37063((class_364)new LyricsBox(x, y, cWidth, this.field_22790 - y - 55, (class_2561)class_2561.method_43473()));
        this.lyricsBox.field_22764 = false;
    }

    public void initPlayerPanel() {
        int x = 5;
        int y = this.field_22790 - 45;
        int size = this.field_22789 - 10;
        this.trackIcon = (Button)this.method_37063((class_364)new TrackIconButton(new ButtonBuilder((class_2561)class_2561.method_43473(), s -> AlinLib.MINECRAFT.method_1507((class_437)new FullScreenTrackInfo(this))).setSize(32, 32).setPosition(x + 4, y + 4)));
        this.trackIcon.field_22763 = WaterPlayer.player.getAudioPlayer().getPlayingTrack() != null;
        this.trackIcon.field_22764 = this.trackIcon.field_22763;
        boolean isModern = WaterPlayer.config.getBoolean("CONTROL.MODERN_BUTTONS", true);
        int x$Buttons = x + size / 2 - 60;
        this.shuffle = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.shuffle"), e -> {
            WaterPlayer.player.getTrackScheduler().shuffle();
            for (class_339 widget : this.queue.widgets) {
                this.method_37066((class_364)widget);
            }
            this.queue.resetWidgets();
            this.addQueue();
        }).setSprite(WaterPlayer.Icons.SHUFFLE).setSize(isModern ? 16 : 20, isModern ? 16 : 20).setPosition(x$Buttons + (isModern ? 2 : 0), y + (isModern ? 5 : 3)).setStyle((AbstractStyle)(isModern ? this.nothingStyle : GuiUtils.getSelected())).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.back"), e -> WaterPlayer.player.getTrackScheduler().backTrack()).setSprite(WaterPlayer.Icons.BACK).setSize(isModern ? 16 : 20, isModern ? 16 : 20).setPosition((x$Buttons += 25) + (isModern ? 2 : 0), y + (isModern ? 5 : 3)).setStyle((AbstractStyle)(isModern ? this.nothingStyle : GuiUtils.getSelected())).build());
        this.play = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)("waterplayer.control." + (WaterPlayer.player.getAudioPlayer().isPaused() ? "play" : "pause"))), e -> {
            WaterPlayer.player.changePaused();
            e.builder.setTitle((class_2561)class_2561.method_43471((String)("waterplayer.control." + (WaterPlayer.player.isPaused() ? "play" : "pause"))));
            ((ButtonBuilder)e.builder).setSprite(WaterPlayer.Icons.getPlayOrPause(WaterPlayer.player.isPaused()));
        }).setSprite(WaterPlayer.Icons.getPlayOrPause(WaterPlayer.player.isPaused())).setSize(20, 20).setPosition(x$Buttons += 25, y + 3).build());
        this.skip = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.skip"), e -> {
            if (WaterPlayer.player.getTrackScheduler().queue.getQueue().isEmpty() && WaterPlayer.player.getAudioPlayer().getPlayingTrack() == null) {
                return;
            }
            WaterPlayer.player.getTrackScheduler().nextTrack();
        }).setSprite(WaterPlayer.Icons.SKIP).setSize(isModern ? 16 : 20, isModern ? 16 : 20).setPosition((x$Buttons += 25) + (isModern ? 2 : 0), y + (isModern ? 5 : 3)).setStyle((AbstractStyle)(isModern ? this.nothingStyle : GuiUtils.getSelected())).build());
        this.repeat = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.control.repeat"), e -> {
            WaterPlayer.player.getTrackScheduler().changeRepeatStatus();
            ((ButtonBuilder)e.builder).setSprite(WaterPlayer.player.getTrackScheduler().getRepeatIcon());
        }).setSprite(WaterPlayer.player.getTrackScheduler().getRepeatIcon()).setSize(isModern ? 16 : 20, isModern ? 16 : 20).setPosition((x$Buttons += 25) + (isModern ? 2 : 0), y + (isModern ? 5 : 3)).setStyle((AbstractStyle)(isModern ? this.nothingStyle : GuiUtils.getSelected())).build());
        x$Buttons += 25;
        int timelineSize = Math.min(size / 3, 230);
        this.method_37063((class_364)new TimelineComponent(x + size / 2 - timelineSize / 2, y + 30, timelineSize, 3, timelineSize >= 190));
        this.method_37063((class_364)new VolumeComponent(x + size - 12 - 70, y + 18, 70, 4));
    }

    public void initQueue() {
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43470((String)"x"), s -> this.method_25419()).setPosition(this.field_22789 - 25, 5).setSize(20, 20).build());
        int queueWidth = this.field_22789 - 15 - 180;
        this.queue = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(190 + queueWidth, 30, 5, this.field_22790 - 80, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 0;
            for (class_339 widget : scroller.widgets) {
                if (widget.field_22764) {
                    widget.method_25358(queueWidth);
                    widget.method_46419((int)((double)(scroller.method_46427() + scroller.innerHeight) - scroller.scrollAmount()));
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
            scroller.innerHeight -= 13;
        }));
        this.addQueue();
    }

    public void addQueue() {
        int queueWidth = this.field_22789 - 15 - 180;
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        int y = this.queue.method_46427();
        try {
            if (!this.queueTracks.getQueue().isEmpty()) {
                for (AudioTrack track : this.queueTracks.getQueue()) {
                    TrackButton tbutton = new TrackButton(190, y, queueWidth, track, this, !WaterPlayer.config.getBoolean("SCREEN.QUEUE_COVER_SHOW", true));
                    widgets.add((class_339)tbutton);
                    y += tbutton.method_25364() + 5;
                }
            }
        }
        catch (Exception ex) {
            this.lastCountQueue = 0;
            WaterPlayer.log(ex.getLocalizedMessage(), Level.ERROR);
        }
        this.addWidgetsToQueue(widgets);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        if (this.showControlPanel) {
            this.renderControlPanel(guiGraphics);
        }
        this.renderPlayerPanel(guiGraphics);
        this.renderQueueTitle(guiGraphics);
    }

    public int getBackgroundColor() {
        return 0x37000000;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_44379(190, 30, 190 + (this.field_22789 - 15 - 180), this.field_22790 - 50);
        if (this.queue != null) {
            for (class_339 widget : this.queue.widgets) {
                widget.method_25394(guiGraphics, i, j, f);
            }
        }
        guiGraphics.method_44380();
    }

    public void renderControlPanel(class_332 guiGraphics) {
        int x = 5;
        int y = 5;
        GuiUtils.getSelected().renderBackground(guiGraphics, x, y + 25, x + 180, this.lyricsBox.field_22764 ? this.field_22790 - 50 : (WaterPlayer.config.getBoolean("EXPERIMENT.FILTERS", false) ? 148 : 104));
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, x, y, x + 180, 25);
    }

    public void renderPlayerPanel(class_332 guiGraphics) {
        int x = 5;
        int y = this.field_22790 - 45;
        AbstractStyle style = GuiUtils.getSelected();
        GuiUtils.getSelected().renderBackground(guiGraphics, x, y, x + this.field_22789 - 10, y + 40);
        if (!style.id.contains("win") && this.isTrackEnable() && this.lastTrack != null) {
            if (style.id.contains("twm")) {
                guiGraphics.method_25294(x, y, x + this.field_22789 - 10, y + 1, OverlayHandler.getCommonColor(this.lastTrack, -1));
                guiGraphics.method_25294(x, y, x + 1, y + 40, OverlayHandler.getCommonColor(this.lastTrack, -1));
                guiGraphics.method_25294(x + this.field_22789 - 10, y, x + this.field_22789 - 11, y + 40, OverlayHandler.getCommonColor(this.lastTrack, -1));
                guiGraphics.method_25294(x, y + 40, x + this.field_22789 - 10, y + 39, OverlayHandler.getCommonColor(this.lastTrack, -1));
            } else {
                guiGraphics.method_25294(x, y, x + this.field_22789 - 10, y + 40, OverlayHandler.getCommonColor(this.lastTrack, -1) - 0x7F000000);
            }
        }
        if (this.isTrackEnable()) {
            guiGraphics.method_25290(MusicHelper.getThumbnail(), x + 4, y + 4, 0.0f, 0.0f, 32, 32, 32, 32);
            int size = this.field_22789 - 10;
            int x$Buttons = x + size / 2 - 60 - 6;
            int x$Timeline = x + size / 2 - Math.min(size / 3, 230) / 2 - 6;
            int maxX = Math.min(x$Buttons, x$Timeline);
            this.renderString(guiGraphics, MusicHelper.getTitle(), x + 43, y + 8, maxX);
            String string = MusicHelper.getAuthor();
            Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
            this.renderString(guiGraphics, string, x + 43, y + 40 - 8 - 9, maxX);
        }
    }

    public void renderQueueTitle(class_332 guiGraphics) {
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 190, 5, this.field_22789 - 30, 25);
        int titleWidth = this.field_22789 - 40 - 180;
        class_5250 component = class_2561.method_43470((String)this.queueTracks.getName());
        if (AlinLib.MINECRAFT.field_1772.method_27525((class_5348)component) > titleWidth) {
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, (class_2561)component, 190, this.field_22789 - 30, 11, -1);
        } else {
            guiGraphics.method_27534(AlinLib.MINECRAFT.field_1772, (class_2561)component, 190 + titleWidth / 2, 11, -1);
        }
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 message, int x, int maxX, int y, int color) {
        Objects.requireNonNull(font);
        ControlScreen.renderScrollingString(guiGraphics, font, message, x, y, maxX, y + 9, color);
    }

    protected static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 component, int i, int j, int k, int l, int m) {
        ControlScreen.renderScrollingString(guiGraphics, font, component, (i + k) / 2, i, j, k, l, m);
    }

    protected static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 component, int i, int j, int k, int l, int m, int n) {
        int o = font.method_27525((class_5348)component);
        int var10000 = k + m;
        Objects.requireNonNull(font);
        int p = (var10000 - 9) / 2 + 1;
        int q = l - j;
        if (o > q) {
            int r = o - q;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)r);
            guiGraphics.method_44379(j, k, l, m);
            guiGraphics.method_27535(font, component, j - (int)g, p, n);
            guiGraphics.method_44380();
        } else {
            int r = class_3532.method_15340((int)i, (int)(j + o / 2), (int)(l - o / 2));
            guiGraphics.method_27534(font, component, r, p, n);
        }
    }

    protected void renderString(class_332 guiGraphics, String text, int x, int y, int maxX) {
        if (maxX - x < AlinLib.MINECRAFT.field_1772.method_1727(text)) {
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, (class_2561)class_2561.method_43470((String)text), x, maxX, y - 1, -1);
        } else {
            guiGraphics.method_25303(AlinLib.MINECRAFT.field_1772, text, x, y, -1);
        }
    }

    public void addWidgetsToQueue(List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.addWidgetToQueue(widget);
        }
    }

    public class_339 addWidgetToQueue(class_339 widget) {
        this.queue.addWidget(widget);
        return (class_339)this.method_25429((class_364)widget);
    }

    protected boolean isTrackEnable() {
        return WaterPlayer.player.getAudioPlayer().getPlayingTrack() != null;
    }

    public boolean method_25402(double d, double e, int i) {
        boolean st = true;
        class_364 selected = null;
        for (class_364 guiEventListener : this.method_25396()) {
            if (this.queue != null && this.queue.widgets.contains(guiEventListener)) {
                if (!(d >= 190.0) || !(d <= (double)(this.field_22789 - 5)) || !(e >= 30.0) || !(e <= (double)(this.field_22790 - 50)) || !guiEventListener.method_25402(d, e, i)) continue;
                st = false;
                selected = guiEventListener;
                break;
            }
            if (!guiEventListener.method_25402(d, e, i)) continue;
            st = false;
            selected = guiEventListener;
            break;
        }
        this.method_25395(selected);
        if (i == 0) {
            this.method_25398(true);
        }
        return st;
    }

    public void method_25393() {
        if (this.queue != null) {
            this.queue.onScroll.accept(this.queue);
        }
        this.trackIcon.field_22763 = WaterPlayer.player.getAudioPlayer().getPlayingTrack() != null;
        this.trackIcon.field_22764 = this.trackIcon.field_22763;
        if (this.isTrackEnable() && WaterPlayer.config.getBoolean("CONTROL.ENABLE_LYRICS", true)) {
            AudioTrack track = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
            this.audioLyrics = LyricsHelper.getLyrics(track);
            if (this.audioLyrics != null) {
                List<AudioLyrics.Line> list = this.audioLyrics.getLines();
                String text = this.audioLyrics.getText();
                if (list != null) {
                    StringBuilder builder = new StringBuilder();
                    for (AudioLyrics.Line line : list) {
                        if (line.getDuration() == null) continue;
                        int type = WaterPlayer.config.getNumber("CONTROL.LYRICS.TYPE", (Number)0).intValue();
                        Duration pos = Duration.ofMillis(track.getPosition());
                        if (type == 0) {
                            if (pos.toMillis() >= line.getTimestamp().toMillis() && pos.toMillis() <= line.getTimestamp().toMillis() + line.getDuration().toMillis()) {
                                builder.append(line.getLine().replace("\r", "")).append("\n");
                                continue;
                            }
                            builder.append("\u00a77").append(line.getLine().replace("\r", "")).append("\u00a7r\n");
                            continue;
                        }
                        if (type == 1) {
                            if (pos.toMillis() > line.getTimestamp().toMillis() && (pos.toMillis() < line.getTimestamp().toMillis() || pos.toMillis() > line.getTimestamp().toMillis() + line.getDuration().toMillis())) continue;
                            builder.append(line.getLine().replace("\r", "")).append("\n");
                            continue;
                        }
                        builder.append(line.getLine().replace("\r", "")).append("\n");
                    }
                    this.lyricsBox.setLyrics((class_2561)class_2561.method_43470((String)builder.toString()));
                    this.lyricsBox.field_22764 = !builder.toString().isEmpty();
                } else if (text != null) {
                    this.lyricsBox.setLyrics((class_2561)class_2561.method_43470((String)text.replace("\r", "")));
                    this.lyricsBox.field_22764 = !text.isBlank();
                } else {
                    this.lyricsBox.field_22764 = false;
                }
            } else {
                this.lyricsBox.field_22764 = false;
            }
        } else {
            this.lyricsBox.field_22764 = false;
        }
        if (this.queueTracks != WaterPlayer.player.getTrackScheduler().queue) {
            this.queueTracks = WaterPlayer.player.getTrackScheduler().queue;
        }
        if (this.lastCountQueue != WaterPlayer.player.getTrackScheduler().queue.getQueue().size()) {
            this.lastCountQueue = WaterPlayer.player.getTrackScheduler().queue.getQueue().size();
            this.lastTrack = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
            for (class_339 widget : this.queue.widgets) {
                this.method_37066((class_364)widget);
            }
            this.queue.resetWidgets();
            this.addQueue();
        } else if (this.lastTrack != WaterPlayer.player.getAudioPlayer().getPlayingTrack()) {
            this.lastTrack = WaterPlayer.player.getAudioPlayer().getPlayingTrack();
            this.lastCountQueue = WaterPlayer.player.getTrackScheduler().queue.getQueue().size();
            for (class_339 widget : this.queue.widgets) {
                this.method_37066((class_364)widget);
            }
            this.queue.resetWidgets();
            this.addQueue();
        }
        super.method_25393();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        int queueWidth = this.field_22789 - 15 - 180;
        if (mouseX >= (double)this.lyricsBox.method_46426() && mouseX <= (double)(this.lyricsBox.method_46426() + this.lyricsBox.method_25368()) && mouseY >= (double)this.lyricsBox.method_46427() && mouseY <= (double)(this.lyricsBox.method_46427() + this.lyricsBox.method_25364())) {
            scr = this.lyricsBox.method_25401(mouseX, mouseY, scrollX, scrollY);
        } else if (!scr && this.queue != null && mouseX >= (double)(this.queue.method_46426() - queueWidth) && mouseX <= (double)(this.queue.method_46426() + this.queue.method_25368()) && mouseY >= (double)this.queue.method_46427() && mouseY <= (double)(this.queue.method_46427() + this.queue.method_25364())) {
            scr = this.queue.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_29638(List<Path> list) {
        if (list.size() == 1) {
            this.editBox.method_1852(list.get(0).toString());
        } else {
            AlinLib.MINECRAFT.method_1507((class_437)new ConfirmLoadFiles(list, this));
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 80 && (modifiers & 1) != 0) {
            WaterPlayer.config.setBoolean("CONTROL.MODERN_BUTTONS", !WaterPlayer.config.getBoolean("CONTROL.MODERN_BUTTONS", true));
            this.method_41843();
            return true;
        }
        if (this.method_25399() != null && this.method_25399() instanceof EditBox && keyCode == 257) {
            this.load.method_25306();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        AlinLib.MINECRAFT.method_1507(this.parent);
    }
}

