/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.karaoke;

import com.github.natanbc.lavadsp.karaoke.KaraokeConverter;
import com.github.natanbc.lavadsp.util.FloatToFloatFunction;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class KaraokePcmAudioFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private final KaraokeConverter converter;
    private volatile float level = 1.0f;
    private volatile float monoLevel = 1.0f;
    private volatile float filterBand = 220.0f;
    private volatile float filterWidth = 100.0f;

    public KaraokePcmAudioFilter(FloatPcmAudioFilter downstream, int channelCount, int sampleRate) {
        this.downstream = downstream;
        this.converter = channelCount == 2 ? new KaraokeConverter(sampleRate) : null;
    }

    public boolean isEnabled() {
        return this.converter != null;
    }

    public float getLevel() {
        return this.level;
    }

    public KaraokePcmAudioFilter setLevel(float level) {
        this.level = level;
        if (this.converter != null) {
            this.converter.setLevel(level);
        }
        return this;
    }

    public KaraokePcmAudioFilter updateLevel(FloatToFloatFunction function) {
        return this.setLevel(function.apply(this.level));
    }

    public float getMonoLevel() {
        return this.monoLevel;
    }

    public KaraokePcmAudioFilter setMonoLevel(float level) {
        this.monoLevel = level;
        if (this.converter != null) {
            this.converter.setMonoLevel(level);
        }
        return this;
    }

    public KaraokePcmAudioFilter updateMonoLevel(FloatToFloatFunction function) {
        return this.setMonoLevel(function.apply(this.monoLevel));
    }

    public float getFilterBand() {
        return this.filterBand;
    }

    public KaraokePcmAudioFilter setFilterBand(float band) {
        this.filterBand = band;
        if (this.converter != null) {
            this.converter.setFilterBand(band);
        }
        return this;
    }

    public KaraokePcmAudioFilter updateFilterBand(FloatToFloatFunction function) {
        return this.setFilterBand(function.apply(this.filterBand));
    }

    public float getFilterWidth() {
        return this.filterWidth;
    }

    public KaraokePcmAudioFilter setFilterWidth(float width) {
        this.filterWidth = this.level;
        if (this.converter != null) {
            this.converter.setFilterWidth(width);
        }
        return this;
    }

    public KaraokePcmAudioFilter updateFilterWidth(FloatToFloatFunction function) {
        return this.setFilterWidth(function.apply(this.filterWidth));
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        if (this.converter == null || input.length != 2) {
            this.downstream.process(input, offset, length);
            return;
        }
        float[] left = input[0];
        float[] right = input[1];
        this.converter.process(left, right, offset, left, right, 0, length);
        this.downstream.process(input, 0, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

