/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.natives;

import com.github.natanbc.lavadsp.natives.TimescaleLibrary;
import com.github.natanbc.lavadsp.natives.TimescaleNativeLibLoader;
import com.github.natanbc.nativeloader.NativeResourceHolder;

public class TimescaleConverter
extends NativeResourceHolder {
    private final int[] buffer = new int[1];
    private final long instance;

    public TimescaleConverter(int channels, int sampleRate) {
        if (channels < 1) {
            throw new IllegalArgumentException("Channels < 1");
        }
        if (sampleRate < 1) {
            throw new IllegalArgumentException("Sample rate < 1");
        }
        TimescaleNativeLibLoader.loadTimescaleLibrary();
        this.instance = TimescaleLibrary.create(channels, sampleRate);
        this.setRate(1.0);
    }

    public void reset() {
        this.checkNotReleased();
        TimescaleLibrary.reset(this.instance);
    }

    public int process(float[] input, int inputOffset, int inputLength, float[] output, int outputOffset, int outputLength) {
        this.checkNotReleased();
        int error = TimescaleLibrary.process(this.instance, input, inputOffset, inputLength, output, outputOffset, outputLength, this.buffer);
        if (error != 0) {
            throw new IllegalStateException("Library returned code " + error);
        }
        return this.buffer[0];
    }

    public int read(float[] output, int outputOffset, int outputLength) {
        this.checkNotReleased();
        return TimescaleLibrary.read(this.instance, output, outputOffset, outputLength);
    }

    public void setSpeed(double speed) {
        this.checkNotReleased();
        if (speed <= 0.0) {
            throw new IllegalArgumentException("speed <= 0");
        }
        TimescaleLibrary.setSpeed(this.instance, speed);
    }

    public void setPitch(double pitch) {
        this.checkNotReleased();
        if (pitch <= 0.0) {
            throw new IllegalArgumentException("pitch <= 0");
        }
        TimescaleLibrary.setPitch(this.instance, pitch);
    }

    public void setRate(double rate) {
        this.checkNotReleased();
        if (rate <= 0.0) {
            throw new IllegalArgumentException("rate <= 0");
        }
        TimescaleLibrary.setRate(this.instance, rate);
    }

    public int getNominalInputSequence() {
        return this.getSetting(6);
    }

    public int getNominalOutputSequence() {
        return this.getSetting(7);
    }

    public int getInitialLatency() {
        return this.getSetting(8);
    }

    public int getSetting(int setting) {
        this.checkNotReleased();
        return TimescaleLibrary.getSetting(this.instance, setting);
    }

    public boolean setSetting(int setting, int value) {
        this.checkNotReleased();
        return TimescaleLibrary.setSetting(this.instance, setting, value);
    }

    public double getInputOutputSampleRatio() {
        this.checkNotReleased();
        return TimescaleLibrary.getInputOutputSampleRatio(this.instance);
    }

    public void flush() {
        this.checkNotReleased();
        TimescaleLibrary.flush(this.instance);
    }

    public int numUnprocessedSamples() {
        this.checkNotReleased();
        return TimescaleLibrary.numUnprocessedSamples(this.instance);
    }

    public int numSamples() {
        this.checkNotReleased();
        return TimescaleLibrary.numSamples(this.instance);
    }

    public boolean isEmpty() {
        this.checkNotReleased();
        return TimescaleLibrary.isEmpty(this.instance);
    }

    @Override
    protected void freeResources() {
        TimescaleLibrary.destroy(this.instance);
    }
}

