/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader;

import com.github.natanbc.nativeloader.DetectorLoader;
import com.github.natanbc.nativeloader.LibraryBinaryLoader;
import com.github.natanbc.nativeloader.NativeLibraryProperties;
import com.github.natanbc.nativeloader.SystemNativeLibraryProperties;
import com.github.natanbc.nativeloader.feature.CPUFeature;
import com.github.natanbc.nativeloader.system.CPUInfo;
import com.github.natanbc.nativeloader.system.SystemType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeLibLoader.class);
    private final Object lock = new Object();
    private final List<OptionalPart> parts = new ArrayList<OptionalPart>();
    private final NativeLibraryProperties properties;
    private final LibraryBinaryLoader loader;
    private final String baseName;
    private volatile Throwable previousFailure;
    private volatile Boolean previousResult;
    private Predicate<SystemType> systemFilter;

    private NativeLibLoader(NativeLibraryProperties properties, LibraryBinaryLoader loader, String baseName) {
        this.properties = properties;
        this.loader = loader;
        this.baseName = baseName;
    }

    @Nonnull
    @CheckReturnValue
    public NativeLibLoader withFeature(@Nonnull CPUFeature feature) {
        return this.withFeature(feature, feature.nativeName().toLowerCase());
    }

    @Nonnull
    @CheckReturnValue
    public NativeLibLoader withFeature(@Nonnull CPUFeature feature, @Nonnull String part) {
        this.parts.add(new OptionalPart(feature, part));
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public NativeLibLoader systemFilter(@Nonnull Predicate<SystemType> filter2) {
        this.systemFilter = filter2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Boolean result = this.previousResult;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.previousResult;
                if (result == null) {
                    log.info("Native library {}: loading with parts {}", (Object)this.baseName, (Object)this.parts);
                    try {
                        this.load0();
                        this.previousResult = true;
                    }
                    catch (Throwable e) {
                        log.error("Native library {}: loading failed.", (Object)this.baseName, (Object)e);
                        this.previousFailure = e;
                        this.previousResult = false;
                        throw NativeLibLoader.uncheck(e);
                    }
                    return;
                }
            }
        }
        if (!result.booleanValue()) {
            throw NativeLibLoader.uncheck(this.previousFailure);
        }
    }

    private void load0() {
        String explicitPath = this.properties.libraryPath();
        if (explicitPath != null) {
            log.debug("Native library {}: explicit path provided {}", (Object)this.baseName, (Object)explicitPath);
            this.loadFromFile(Paths.get(explicitPath, new String[0]).toAbsolutePath());
        } else {
            SystemType type = this.detectMatchingSystemType();
            if (type != null) {
                String explicitDirectory = this.properties.libraryDirectory();
                if (explicitDirectory != null) {
                    log.debug("Native library {}: explicit directory provided {}", (Object)this.baseName, (Object)explicitDirectory);
                    this.loadFromFile(Paths.get(explicitDirectory, type.formatLibraryName(this.baseName)).toAbsolutePath());
                } else {
                    this.loadFromFile(this.extractLibraryFromResources(type));
                }
            }
        }
    }

    private SystemType detectMatchingSystemType() {
        SystemType systemType;
        try {
            systemType = SystemType.detect(this.properties);
        }
        catch (IllegalArgumentException e) {
            if (this.systemFilter != null) {
                log.info("Native library {}: could not detect system type, but system filter is present - assuming it does not match and skipping library.", (Object)this.baseName);
                return null;
            }
            throw e;
        }
        if (this.systemFilter != null && !this.systemFilter.test(systemType)) {
            log.debug("Native library {}: system filter does not match detected system {}, skipping", (Object)this.baseName, (Object)systemType.formatSystemName());
            return null;
        }
        return systemType;
    }

    private void loadFromFile(Path libraryFilePath) {
        log.debug("Native library {}: attempting to load library at {}", (Object)this.baseName, (Object)libraryFilePath);
        System.load(libraryFilePath.toAbsolutePath().toString());
        log.info("Native library {}: successfully loaded.", (Object)this.baseName);
    }

    private Path extractLibraryFromResources(SystemType type) {
        Path path;
        block17: {
            StringBuilder libraryNameBuilder = new StringBuilder(this.baseName);
            for (OptionalPart part : this.parts) {
                CPUInfo info = DetectorLoader.loadDetector(this.loader);
                if (part.feature.cpuType() != info.arch().cpuType() || !info.features().getOrDefault(part.feature.nativeName(), false).booleanValue()) continue;
                libraryNameBuilder.append('-').append(part.part);
            }
            String libraryName = libraryNameBuilder.toString();
            log.debug("Native library {}: resolved file to {}", (Object)this.baseName, (Object)libraryName);
            InputStream libraryStream = this.loader.loadLibrary(type, libraryName);
            try {
                if (libraryStream == null) {
                    throw new UnsatisfiedLinkError("Required library was not found");
                }
                Path extractedLibraryPath = this.prepareExtractionDirectory().resolve(type.formatLibraryName(libraryName));
                try (FileOutputStream fileStream = new FileOutputStream(extractedLibraryPath.toFile());){
                    int r;
                    byte[] buffer = new byte[1024];
                    while ((r = libraryStream.read(buffer)) != -1) {
                        fileStream.write(buffer, 0, r);
                    }
                }
                path = extractedLibraryPath;
                if (libraryStream == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (libraryStream != null) {
                        try {
                            libraryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            libraryStream.close();
        }
        return path;
    }

    private Path prepareExtractionDirectory() throws IOException {
        Path extractionDirectory = this.detectExtractionBaseDirectory().resolve(String.valueOf(System.currentTimeMillis()));
        if (!Files.isDirectory(extractionDirectory, new LinkOption[0])) {
            log.debug("Native library {}: extraction directory {} does not exist, creating.", (Object)this.baseName, (Object)extractionDirectory);
            try {
                NativeLibLoader.createDirectoriesWithFullPermissions(extractionDirectory);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new IOException("Failed to create directory for unpacked native library.", e);
            }
        } else {
            log.debug("Native library {}: extraction directory {} already exists, using.", (Object)this.baseName, (Object)extractionDirectory);
        }
        return extractionDirectory;
    }

    private Path detectExtractionBaseDirectory() {
        String explicitExtractionBase = this.properties.extractionPath();
        if (explicitExtractionBase != null) {
            log.debug("Native library {}: explicit extraction path provided - {}", (Object)this.baseName, (Object)explicitExtractionBase);
            return Paths.get(explicitExtractionBase, new String[0]).toAbsolutePath();
        }
        Path path = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "jni-natives").toAbsolutePath();
        log.debug("Native library {}: detected {} as base directory for extraction.", (Object)this.baseName, (Object)path);
        return path;
    }

    @Nonnull
    @CheckReturnValue
    public static CPUInfo loadSystemInfo() {
        return NativeLibLoader.loadSystemInfo(LibraryBinaryLoader.fromResources());
    }

    @Nonnull
    @CheckReturnValue
    public static CPUInfo loadSystemInfo(@Nonnull LibraryBinaryLoader loader) {
        return DetectorLoader.loadDetector(loader);
    }

    @Nonnull
    @CheckReturnValue
    public static NativeLibLoader create(@Nonnull String libraryName) {
        return NativeLibLoader.create(LibraryBinaryLoader.fromResources(), libraryName);
    }

    @Nonnull
    @CheckReturnValue
    public static NativeLibLoader create(@Nonnull Class<?> owner, @Nonnull String libraryName) {
        return NativeLibLoader.create(LibraryBinaryLoader.fromResources(owner), libraryName);
    }

    @Nonnull
    @CheckReturnValue
    public static NativeLibLoader create(@Nonnull LibraryBinaryLoader loader, @Nonnull String libraryName) {
        return NativeLibLoader.create(new SystemNativeLibraryProperties(libraryName, "nativeloader."), loader, libraryName);
    }

    @Nonnull
    @CheckReturnValue
    public static NativeLibLoader create(@Nonnull NativeLibraryProperties properties, @Nonnull LibraryBinaryLoader loader, @Nonnull String libraryName) {
        return new NativeLibLoader(properties, loader, libraryName);
    }

    private static void createDirectoriesWithFullPermissions(Path path) throws IOException {
        boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        if (!isPosix) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx")));
        }
    }

    private static <E extends Throwable> RuntimeException uncheck(Throwable e) throws E {
        throw e;
    }

    private static class OptionalPart {
        private final CPUFeature feature;
        private final String part;

        private OptionalPart(CPUFeature feature, String part) {
            this.feature = feature;
            this.part = part;
        }

        public String toString() {
            return "Part{feature=" + this.feature.cpuType().name() + "." + this.feature.nativeName() + ", part=" + this.part + "}";
        }
    }
}

