/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.NativeLibraryProperties;
import com.github.natanbc.nativeloader.system.ArchitectureType;
import com.github.natanbc.nativeloader.system.CPUType;
import com.github.natanbc.nativeloader.system.DefaultArchitectureTypes;
import com.github.natanbc.nativeloader.system.DefaultOperatingSystemTypes;
import com.github.natanbc.nativeloader.system.OperatingSystemType;
import java.util.Optional;

public class SystemType {
    private final ArchitectureType architectureType;
    private final OperatingSystemType osType;

    public SystemType(ArchitectureType architectureType, OperatingSystemType osType) {
        this.architectureType = architectureType;
        this.osType = osType;
    }

    public ArchitectureType architectureType() {
        return this.architectureType;
    }

    public OperatingSystemType osType() {
        return this.osType;
    }

    public String formatSystemName() {
        if (this.osType.identifier() != null) {
            if (this.osType == DefaultOperatingSystemTypes.DARWIN) {
                return this.osType.identifier();
            }
            return this.osType.identifier() + "-" + this.architectureType.identifier();
        }
        return this.architectureType.identifier();
    }

    public String formatLibraryName(String libraryName) {
        return this.osType.libraryFilePrefix() + libraryName + this.osType.libraryFileSuffix();
    }

    public static SystemType detect(NativeLibraryProperties properties) {
        return new SystemType(SystemType.detectArch(properties), SystemType.detectOS(properties));
    }

    private static OperatingSystemType detectOS(NativeLibraryProperties properties) {
        String name = properties.operatingSystemName();
        if (name == null) {
            return DefaultOperatingSystemTypes.detect();
        }
        try {
            return DefaultOperatingSystemTypes.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return new UnknownOperatingSystem(name, Optional.ofNullable(properties.libraryFileNamePrefix()).orElse("lib"), Optional.ofNullable(properties.libraryFileNameSuffix()).orElse(".so"));
        }
    }

    private static ArchitectureType detectArch(NativeLibraryProperties properties) {
        String name = properties.architectureName();
        if (name == null) {
            return DefaultArchitectureTypes.detect();
        }
        return DefaultArchitectureTypes.parse(name).orElse(new UnknownArchitecture(name));
    }

    private static class UnknownOperatingSystem
    implements OperatingSystemType {
        private final String identifier;
        private final String libraryFilePrefix;
        private final String libraryFileSuffix;

        private UnknownOperatingSystem(String identifier, String libraryFilePrefix, String libraryFileSuffix) {
            this.identifier = identifier;
            this.libraryFilePrefix = libraryFilePrefix;
            this.libraryFileSuffix = libraryFileSuffix;
        }

        @Override
        public String identifier() {
            return this.identifier;
        }

        @Override
        public String libraryFilePrefix() {
            return this.libraryFilePrefix;
        }

        @Override
        public String libraryFileSuffix() {
            return this.libraryFileSuffix;
        }
    }

    private static class UnknownArchitecture
    implements ArchitectureType {
        private final String identifier;

        private UnknownArchitecture(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public String identifier() {
            return this.identifier;
        }

        @Override
        public CPUType cpuType() {
            return null;
        }
    }
}

