/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc;

import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LavaSrcTools {
    private static final Logger log = LoggerFactory.getLogger(LavaSrcTools.class);

    @Nullable
    public static JsonBrowser fetchResponseAsJson(HttpInterface httpInterface, HttpUriRequest request) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                String data = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
                log.error("Server responded with not found to '{}': {}", (Object)request.getURI(), (Object)data);
                JsonBrowser jsonBrowser = null;
                return jsonBrowser;
            }
            if (statusCode == 204) {
                log.error("Server responded with not content to '{}'", (Object)request.getURI());
                JsonBrowser data = null;
                return data;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                String data = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
                log.error("Server responded with an error to '{}': {}", (Object)request.getURI(), (Object)data);
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code from channel info is " + statusCode));
            }
            String data = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            log.debug("Response from '{}' was successful: {}", (Object)request.getURI(), (Object)data);
            JsonBrowser jsonBrowser = JsonBrowser.parse(data);
            return jsonBrowser;
        }
    }
}

