/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg.reader;

import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegParseStopChecker;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegSectionHandler;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegSectionInfo;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegVersionedSectionHandler;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegVersionedSectionInfo;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MpegReader {
    public final DataInput data;
    public final SeekableInputStream seek;
    private final byte[] fourCcBuffer;
    private final ByteBuffer readAttemptBuffer;

    public MpegReader(SeekableInputStream inputStream) {
        this.seek = inputStream;
        this.data = new DataInputStream(inputStream);
        this.fourCcBuffer = new byte[4];
        this.readAttemptBuffer = ByteBuffer.allocate(4);
    }

    public MpegSectionInfo nextChild(MpegSectionInfo parent) throws IOException {
        if (parent.offset + parent.length <= this.seek.getPosition() + 8L) {
            return null;
        }
        long offset = this.seek.getPosition();
        Integer lengthField = this.tryReadInt();
        if (lengthField == null) {
            return null;
        }
        long length = Integer.toUnsignedLong(lengthField);
        String type = this.readFourCC();
        if (length == 1L) {
            length = this.data.readLong();
        }
        return new MpegSectionInfo(offset, length, type);
    }

    public void skip(MpegSectionInfo section) {
        try {
            this.seek.seek(section.offset + section.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readFourCC() throws IOException {
        this.data.readFully(this.fourCcBuffer);
        return new String(this.fourCcBuffer, StandardCharsets.ISO_8859_1);
    }

    public String readUtfString(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.data.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String readTerminatedString() throws IOException {
        byte nextByte;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((nextByte = this.data.readByte()) != 0) {
            bytes.write(nextByte);
        }
        return new String(bytes.toByteArray(), StandardCharsets.UTF_8);
    }

    public int readCompressedInt() throws IOException {
        int currentByte;
        int byteCount = 0;
        int value = 0;
        do {
            currentByte = this.data.readUnsignedByte();
            value = value << 7 | currentByte & 0x7F;
        } while ((currentByte & 0x80) == 128 && ++byteCount < 4);
        return value;
    }

    public MpegVersionedSectionInfo parseFlags(MpegSectionInfo section) throws IOException {
        return MpegReader.parseFlagsForSection(this.data, section);
    }

    private static MpegVersionedSectionInfo parseFlagsForSection(DataInput in, MpegSectionInfo section) throws IOException {
        int versionAndFlags = in.readInt();
        return new MpegVersionedSectionInfo(section, versionAndFlags >>> 24, versionAndFlags & 0xFFFFFF);
    }

    private Integer tryReadInt() throws IOException {
        int firstByte = this.seek.read();
        if (firstByte == -1) {
            return null;
        }
        this.readAttemptBuffer.put(0, (byte)firstByte);
        this.data.readFully(this.readAttemptBuffer.array(), 1, 3);
        return this.readAttemptBuffer.getInt(0);
    }

    public Chain in(MpegSectionInfo parent) {
        return new Chain(parent, this);
    }

    private static class Handler {
        private final String type;
        private final boolean terminator;
        private final Object sectionHandler;

        private Handler(String type, boolean terminator, Object sectionHandler) {
            this.type = type;
            this.terminator = terminator;
            this.sectionHandler = sectionHandler;
        }
    }

    public static class Chain {
        private final MpegSectionInfo parent;
        private final List<Handler> handlers;
        private final MpegReader reader;
        private MpegParseStopChecker stopChecker;

        private Chain(MpegSectionInfo parent, MpegReader reader) {
            this.parent = parent;
            this.reader = reader;
            this.handlers = new ArrayList<Handler>();
        }

        public Chain handle(String type, MpegSectionHandler handler) {
            this.handle(type, false, handler);
            return this;
        }

        public Chain handle(String type, boolean finish, MpegSectionHandler handler) {
            this.handlers.add(new Handler(type, finish, handler));
            return this;
        }

        public Chain handleVersioned(String type, MpegVersionedSectionHandler handler) {
            this.handlers.add(new Handler(type, false, handler));
            return this;
        }

        public Chain handleVersioned(String type, boolean finish, MpegVersionedSectionHandler handler) {
            this.handlers.add(new Handler(type, finish, handler));
            return this;
        }

        public Chain stopChecker(MpegParseStopChecker stopChecker) {
            this.stopChecker = stopChecker;
            return this;
        }

        public void run() throws IOException {
            MpegSectionInfo child;
            boolean finished = false;
            while (!finished && (child = this.reader.nextChild(this.parent)) != null) {
                boolean bl = finished = this.stopChecker != null && this.stopChecker.check(child, true);
                if (!finished) {
                    this.processHandlers(child);
                    finished = this.stopChecker != null && this.stopChecker.check(child, false);
                }
                this.reader.skip(child);
            }
        }

        private void processHandlers(MpegSectionInfo child) throws IOException {
            for (Handler handler : this.handlers) {
                if (!handler.type.equals(child.type)) continue;
                this.handleSection(child, handler);
            }
        }

        private boolean handleSection(MpegSectionInfo child, Handler handler) throws IOException {
            if (handler.sectionHandler instanceof MpegVersionedSectionHandler) {
                MpegVersionedSectionInfo versioned = MpegReader.parseFlagsForSection(this.reader.data, child);
                ((MpegVersionedSectionHandler)handler.sectionHandler).handle(versioned);
            } else {
                ((MpegSectionHandler)handler.sectionHandler).handle(child);
            }
            return !handler.terminator;
        }
    }
}

