/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.vimeo;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.Units;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;

public class VimeoAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String TRACK_URL_REGEX = "^https?://vimeo.com/([0-9]+)(?:\\?.*|)$";
    private static final Pattern trackUrlPattern = Pattern.compile("^https?://vimeo.com/([0-9]+)(?:\\?.*|)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "vimeo";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        AudioTrack audioTrack;
        block9: {
            Matcher trackUrl = trackUrlPattern.matcher(reference.identifier);
            if (!trackUrl.matches()) {
                return null;
            }
            HttpInterface httpInterface = this.httpInterfaceManager.getInterface();
            try {
                audioTrack = this.loadVideoFromApi(httpInterface, trackUrl.group(1));
                if (httpInterface == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new FriendlyException("Loading Vimeo track information failed.", FriendlyException.Severity.SUSPICIOUS, e);
                }
            }
            httpInterface.close();
        }
        return audioTrack;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new VimeoAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    HttpInterfaceManager getHttpInterfaceManager() {
        return this.httpInterfaceManager;
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    JsonBrowser loadConfigJsonFromPageContent(String content) throws IOException {
        String configText = DataFormatTools.extractBetween(content, "window.vimeo.clip_page_config = ", "\n");
        if (configText != null) {
            return JsonBrowser.parse(configText);
        }
        return null;
    }

    private AudioItem loadFromTrackPage(HttpInterface httpInterface, String trackUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(trackUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code is " + statusCode));
            }
            AudioTrack audioTrack = this.loadTrackFromPageContent(trackUrl, IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            return audioTrack;
        }
    }

    private AudioTrack loadTrackFromPageContent(String trackUrl, String content) throws IOException {
        JsonBrowser config = this.loadConfigJsonFromPageContent(content);
        if (config == null) {
            throw new FriendlyException("Track information not found on the page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return new VimeoAudioTrack(new AudioTrackInfo(config.get("clip").get("title").text(), config.get("owner").get("display_name").text(), (long)(config.get("clip").get("duration").get("raw").as(Double.class) * 1000.0), trackUrl, false, trackUrl, config.get("thumbnail").get("src").text(), null), this);
    }

    private AudioTrack loadVideoFromApi(HttpInterface httpInterface, String videoId) throws IOException, URISyntaxException {
        JsonBrowser videoData = this.getVideoFromApi(httpInterface, videoId);
        AudioTrackInfo info = new AudioTrackInfo(videoData.get("name").text(), videoData.get("uploader").get("name").textOrDefault("Unknown artist"), Units.secondsToMillis(videoData.get("duration").asLong(Long.MAX_VALUE)), videoId, false, "https://vimeo.com/" + videoId, videoData.get("pictures").get("base_link").text(), null);
        return new VimeoAudioTrack(info, this);
    }

    public JsonBrowser getVideoFromApi(HttpInterface httpInterface, String videoId) throws IOException, URISyntaxException {
        String jwt = this.getApiJwt(httpInterface);
        URIBuilder builder = new URIBuilder("https://api.vimeo.com/videos/" + videoId);
        builder.setParameter("fields", "config_url,name,uploader.name,duration,pictures");
        HttpGet request = new HttpGet(builder.build());
        request.setHeader("Authorization", "jwt " + jwt);
        request.setHeader("Accept", "application/json");
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            HttpClientTools.assertSuccessWithContent(response, "fetch video api");
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    public PlaybackFormat getPlaybackFormat(HttpInterface httpInterface, String configUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(configUrl));){
            JsonBrowser progressive;
            HttpClientTools.assertSuccessWithContent(response, "fetch playback formats");
            JsonBrowser json2 = JsonBrowser.parse(response.getEntity().getContent());
            JsonBrowser files = json2.get("request").get("files");
            if (!files.get("progressive").isNull() && !(progressive = files.get("progressive").index(0)).isNull()) {
                PlaybackFormat playbackFormat = new PlaybackFormat(progressive.get("url").text(), false);
                return playbackFormat;
            }
            if (!files.get("hls").isNull()) {
                JsonBrowser hls = files.get("hls");
                JsonBrowser cdns = hls.get("cdns");
                PlaybackFormat playbackFormat = new PlaybackFormat(cdns.get(hls.get("default_cdn").text()).get("url").text(), true);
                return playbackFormat;
            }
            throw new RuntimeException("No supported formats");
        }
    }

    private String getApiJwt(HttpInterface httpInterface) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://vimeo.com/_next/viewer"));){
            HttpClientTools.assertSuccessWithContent(response, "fetch jwt");
            JsonBrowser json2 = JsonBrowser.parse(response.getEntity().getContent());
            String string = json2.get("jwt").text();
            return string;
        }
    }

    public static class PlaybackFormat {
        public final String url;
        public final boolean isHls;

        public PlaybackFormat(String url, boolean isHls) {
            this.url = url;
            this.isHls = isHls;
        }
    }
}

