/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube;

import dev.lavalink.youtube.clients.Web;
import dev.lavalink.youtube.clients.WebEmbedded;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeSource {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSource.class);
    public static String VERSION = "Unknown";

    public static void setPoTokenAndVisitorData(String poToken, String visitorData) {
        log.debug("Applying pot: {} vd: {} to WEB, WEBEMBEDDED", (Object)poToken, (Object)visitorData);
        Web.setPoTokenAndVisitorData(poToken, visitorData);
        WebEmbedded.setPoTokenAndVisitorData(poToken, visitorData);
    }

    static {
        try (InputStream versionStream = YoutubeSource.class.getResourceAsStream("/yts-version.txt");){
            if (versionStream != null) {
                byte[] content = new byte[versionStream.available()];
                versionStream.read(content);
                String versionS = new String(content);
                if (!versionS.startsWith("@")) {
                    VERSION = versionS;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

