/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.track;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.lavalink.youtube.CannotBeLoaded;
import dev.lavalink.youtube.ClientInformation;
import dev.lavalink.youtube.UrlTools;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.cipher.ScriptExtractionException;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.track.YoutubeMpegStreamAudioTrack;
import dev.lavalink.youtube.track.YoutubePersistentHttpStream;
import dev.lavalink.youtube.track.format.StreamFormat;
import dev.lavalink.youtube.track.format.TrackFormats;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    public static long BAD_STREAM_POSITION_THRESHOLD_MS = 3000L;
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(@NotNull AudioTrackInfo trackInfo, @NotNull YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        Client[] clients = this.sourceManager.getClients();
        if (Arrays.stream(clients).noneMatch(Client::supportsFormatLoading)) {
            throw new FriendlyException("This video cannot be played", FriendlyException.Severity.COMMON, new RuntimeException("None of the registered clients supports loading of formats"));
        }
        try {
            HttpInterface httpInterface = this.sourceManager.getInterface();
            try {
                JsonBrowser jsonUserData;
                Object userData = this.getUserData();
                if (userData != null && (jsonUserData = JsonBrowser.parse(userData.toString())).get("oauth-token") != null) {
                    httpInterface.getContext().setAttribute("yt-oauth-token", jsonUserData.get("oauth-token").text());
                }
            }
            catch (IOException e) {
                log.debug("Failed to parse token from userData", e);
            }
            Throwable lastException = null;
            for (Client client : clients) {
                if (!client.supportsFormatLoading()) continue;
                httpInterface.getContext().setAttribute("yt-oauth-enabled-client", client.supportsOAuth());
                try {
                    this.processWithClient(localExecutor, httpInterface, client, 0L);
                    return;
                }
                catch (RuntimeException e) {
                    e.addSuppressed(ClientInformation.create(client));
                    lastException = e;
                    if (e instanceof FriendlyException || (e instanceof ScriptExtractionException ? localExecutor.getPosition() <= BAD_STREAM_POSITION_THRESHOLD_MS : ("Not success status code: 403".equals(e.getMessage()) || "Invalid status code for player api response: 400".equals(e.getMessage())) && localExecutor.getPosition() <= BAD_STREAM_POSITION_THRESHOLD_MS)) continue;
                    throw e;
                }
            }
            if (lastException == null) return;
            if (!(lastException instanceof FriendlyException)) throw ExceptionTools.toRuntimeException(lastException);
            if ("YouTube WebM streams are currently not supported.".equals(lastException.getMessage())) throw lastException;
            throw new FriendlyException(lastException.getMessage(), FriendlyException.Severity.SUSPICIOUS, lastException.getCause());
            finally {
                if (httpInterface != null) {
                    httpInterface.close();
                }
            }
        }
        catch (CannotBeLoaded e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("This video is unavailable", FriendlyException.Severity.SUSPICIOUS, e.getCause());
        }
    }

    private void processWithClient(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, Client client, long streamPosition) throws CannotBeLoaded, Exception {
        FormatWithUrl augmentedFormat = this.loadBestFormatWithUrl(httpInterface, client);
        log.debug("Starting track with URL from client {}: {}", (Object)client.getIdentifier(), (Object)augmentedFormat.signedUrl);
        try {
            if (this.trackInfo.isStream || augmentedFormat.format.getContentLength() == Long.MAX_VALUE) {
                this.processStream(localExecutor, httpInterface, augmentedFormat);
            } else {
                this.processStatic(localExecutor, httpInterface, augmentedFormat, streamPosition);
            }
        }
        catch (StreamExpiredException e) {
            this.processWithClient(localExecutor, httpInterface, client, e.lastStreamPosition);
        }
    }

    private void processStatic(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl augmentedFormat, long streamPosition) throws Exception {
        try (PersistentHttpStream stream = null;){
            stream = new YoutubePersistentHttpStream(httpInterface, augmentedFormat.signedUrl, augmentedFormat.format.getContentLength());
            if (streamPosition > 0L) {
                stream.seek(streamPosition);
            }
            if (augmentedFormat.format.getType().getMimeType().endsWith("/webm")) {
                this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
            } else {
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void processStream(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl augmentedFormat) throws Exception {
        if ("audio/webm".equals(augmentedFormat.format.getType().getMimeType())) {
            throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
        }
        this.processDelegate(new YoutubeMpegStreamAudioTrack(this.trackInfo, httpInterface, augmentedFormat.signedUrl), localExecutor);
    }

    @NotNull
    private FormatWithUrl loadBestFormatWithUrl(@NotNull HttpInterface httpInterface, @NotNull Client client) throws CannotBeLoaded, Exception {
        if (!client.supportsFormatLoading()) {
            throw new RuntimeException(client.getIdentifier() + " does not support loading of formats!");
        }
        TrackFormats formats = client.loadFormats(this.sourceManager, httpInterface, this.getIdentifier());
        if (formats == null) {
            throw new FriendlyException("This video cannot be played", FriendlyException.Severity.SUSPICIOUS, null);
        }
        StreamFormat format = formats.getBestFormat();
        URI resolvedUrl = format.getUrl();
        if (client.requirePlayerScript()) {
            resolvedUrl = this.sourceManager.getCipherManager().resolveFormatUrl(httpInterface, formats.getPlayerScriptUrl(), format);
            resolvedUrl = client.transformPlaybackUri(format.getUrl(), resolvedUrl);
        }
        return new FormatWithUrl(format, resolvedUrl);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    private static class FormatWithUrl {
        private final StreamFormat format;
        private final URI signedUrl;

        private FormatWithUrl(@NotNull StreamFormat format, @NotNull URI signedUrl) {
            this.format = format;
            this.signedUrl = signedUrl;
        }

        public boolean isExpired() {
            UrlTools.UrlInfo urlInfo = UrlTools.getUrlInfo(this.signedUrl.toString(), true);
            String expire = urlInfo.parameters.get("expire");
            if (expire == null) {
                return false;
            }
            long expiresAbsMillis = Long.parseLong(expire) * 1000L;
            return System.currentTimeMillis() >= expiresAbsMillis;
        }

        @Nullable
        public FormatWithUrl getFallback() {
            String signedString = this.signedUrl.toString();
            Map<String, String> urlParameters = DataFormatTools.decodeUrlEncodedItems(signedString, false);
            String mn = urlParameters.get("mn");
            if (mn == null) {
                return null;
            }
            CharSequence[] hosts = mn.split(",");
            if (hosts.length < 2) {
                log.warn("Cannot fallback, available hosts: {}", (Object)String.join((CharSequence)", ", hosts));
                return null;
            }
            String newUrl = signedString.replaceFirst(hosts[0], (String)hosts[1]);
            try {
                URI uri = new URI(newUrl);
                return new FormatWithUrl(this.format, uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }

    private static class StreamExpiredException
    extends RuntimeException {
        private final long lastStreamPosition;

        private StreamExpiredException(long lastStreamPosition, @NotNull Throwable cause) {
            super(null, cause, true, false);
            this.lastStreamPosition = lastStreamPosition;
        }
    }
}

