/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.stream.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import net.lenni0451.reflect.Methods;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.general.ModifierWrapper;
import net.lenni0451.reflect.stream.method.MethodStream;

public class MethodWrapper {
    private final MethodStream parent;
    private final Method method;
    private final ModifierWrapper modifier;

    public MethodWrapper(MethodStream parent, Method method) {
        this.parent = parent;
        this.method = method;
        this.modifier = new ModifierWrapper(method.getModifiers());
    }

    public MethodStream parent() {
        return this.parent;
    }

    public Method raw() {
        return this.method;
    }

    public String name() {
        return this.method.getName();
    }

    public Class<?> returnType() {
        return this.method.getReturnType();
    }

    public Class<?>[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    public int parameterCount() {
        return this.method.getParameterCount();
    }

    public Class<?> owner() {
        return this.method.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public Stream<Annotation> annotations() {
        return Arrays.stream(this.method.getDeclaredAnnotations());
    }

    public <T> T invoke() {
        return this.invokeArgs(new Object[0]);
    }

    public RStream stream() {
        return RStream.of(this.invoke());
    }

    public RStream stream(Class<?> clazz) {
        return RStream.of(clazz, this.invoke());
    }

    public <T> T invokeArgs(Object ... args2) {
        if (!this.modifier.isStatic() && this.parent.parent().instance() == null) {
            throw new IllegalStateException("Can not invoke non-static method if no instance is provided");
        }
        return Methods.invoke(this.parent.parent().instance(), this.method, args2);
    }

    public RStream streamArgs(Object ... args2) {
        return RStream.of(this.invokeArgs(args2));
    }

    public RStream streamArgs(Class<?> clazz, Object ... args2) {
        return RStream.of(clazz, this.invokeArgs(args2));
    }

    public <T> T invokeInstance(Object instance, Object ... args2) {
        return Methods.invoke(instance, this.method, args2);
    }

    public RStream streamInstance(Object instance, Object ... args2) {
        return RStream.of(this.invokeInstance(instance, args2));
    }

    public RStream streamInstance(Class<?> clazz, Object instance, Object ... args2) {
        return RStream.of(clazz, this.invokeInstance(instance, args2));
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodWrapper) {
            return this.method.equals(((MethodWrapper)obj).method);
        }
        if (obj instanceof Method) {
            return this.method.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

