/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dsf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jaudiotagger.audio.dsf.DsdChunk;
import org.jaudiotagger.audio.dsf.DsfChunkType;
import org.jaudiotagger.audio.dsf.FmtChunk;
import org.jaudiotagger.audio.dsf.ID3Chunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader2;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class DsfFileReader
extends AudioFileReader2 {
    @Override
    protected GenericAudioHeader getEncodingInfo(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd != null) {
                ByteBuffer fmtChunkBuffer = Utils.readFileDataIntoBufferLE(fc, IffHeaderChunk.SIGNATURE_LENGTH + 8);
                FmtChunk fmt = FmtChunk.readChunkHeader(fmtChunkBuffer);
                if (fmt != null) {
                    GenericAudioHeader genericAudioHeader = fmt.readChunkData(dsd, fc);
                    return genericAudioHeader;
                }
                throw new CannotReadException(file + " Not a valid dsf file. Content does not include 'fmt ' chunk");
            }
            throw new CannotReadException(file + " Not a valid dsf file. Content does not start with 'DSD '");
        }
    }

    @Override
    protected Tag getTag(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, DsdChunk.DSD_HEADER_LENGTH));
            if (dsd != null) {
                Tag tag = this.readTag(fc, dsd, file.toString());
                return tag;
            }
            throw new CannotReadException(file + " Not a valid dsf file. Content does not start with 'DSD '.");
        }
    }

    private Tag readTag(FileChannel fc, DsdChunk dsd, String fileName) throws CannotReadException, IOException {
        if (dsd.getMetadataOffset() > 0L) {
            fc.position(dsd.getMetadataOffset());
            if (fc.size() - fc.position() >= (long)DsfChunkType.ID3.getCode().length()) {
                ID3Chunk id3Chunk = ID3Chunk.readChunk(Utils.readFileDataIntoBufferLE(fc, (int)(fc.size() - fc.position())));
                if (id3Chunk != null) {
                    byte version = id3Chunk.getDataBuffer().get(3);
                    try {
                        switch (version) {
                            case 2: {
                                return new ID3v22Tag(id3Chunk.getDataBuffer(), fileName);
                            }
                            case 3: {
                                return new ID3v23Tag(id3Chunk.getDataBuffer(), fileName);
                            }
                            case 4: {
                                return new ID3v24Tag(id3Chunk.getDataBuffer(), fileName);
                            }
                        }
                        return null;
                    }
                    catch (TagException e) {
                        throw new CannotReadException(fileName + " Could not read ID3v2 tag:corruption");
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

