/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.iff.PaddingChunkSummary;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavSaveOptions;
import org.jaudiotagger.audio.wav.WavSaveOrder;
import org.jaudiotagger.audio.wav.WavTagReader;
import org.jaudiotagger.audio.wav.chunk.WavChunkSummary;
import org.jaudiotagger.audio.wav.chunk.WavInfoIdentifier;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavTagWriter {
    private String loggingName;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");

    public WavTagWriter(String loggingName) {
        this.loggingName = loggingName;
    }

    public WavTag getExistingMetadata(Path path) throws IOException, CannotWriteException {
        try {
            WavTagReader im = new WavTagReader(this.loggingName);
            return im.read(path);
        }
        catch (CannotReadException ex) {
            throw new CannotWriteException("Failed to read file " + path);
        }
    }

    public ChunkHeader seekToStartOfListInfoMetadata(FileChannel fc, WavTag existingTag) throws IOException, CannotWriteException {
        fc.position(existingTag.getInfoTag().getStartLocationInFile());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.LIST.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find List chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    public ChunkHeader seekToStartOfListInfoMetadataForChunkSummaryHeader(FileChannel fc, ChunkSummary cs) throws IOException, CannotWriteException {
        fc.position(cs.getFileStartLocation());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.LIST.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find List chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    public ChunkHeader seekToStartOfId3MetadataForChunkSummaryHeader(FileChannel fc, WavTag existingTag) throws IOException, CannotWriteException {
        fc.position(existingTag.getStartLocationInFileOfId3Chunk());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.ID3.getCode().equals(chunkHeader.getID()) && !WavChunkType.ID3_UPPERCASE.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find ID3 chunk at original location has file been modified externally:" + chunkHeader.getID());
        }
        if (WavChunkType.ID3_UPPERCASE.getCode().equals(chunkHeader.getID())) {
            // empty if block
        }
        return chunkHeader;
    }

    public ChunkHeader seekToStartOfId3MetadataForChunkSummaryHeader(FileChannel fc, ChunkSummary chunkSummary) throws IOException, CannotWriteException {
        fc.position(chunkSummary.getFileStartLocation());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!WavChunkType.ID3.getCode().equals(chunkHeader.getID()) && !WavChunkType.ID3_UPPERCASE.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(this.loggingName + " Unable to find ID3 chunk at original location has file been modified externally:" + chunkHeader.getID());
        }
        if (WavChunkType.ID3_UPPERCASE.getCode().equals(chunkHeader.getID())) {
            // empty if block
        }
        return chunkHeader;
    }

    public void delete(Tag tag, Path file) throws CannotWriteException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            WavTag existingTag = this.getExistingMetadata(file);
            if (existingTag.isExistingId3Tag() && existingTag.isExistingInfoTag()) {
                BothTagsFileStructure fs = this.checkExistingLocations(existingTag, fc);
                if (fs.isContiguous) {
                    if (fs.isAtEnd) {
                        if (fs.isInfoTagFirst) {
                            fc.truncate(existingTag.getInfoTag().getStartLocationInFile());
                        } else {
                            fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                        }
                    } else if (fs.isInfoTagFirst) {
                        int lengthTagChunk = (int)(existingTag.getEndLocationInFileOfId3Chunk() - existingTag.getInfoTag().getStartLocationInFile());
                        this.deleteTagChunk(fc, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
                    } else {
                        int lengthTagChunk = (int)((long)existingTag.getInfoTag().getEndLocationInFile().intValue() - existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteTagChunk(fc, existingTag.getInfoTag().getEndLocationInFile().intValue(), lengthTagChunk);
                    }
                } else {
                    WavInfoTag existingInfoTag = existingTag.getInfoTag();
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                    ChunkHeader id3ChunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
                    if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingInfoTag.getStartLocationInFile());
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    } else if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    } else if (existingTag.getInfoTag().getStartLocationInFile() > existingTag.getStartLocationInFileOfId3Chunk()) {
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                    } else {
                        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
                        this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
                    }
                }
            } else if (existingTag.isExistingInfoTag()) {
                WavInfoTag existingInfoTag = existingTag.getInfoTag();
                ChunkHeader chunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
                if (existingInfoTag.getEndLocationInFile().longValue() == fc.size()) {
                    fc.truncate(existingInfoTag.getStartLocationInFile());
                } else {
                    this.deleteInfoTagChunk(fc, existingTag, chunkHeader);
                }
            } else if (existingTag.isExistingId3Tag()) {
                ChunkHeader chunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
                if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                    fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                } else {
                    this.deleteId3TagChunk(fc, existingTag, chunkHeader);
                }
            }
            this.rewriteRiffHeaderSize(fc);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void deleteInfoTagChunk(FileChannel fc, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        WavInfoTag existingInfoTag = existingTag.getInfoTag();
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        this.deleteTagChunk(fc, existingInfoTag.getEndLocationInFile().intValue(), lengthTagChunk);
    }

    private void deleteId3TagChunk(FileChannel fc, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        if (Utils.isOddLength(existingTag.getEndLocationInFileOfId3Chunk())) {
            this.deleteTagChunk(fc, (int)existingTag.getEndLocationInFileOfId3Chunk() + 1, lengthTagChunk + 1);
        } else {
            this.deleteTagChunk(fc, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
        }
    }

    private void deleteTagChunk(FileChannel fc, int endOfExistingChunk, int lengthTagChunk) throws IOException {
        fc.position(endOfExistingChunk);
        ByteBuffer buffer = ByteBuffer.allocate((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (fc.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = fc.position();
            fc.position(readPosition - (long)lengthTagChunk - (long)buffer.limit());
            fc.write(buffer);
            fc.position(readPosition);
            buffer.compact();
        }
        long newLength = fc.size() - (long)lengthTagChunk;
        fc.truncate(newLength);
    }

    public void write(Tag tag, Path file) throws CannotWriteException {
        WavSaveOptions wso = TagOptionSingleton.getInstance().getWavSaveOptions();
        WavTag existingTag = null;
        try {
            existingTag = this.getExistingMetadata(file);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
        if (existingTag.isBadChunkData()) {
            throw new CannotWriteException("Unable to make changes to this file because contains bad chunk data");
        }
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            WavTag wavTag = (WavTag)tag;
            if (wso == WavSaveOptions.SAVE_BOTH) {
                this.saveBoth(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_ACTIVE) {
                this.saveActive(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_EXISTING_AND_ACTIVE) {
                this.saveActiveExisting(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_BOTH_AND_SYNC) {
                wavTag.syncTagBeforeWrite();
                this.saveBoth(wavTag, fc, existingTag);
            } else if (wso == WavSaveOptions.SAVE_EXISTING_AND_ACTIVE_AND_SYNC) {
                wavTag.syncTagBeforeWrite();
                this.saveActiveExisting(wavTag, fc, existingTag);
            } else {
                throw new RuntimeException(this.loggingName + " No setting for:WavSaveOptions");
            }
            if (existingTag.isNonStandardPadding()) {
                for (ChunkSummary cs : existingTag.getChunkSummaryList()) {
                    if (!(cs instanceof PaddingChunkSummary)) continue;
                    boolean isPaddingData = true;
                    fc.position(cs.getFileStartLocation());
                    ByteBuffer paddingData = ByteBuffer.allocate((int)cs.getChunkSize());
                    fc.read(paddingData);
                    paddingData.flip();
                    while (paddingData.position() < paddingData.limit()) {
                        if (paddingData.get() == 0) continue;
                        isPaddingData = false;
                    }
                    if (!isPaddingData) break;
                    fc.position(cs.getFileStartLocation());
                    this.deletePaddingChunk(fc, (int)cs.getEndLocation(), (int)cs.getChunkSize() + 8);
                    break;
                }
            }
            this.rewriteRiffHeaderSize(fc);
        }
        catch (AccessDeniedException ade) {
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void deletePaddingChunk(FileChannel fc, int endOfExistingChunk, int lengthTagChunk) throws IOException {
        fc.position(endOfExistingChunk);
        ByteBuffer buffer = ByteBuffer.allocate((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (fc.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = fc.position();
            fc.position(readPosition - (long)lengthTagChunk - (long)buffer.limit());
            fc.write(buffer);
            fc.position(readPosition);
            buffer.compact();
        }
        long newLength = fc.size() - (long)lengthTagChunk;
        fc.truncate(newLength);
    }

    private void rewriteRiffHeaderSize(FileChannel fc) throws IOException {
        fc.position(IffHeaderChunk.SIGNATURE_LENGTH);
        ByteBuffer bb = ByteBuffer.allocateDirect(IffHeaderChunk.SIZE_LENGTH);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = (int)fc.size() - IffHeaderChunk.SIGNATURE_LENGTH - IffHeaderChunk.SIZE_LENGTH;
        bb.putInt(size);
        bb.flip();
        fc.write(bb);
    }

    private void writeInfoDataToFile(FileChannel fc, ByteBuffer bb, long chunkSize) throws IOException {
        if (Utils.isOddLength(fc.position())) {
            this.writePaddingToFile(fc, 1);
        }
        ByteBuffer listHeaderBuffer = ByteBuffer.allocate(8);
        listHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listHeaderBuffer.put(WavChunkType.LIST.getCode().getBytes(StandardCharsets.US_ASCII));
        listHeaderBuffer.putInt((int)chunkSize);
        listHeaderBuffer.flip();
        fc.write(listHeaderBuffer);
        fc.write(bb);
        this.writeExtraByteIfChunkOddSize(fc, chunkSize);
    }

    private void writeInfoDataToFile(FileChannel fc, ByteBuffer bb) throws IOException {
        this.writeInfoDataToFile(fc, bb, bb.limit());
    }

    private void writeId3DataToFile(FileChannel fc, ByteBuffer bb) throws IOException {
        if (Utils.isOddLength(fc.position())) {
            this.writePaddingToFile(fc, 1);
        }
        ByteBuffer listBuffer = ByteBuffer.allocate(8);
        listBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listBuffer.put(WavChunkType.ID3.getCode().getBytes(StandardCharsets.US_ASCII));
        listBuffer.putInt(bb.limit());
        listBuffer.flip();
        fc.write(listBuffer);
        fc.write(bb);
    }

    private void writePaddingToFile(FileChannel fc, int paddingSize) throws IOException {
        fc.write(ByteBuffer.allocateDirect(paddingSize));
    }

    private void writeField(TagTextField tagTextField, String code, ByteArrayOutputStream baos) {
        try {
            baos.write(code.getBytes(StandardCharsets.US_ASCII));
            byte[] contentConvertedToBytes = tagTextField.getContent().getBytes(StandardCharsets.ISO_8859_1);
            baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
            baos.write(contentConvertedToBytes);
            if (Utils.isOddLength(contentConvertedToBytes.length)) {
                baos.write(0);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public ByteBuffer convertInfoChunk(WavTag tag) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WavInfoTag wif = tag.getInfoTag();
        List<TagField> fields = wif.getAll();
        Collections.sort(fields, new InfoFieldWriterOrderComparator());
        boolean isTrackRewritten = false;
        for (TagField nextField : fields) {
            TagTextField next = (TagTextField)nextField;
            WavInfoIdentifier wii = WavInfoIdentifier.getByFieldKey(FieldKey.valueOf(next.getId()));
            this.writeField(next, wii.getCode(), baos);
            if (wii != WavInfoIdentifier.TRACKNO || !TagOptionSingleton.getInstance().isWriteWavForTwonky()) continue;
            isTrackRewritten = true;
            this.writeField(next, WavInfoIdentifier.TWONKY_TRACKNO.getCode(), baos);
        }
        for (TagTextField next : wif.getUnrecognisedFields()) {
            if (next.getId().equals(WavInfoIdentifier.TWONKY_TRACKNO.getCode())) {
                if (isTrackRewritten || !TagOptionSingleton.getInstance().isWriteWavForTwonky()) continue;
                isTrackRewritten = true;
                this.writeField(next, WavInfoIdentifier.TWONKY_TRACKNO.getCode(), baos);
                continue;
            }
            this.writeField(next, next.getId(), baos);
        }
        ByteBuffer infoBuffer = ByteBuffer.wrap(baos.toByteArray());
        infoBuffer.rewind();
        ByteBuffer infoHeaderBuffer = ByteBuffer.allocate(IffHeaderChunk.SIGNATURE_LENGTH);
        infoHeaderBuffer.put(WavChunkType.INFO.getCode().getBytes(StandardCharsets.US_ASCII));
        infoHeaderBuffer.flip();
        ByteBuffer listInfoBuffer = ByteBuffer.allocateDirect(infoHeaderBuffer.limit() + infoBuffer.limit());
        listInfoBuffer.put(infoHeaderBuffer);
        listInfoBuffer.put(infoBuffer);
        listInfoBuffer.flip();
        return listInfoBuffer;
    }

    public ByteBuffer convertID3Chunk(WavTag tag, WavTag existingTag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long existingTagSize = existingTag.getSizeOfID3TagOnly();
            if (existingTagSize > 0L && (existingTagSize & 1L) != 0L) {
                ++existingTagSize;
            }
            if (tag.getID3Tag() == null) {
                tag.setID3Tag(WavTag.createDefaultID3Tag());
            }
            tag.getID3Tag().write(baos, (int)existingTagSize);
            if ((baos.toByteArray().length & 1) != 0) {
                int newSize = baos.toByteArray().length + 1;
                baos = new ByteArrayOutputStream();
                tag.getID3Tag().write(baos, newSize);
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private BothTagsFileStructure checkExistingLocations(WavTag wavTag, FileChannel fc) throws IOException {
        BothTagsFileStructure fs = new BothTagsFileStructure();
        if (wavTag.getInfoTag().getStartLocationInFile() < wavTag.getID3Tag().getStartLocationInFile()) {
            fs.isInfoTagFirst = true;
            if (Math.abs(wavTag.getInfoTag().getEndLocationInFile() - wavTag.getStartLocationInFileOfId3Chunk()) <= 1L) {
                fs.isContiguous = true;
                if (this.isID3TagAtEndOfFileAllowingForPaddingByte(wavTag, fc)) {
                    fs.isAtEnd = true;
                }
            }
        } else if (Math.abs(wavTag.getID3Tag().getEndLocationInFile() - wavTag.getInfoTag().getStartLocationInFile()) <= 1L) {
            fs.isContiguous = true;
            if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(wavTag, fc)) {
                fs.isAtEnd = true;
            }
        }
        return fs;
    }

    private void writeInfoChunk(FileChannel fc, WavInfoTag existingInfoTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        long newInfoTagSize = newTagBuffer.limit();
        if (existingInfoTag.getSizeOfTag() >= newInfoTagSize) {
            this.writeInfoDataToFile(fc, newTagBuffer, existingInfoTag.getSizeOfTag());
            if (existingInfoTag.getSizeOfTag() > newInfoTagSize) {
                this.writePaddingToFile(fc, (int)(existingInfoTag.getSizeOfTag() - newInfoTagSize));
            }
        } else {
            this.writeInfoDataToFile(fc, newTagBuffer, newInfoTagSize);
        }
    }

    private void writeExtraByteIfChunkOddSize(FileChannel fc, long size) throws IOException {
        if (Utils.isOddLength(size)) {
            this.writePaddingToFile(fc, 1);
        }
    }

    private boolean isID3TagAtEndOfFileAllowingForPaddingByte(WavTag existingTag, FileChannel fc) throws IOException {
        return existingTag.getID3Tag().getEndLocationInFile().longValue() == fc.size() || (existingTag.getID3Tag().getEndLocationInFile() & 1L) != 0L && existingTag.getID3Tag().getEndLocationInFile() + 1L == fc.size();
    }

    private boolean isInfoTagAtEndOfFileAllowingForPaddingByte(WavTag existingTag, FileChannel fc) throws IOException {
        return existingTag.getInfoTag().getEndLocationInFile().longValue() == fc.size() || (existingTag.getInfoTag().getEndLocationInFile() & 1L) != 0L && existingTag.getInfoTag().getEndLocationInFile() + 1L == fc.size();
    }

    private void saveBoth(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
        long newInfoTagSize = infoTagBuffer.limit();
        ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag, existingTag);
        if (WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) {
            this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
            if (TagOptionSingleton.getInstance().getWavSaveOrder() == WavSaveOrder.INFO_THEN_ID3) {
                this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
                this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
            } else {
                this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
                this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
            }
        } else if (!existingTag.isIncorrectlyAlignedTag()) {
            if (existingTag.getMetadataChunkSummaryList().size() > 0) {
                ListIterator<ChunkSummary> li = existingTag.getMetadataChunkSummaryList().listIterator(existingTag.getMetadataChunkSummaryList().size());
                while (li.hasPrevious()) {
                    ChunkSummary next = li.previous();
                    if (Utils.isOddLength(next.getEndLocation())) {
                        this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() + 1L - next.getFileStartLocation()));
                        continue;
                    }
                    this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() - next.getFileStartLocation()));
                }
            }
            if (TagOptionSingleton.getInstance().getWavSaveOrder() == WavSaveOrder.INFO_THEN_ID3) {
                this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
                this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
            } else {
                this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
                this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
            }
        } else {
            throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
        }
    }

    public void removeAllMetadata(FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (existingTag.getStartLocationInFileOfId3Chunk() > existingTag.getInfoTag().getStartLocationInFile()) {
            ChunkHeader id3ChunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
            this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
            ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
            this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
        } else if (existingTag.getInfoTag().getStartLocationInFile() > existingTag.getStartLocationInFileOfId3Chunk()) {
            ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
            this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
            ChunkHeader id3ChunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
            this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
        }
    }

    public void writeBothTags(FileChannel fc, ByteBuffer infoTagBuffer, ByteBuffer id3TagBuffer) throws IOException {
        if (TagOptionSingleton.getInstance().getWavSaveOrder() == WavSaveOrder.INFO_THEN_ID3) {
            this.writeInfoDataToFile(fc, infoTagBuffer);
            this.writeId3DataToFile(fc, id3TagBuffer);
        } else {
            this.writeId3DataToFile(fc, id3TagBuffer);
            this.writeInfoDataToFile(fc, infoTagBuffer);
        }
    }

    public void replaceInfoChunkAtFileEnd(FileChannel fc, WavTag existingTag, ByteBuffer infoTagBuffer) throws CannotWriteException, IOException {
        ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
        if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
            this.writeInfoChunk(fc, existingTag.getInfoTag(), infoTagBuffer);
        } else {
            this.deleteInfoChunkAndCreateNewOneAtFileEnd(fc, existingTag, infoChunkHeader, infoTagBuffer);
        }
    }

    public void deleteOrTruncateId3Tag(FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
            fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
        } else {
            ChunkHeader id3ChunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
            this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
        }
    }

    public void deleteInfoChunkAndCreateNewOneAtFileEnd(FileChannel fc, WavTag existingTag, ChunkHeader id3ChunkHeader, ByteBuffer infoTagBuffer) throws IOException {
        this.deleteInfoTagChunk(fc, existingTag, id3ChunkHeader);
        fc.position(fc.size());
        this.writeInfoDataToFile(fc, infoTagBuffer);
    }

    public void saveInfo(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
        long newInfoTagSize = infoTagBuffer.limit();
        if (WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) {
            this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
            this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
        } else if (!existingTag.isIncorrectlyAlignedTag()) {
            if (existingTag.getMetadataChunkSummaryList().size() > 0) {
                ListIterator<ChunkSummary> li = existingTag.getMetadataChunkSummaryList().listIterator(existingTag.getMetadataChunkSummaryList().size());
                while (li.hasPrevious()) {
                    ChunkSummary next = li.previous();
                    if (Utils.isOddLength(next.getEndLocation())) {
                        this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() + 1L - next.getFileStartLocation()));
                        continue;
                    }
                    this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() - next.getFileStartLocation()));
                }
            }
            this.writeInfoChunkAtFileEnd(fc, infoTagBuffer, newInfoTagSize);
        } else {
            throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
        }
    }

    private void writeInfoChunkAtFileEnd(FileChannel fc, ByteBuffer infoTagBuffer, long newInfoTagSize) throws IOException {
        fc.position(fc.size());
        this.writeInfoDataToFile(fc, infoTagBuffer, newInfoTagSize);
    }

    private void saveId3(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag, existingTag);
        if (WavChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) {
            this.deleteExistingMetadataTagsToEndOfFile(fc, existingTag);
            this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
        } else if (!existingTag.isIncorrectlyAlignedTag()) {
            if (existingTag.getMetadataChunkSummaryList().size() > 0) {
                ListIterator<ChunkSummary> li = existingTag.getMetadataChunkSummaryList().listIterator(existingTag.getMetadataChunkSummaryList().size());
                while (li.hasPrevious()) {
                    ChunkSummary next = li.previous();
                    if (Utils.isOddLength(next.getEndLocation())) {
                        this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() + 1L - next.getFileStartLocation()));
                        continue;
                    }
                    this.deleteTagChunk(fc, (int)next.getEndLocation(), (int)(next.getEndLocation() - next.getFileStartLocation()));
                }
            }
            this.writeId3ChunkAtFileEnd(fc, id3TagBuffer);
        } else {
            throw new CannotWriteException(this.loggingName + " Metadata tags are corrupted and not at end of file so cannot be fixed");
        }
    }

    public void replaceId3ChunkAtFileEnd(FileChannel fc, WavTag existingTag, ByteBuffer id3TagBuffer) throws CannotWriteException, IOException {
        ChunkHeader id3ChunkHeader = this.seekToStartOfId3MetadataForChunkSummaryHeader(fc, existingTag);
        if (this.isID3TagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
            this.writeId3DataToFile(fc, id3TagBuffer);
        } else {
            this.deleteId3ChunkAndCreateNewOneAtFileEnd(fc, existingTag, id3ChunkHeader, id3TagBuffer);
        }
    }

    public void deleteOrTruncateInfoTag(FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(fc, existingTag);
        if (this.isInfoTagAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
            fc.truncate(existingTag.getInfoTag().getStartLocationInFile());
        } else {
            this.deleteInfoTagChunk(fc, existingTag, infoChunkHeader);
        }
    }

    private void writeId3ChunkAtFileEnd(FileChannel fc, ByteBuffer id3TagBuffer) throws IOException {
        fc.position(fc.size());
        this.writeId3DataToFile(fc, id3TagBuffer);
    }

    private void deleteId3ChunkAndCreateNewOneAtFileEnd(FileChannel fc, WavTag existingTag, ChunkHeader id3ChunkHeader, ByteBuffer id3TagBuffer) throws IOException {
        this.deleteId3TagChunk(fc, existingTag, id3ChunkHeader);
        fc.position(fc.size());
        this.writeId3DataToFile(fc, id3TagBuffer);
    }

    private void saveActive(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            this.saveInfo(wavTag, fc, existingTag);
        } else {
            this.saveId3(wavTag, fc, existingTag);
        }
    }

    private void saveActiveExisting(WavTag wavTag, FileChannel fc, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            if (existingTag.isExistingId3Tag()) {
                this.saveBoth(wavTag, fc, existingTag);
            } else {
                this.saveActive(wavTag, fc, existingTag);
            }
        } else if (existingTag.isExistingInfoTag()) {
            this.saveBoth(wavTag, fc, existingTag);
        } else {
            this.saveActive(wavTag, fc, existingTag);
        }
    }

    private void deleteExistingMetadataTagsToEndOfFile(FileChannel fc, WavTag existingTag) throws IOException {
        ChunkSummary precedingChunk = WavChunkSummary.getChunkBeforeFirstMetadataTag(existingTag);
        if (!Utils.isOddLength(precedingChunk.getEndLocation())) {
            fc.truncate(precedingChunk.getEndLocation());
        } else {
            fc.truncate(precedingChunk.getEndLocation() + 1L);
        }
    }

    class BothTagsFileStructure {
        boolean isInfoTagFirst = false;
        boolean isContiguous = false;
        boolean isAtEnd = false;

        BothTagsFileStructure() {
        }

        public String toString() {
            return "IsInfoTagFirst:" + this.isInfoTagFirst + ":isContiguous:" + this.isContiguous + ":isAtEnd:" + this.isAtEnd;
        }
    }

    class InfoFieldWriterOrderComparator
    implements Comparator<TagField> {
        InfoFieldWriterOrderComparator() {
        }

        @Override
        public int compare(TagField field1, TagField field2) {
            WavInfoIdentifier code1 = WavInfoIdentifier.getByFieldKey(FieldKey.valueOf(field1.getId()));
            WavInfoIdentifier code2 = WavInfoIdentifier.getByFieldKey(FieldKey.valueOf(field2.getId()));
            int order1 = Integer.MAX_VALUE;
            int order2 = Integer.MAX_VALUE;
            if (code1 != null) {
                order1 = code1.getPreferredWriteOrder();
            }
            if (code2 != null) {
                order2 = code2.getPreferredWriteOrder();
            }
            return order1 - order2;
        }
    }
}

