/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.chunk.WavInfoIdentifier;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavInfoChunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.WavInfoChunk");
    private WavInfoTag wavInfoTag;
    private String loggingName;

    public WavInfoChunk(WavTag tag, String loggingName) {
        this.loggingName = loggingName;
        this.wavInfoTag = new WavInfoTag();
        tag.setInfoTag(this.wavInfoTag);
    }

    public boolean readChunks(ByteBuffer chunkData) {
        while (chunkData.remaining() >= IffHeaderChunk.TYPE_LENGTH) {
            String id = Utils.readFourBytesAsChars(chunkData);
            if (id.trim().isEmpty()) {
                return true;
            }
            int size = chunkData.getInt();
            if (!(Character.isAlphabetic(id.charAt(0)) && Character.isAlphabetic(id.charAt(1)) && Character.isAlphabetic(id.charAt(2)) && Character.isAlphabetic(id.charAt(3)))) {
                return false;
            }
            String value = null;
            try {
                value = Utils.getString(chunkData, 0, size, StandardCharsets.UTF_8);
            }
            catch (BufferUnderflowException bue) {
                return false;
            }
            WavInfoIdentifier wii = WavInfoIdentifier.getByCode(id);
            if (wii != null && wii.getFieldKey() != null) {
                try {
                    this.wavInfoTag.setField(wii.getFieldKey(), value);
                }
                catch (FieldDataInvalidException fieldDataInvalidException) {}
            } else if (id != null && !id.trim().isEmpty()) {
                this.wavInfoTag.addUnRecognizedField(id, value);
            }
            if (!Utils.isOddLength(size) || !chunkData.hasRemaining()) continue;
            chunkData.get();
        }
        return true;
    }
}

