/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.frontend.gui.screens;

import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.builder.AbstractBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.playlist.Playlist;
import ru.kelcuprum.waterplayer.frontend.gui.LyricsHelper;
import ru.kelcuprum.waterplayer.frontend.gui.SafeLyrics;
import ru.kelcuprum.waterplayer.frontend.gui.components.LyricsBox;
import ru.kelcuprum.waterplayer.frontend.localization.MusicHelper;

public class TrackScreen
extends class_437 {
    protected final class_437 parent;
    protected final AudioTrack track;
    protected final boolean isFile;
    protected AudioLyrics lyrics;
    protected boolean lyricsEnable = false;
    protected boolean showLyrics = false;
    protected boolean showPlaylist = false;
    Button lyricsButton;
    Button backButton;
    LyricsBox lyricsBox;
    int x = 10;
    int iconSize = 47;
    int lyricsSize = 200;
    int componentSize = 310;
    private ConfigureScrolWidget scroller_panel;
    private TextBox titleW;
    private Button back;
    private List<class_339> playlists;

    public TrackScreen(class_437 parent, AudioTrack track) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.track = track;
        if (this.track == null) {
            this.isFile = false;
            this.method_25419();
            return;
        }
        this.isFile = new File(track.getInfo().uri).exists();
        this.lyrics = LyricsHelper.getLyrics(track);
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22793);
        int iconSize = 5 + (9 + 5) * 3;
        int pageSize = this.field_22789;
        this.lyricsSize = Math.min(this.field_22789 / 2, 200);
        if (this.showLyrics || this.showPlaylist) {
            pageSize -= this.lyricsSize;
        }
        this.componentSize = Math.min(310, pageSize - 10);
        this.x = (pageSize - this.componentSize) / 2;
        if (this.showLyrics || this.showPlaylist) {
            this.x += this.lyricsSize;
        }
        if (this.showPlaylist) {
            this.initPlaylist();
        } else if (this.showLyrics) {
            this.method_37063((class_364)new TextBuilder(Localization.getText((String)"waterplayer.track.lyrics.title")).setPosition(5, 5).setSize(this.lyricsSize - 10, 20).build());
            this.lyricsBox = ((LyricsBox)this.method_37063((class_364)new LyricsBox(10, 35, this.lyricsSize - 20, this.field_22790 - (this.lyricsEnable ? 95 : 70), (class_2561)class_2561.method_43473()))).setLyrics((class_2561)class_2561.method_43470((String)(this.lyricsEnable ? (this.lyrics.getText() != null ? this.lyrics.getText().replace("\r", "") : "404: Not found") : "404: Not found")));
            if (this.lyricsEnable) {
                this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.lyrics.copy"), onPress -> {
                    AlinLib.MINECRAFT.field_1774.method_1455(this.lyrics.getText() == null ? "" : this.lyrics.getText());
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43471((String)"waterplayer.track.lyrics.copy.toast")).buildAndShow();
                }).setPosition(5, this.field_22790 - 25).setSize(this.lyricsSize - 10, 20).build());
            }
            String id = WaterPlayer.parseFileSystem(this.track.getSourceManager().getSourceName() + "_" + this.track.getIdentifier());
            this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.lyrics.create_srt"), onPress -> {
                try {
                    class_156.method_668().method_672(new File(LyricsHelper.saveSRT(this.track, this.lyricsEnable ? (this.lyrics.getText() != null ? this.lyrics.getText().replace("\r", "") : "Example text") : "Example text")));
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43471((String)"waterplayer.track.lyrics.created_srt")).buildAndShow();
                }
                catch (Exception e) {
                    WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43470((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()))).setType(ToastBuilder.Type.ERROR).setIcon(Icons.DONT).buildAndShow();
                }
            }).setPosition(5, this.field_22790 - (this.lyricsEnable ? 50 : 25)).setSize(this.lyricsSize - 10, 20).build());
        }
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)(this.isFile ? "waterplayer.track.open_file" : "waterplayer.track.open_link")), huy -> {
            if (this.isFile) {
                class_156.method_668().method_672(new File(this.track.getInfo().uri));
            } else {
                class_156.method_668().method_670(this.track.getInfo().uri);
            }
        }).setWidth(this.componentSize / 2 - 2).setPosition(this.x, this.field_22790 / 2 - 10).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.copy_link"), huy -> AlinLib.MINECRAFT.field_1774.method_1455(this.track.getInfo().uri)).setWidth(this.componentSize / 2 - 2).setPosition(this.x + this.componentSize / 2 + 2, this.field_22790 / 2 - 10).build());
        int y = this.field_22790 / 2 + 15;
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.play"), huy -> {
            WaterPlayer.player.loadMusic(this.track.getInfo().uri, false);
            this.method_25419();
        }).setWidth(this.componentSize / 2 - 2).setPosition(this.x, y).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.add_playlist"), huy -> {
            this.showPlaylist = true;
            this.method_41843();
        }).setWidth(this.componentSize / 2 - 2).setPosition(this.x + this.componentSize / 2 + 2, y).build());
        y += 25;
        if (!this.track.getInfo().isStream) {
            this.lyricsButton = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)(this.showLyrics ? "waterplayer.track.hide_lyrics" : "waterplayer.track.lyrics")), huy -> {
                this.showLyrics = !this.showLyrics;
                this.method_41843();
            }).setWidth(this.componentSize / 2 - 2).setPosition(this.x, y).build());
        }
        this.backButton = (Button)this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, huy -> this.method_25419()).setWidth(this.track.getInfo().isStream ? this.componentSize : this.componentSize / 2 - 2).setPosition(this.track.getInfo().isStream ? this.x : this.x + this.componentSize / 2 + 2, y).build());
        y += 25;
        if (MusicHelper.isFile(this.track)) {
            ((class_339)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.editor"), huy -> WaterPlayer.openTrackEditor(new File(this.track.getInfo().uri))).setWidth(this.componentSize).build())).method_48229(this.x, y);
        }
        int textY = this.field_22790 / 2 - 15 - iconSize + 5;
        AbstractBuilder abstractBuilder = new TextBuilder((class_2561)class_2561.method_43470((String)MusicHelper.getTitle(this.track))).setAlign(TextBuilder.ALIGN.LEFT).setPosition(this.x + iconSize + 5, textY);
        Objects.requireNonNull(this.field_22793);
        this.method_37063((class_364)abstractBuilder.setSize(this.componentSize - (iconSize + 10), 9).build());
        Objects.requireNonNull(this.field_22793);
        textY += 9 + 5;
        if (!MusicHelper.getAuthor(this.track).isBlank()) {
            AbstractBuilder abstractBuilder2 = new TextBuilder((class_2561)class_2561.method_43469((String)"waterplayer.track.author", (Object[])new Object[]{MusicHelper.getAuthor(this.track)})).setAlign(TextBuilder.ALIGN.LEFT).setPosition(this.x + iconSize + 5, textY);
            Objects.requireNonNull(this.field_22793);
            this.method_37063((class_364)abstractBuilder2.setSize(this.componentSize - (iconSize + 10), 9).build());
            Objects.requireNonNull(this.field_22793);
            textY += 9 + 5;
        }
        AbstractBuilder abstractBuilder3 = new TextBuilder((class_2561)class_2561.method_43469((String)"waterplayer.track.service", (Object[])new Object[]{MusicHelper.getServiceName(MusicHelper.getService(this.track))})).setAlign(TextBuilder.ALIGN.LEFT).setPosition(this.x + iconSize + 5, textY);
        Objects.requireNonNull(this.field_22793);
        this.method_37063((class_364)abstractBuilder3.setSize(this.componentSize - (iconSize + 10), 9).build());
    }

    public void initPlaylist() {
        this.playlists = new ArrayList<class_339>();
        this.titleW = (TextBox)this.method_37063((class_364)new TextBuilder(Localization.getText((String)"waterplayer.track.playlists")).setPosition(5, 5).setSize(this.lyricsSize - 10, 30).build());
        this.back = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"waterplayer.track.playlists.hide"), onPress -> {
            this.showPlaylist = false;
            this.method_41843();
        }).setPosition(5, this.field_22790 - 25).setSize(this.lyricsSize - 10, 20).build());
        File playlistsFolder = AlinLib.MINECRAFT.field_1697.toPath().resolve(WaterPlayer.getPath() + "/playlists").toFile();
        int yP = 40;
        if (playlistsFolder.exists() && playlistsFolder.isDirectory()) {
            for (File playlist : Objects.requireNonNull(playlistsFolder.listFiles())) {
                if (!playlist.isFile() || !playlist.getName().endsWith(".json")) continue;
                try {
                    Playlist playlistObject = new Playlist(playlist.toPath());
                    this.playlists.add(new ButtonBuilder((class_2561)class_2561.method_43469((String)"waterplayer.playlists.value", (Object[])new Object[]{playlistObject.title, playlistObject.author}), s -> {
                        playlistObject.addUrl(this.track.getInfo().uri);
                        WaterPlayer.getToast().setMessage((class_2561)class_2561.method_43469((String)"waterplayer.track.playlists.added", (Object[])new Object[]{playlistObject.title})).buildAndShow();
                        this.method_25419();
                    }).setSize(this.lyricsSize - 10, 20).setPosition(5, yP).build());
                    yP += 25;
                }
                catch (Exception e) {
                    WaterPlayer.log(e.getLocalizedMessage(), Level.ERROR);
                }
            }
        }
        this.addRenderableWidgets(this.playlists);
        this.scroller_panel = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(0, 0, 4, this.field_22790, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 5;
            this.titleW.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
            scroller.innerHeight += this.titleW.method_25364() + 5;
            for (class_339 widget : this.playlists) {
                if (widget.field_22764) {
                    widget.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight += widget.method_25364() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
            if (scroller.innerHeight >= this.field_22790 - 25) {
                this.back.method_46419((int)((double)scroller.innerHeight - scroller.scrollAmount()));
                scroller.innerHeight += 20;
            } else {
                this.back.method_46419(this.field_22790 - 25);
            }
        }));
    }

    protected void addRenderableWidgets(@NotNull List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.method_37063((class_364)widget);
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_25290(class_1921::method_62277, MusicHelper.getThumbnail(this.track), this.x, this.field_22790 / 2 - 15 - this.iconSize, 0.0f, 0.0f, this.iconSize, this.iconSize, this.iconSize, this.iconSize);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        if (this.showLyrics || this.showPlaylist) {
            GuiUtils.getSelected().renderTitleBackground(guiGraphics, 5, 5, this.lyricsSize - 5, 25);
            GuiUtils.getSelected().renderBackground(guiGraphics, 5, 30, this.lyricsSize - 5, this.field_22790 - (this.lyricsEnable ? 55 : 30));
        }
    }

    public void method_25393() {
        if (this.showPlaylist && this.scroller_panel != null) {
            this.scroller_panel.onScroll.accept(this.scroller_panel);
        }
        this.lyrics = LyricsHelper.getLyrics(this.track);
        this.lyricsEnable = this.lyrics != null && this.lyrics.getText() != null && !(this.lyrics instanceof SafeLyrics);
        super.method_25393();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (this.showPlaylist) {
            if (mouseX <= 200.0) {
                scr = this.scroller_panel.method_25401(mouseX, mouseY, scrollX, scrollY);
            }
        } else if (this.showLyrics && mouseX >= 5.0 && mouseX <= 195.0 && mouseY >= 40.0 && mouseY <= (double)(this.field_22790 - 30)) {
            scr = this.lyricsBox.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

