/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.distortion;

import com.github.natanbc.lavadsp.Converter;

public class DistortionConverter
implements Converter {
    public static final int SIN = 1;
    public static final int COS = 2;
    public static final int TAN = 4;
    public static final int ALL_FUNCTIONS = 7;
    private int enabled = 7;
    private float sinOffset = 0.0f;
    private float sinScale = 1.0f;
    private float cosOffset = 0.0f;
    private float cosScale = 1.0f;
    private float tanOffset = 0.0f;
    private float tanScale = 1.0f;
    private float offset = 0.0f;
    private float scale = 1.0f;

    public void setSinOffset(float sinOffset) {
        this.sinOffset = sinOffset;
    }

    public void setSinScale(float sinScale) {
        this.sinScale = sinScale;
    }

    public void setCosOffset(float cosOffset) {
        this.cosOffset = cosOffset;
    }

    public void setCosScale(float cosScale) {
        this.cosScale = cosScale;
    }

    public void setTanOffset(float tanOffset) {
        this.tanOffset = tanOffset;
    }

    public void setTanScale(float tanScale) {
        this.tanScale = tanScale;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void enable(int functions) {
        this.enabled |= functions;
    }

    public void disable(int functions) {
        this.enabled &= ~functions;
    }

    @Override
    public void process(float[] input, int inputOffset, float[] output, int outputOffset, int samples) {
        boolean useSin = (this.enabled & 1) != 0;
        boolean useCos = (this.enabled & 2) != 0;
        boolean useTan = (this.enabled & 4) != 0;
        for (int i = 0; i < samples; ++i) {
            float sample = input[inputOffset + i];
            float sampleSin = this.sinOffset + (float)Math.sin(sample * this.sinScale);
            float sampleCos = this.cosOffset + (float)Math.cos(sample * this.cosScale);
            float sampleTan = this.tanOffset + (float)Math.tan(sample * this.tanScale);
            float result = this.offset + this.scale * (useSin ? sampleSin : 1.0f) * (useCos ? sampleCos : 1.0f) * (useTan ? sampleTan : 1.0f);
            output[outputOffset + i] = Math.max(-1.0f, Math.min(1.0f, result));
        }
    }
}

