/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.CPUInfo;
import com.github.natanbc.nativeloader.system.CacheInfo;
import com.github.natanbc.nativeloader.system.DefaultArchitectureTypes;
import com.github.natanbc.nativeloader.system.FeatureFormatter;
import com.github.natanbc.nativeloader.system.X86Microarchitecture;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class X86CPUInfo
extends CPUInfo {
    private final X86Microarchitecture microarchitecture;
    private final int family;
    private final int model;
    private final int stepping;
    private final String vendor;
    private final String brandString;

    public X86CPUInfo(boolean is64Bit, @Nonnull Map<String, Boolean> features, @Nonnull CacheInfo cacheInfo, @Nonnull X86Microarchitecture microarchitecture, int family, int model, int stepping, @Nonnull String vendor, @Nonnull String brandString) {
        super(is64Bit ? DefaultArchitectureTypes.X86_64 : DefaultArchitectureTypes.X86_32, features, cacheInfo);
        this.microarchitecture = microarchitecture;
        this.family = family;
        this.model = model;
        this.stepping = stepping;
        this.vendor = vendor;
        this.brandString = brandString;
    }

    @Nonnull
    @CheckReturnValue
    public X86Microarchitecture microarchitecture() {
        return this.microarchitecture;
    }

    @CheckReturnValue
    public int family() {
        return this.family;
    }

    @CheckReturnValue
    public int model() {
        return this.model;
    }

    @CheckReturnValue
    public int stepping() {
        return this.stepping;
    }

    @Nonnull
    @CheckReturnValue
    public String vendor() {
        return this.vendor;
    }

    @Nonnull
    @CheckReturnValue
    public String brandString() {
        return this.brandString;
    }

    public String toString() {
        return "X86CPU{features = " + FeatureFormatter.formatFeatures(this) + ", microarchitecture = " + this.microarchitecture() + ", family = " + this.family() + ", model = " + this.model() + ", stepping = " + this.stepping() + ", vendor = " + this.vendor() + ", brandString = " + this.brandString() + ", cache = " + this.cacheInfo() + "}";
    }
}

