/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.qobuz;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.qobuz.QobuzAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import java.security.MessageDigest;
import org.apache.http.client.utils.URIBuilder;

public class QobuzAudioTrack
extends ExtendedAudioTrack {
    private final QobuzAudioSourceManager sourceManager;

    public QobuzAudioTrack(AudioTrackInfo trackInfo, QobuzAudioSourceManager sourceManager) {
        this(trackInfo, null, null, null, null, sourceManager);
    }

    public QobuzAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, QobuzAudioSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, null, false);
        this.sourceManager = sourceManager;
    }

    private static String getMd5Hash(String input) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(input.getBytes());
        StringBuilder hexString = new StringBuilder();
        for (byte b : messageDigest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private URI getTrackMediaURI() throws Exception {
        long unixTs = System.currentTimeMillis() / 1000L;
        String rSig = String.format("trackgetFileUrlformat_id%dintentstreamtrack_id%d%d%s", 5, Integer.parseInt(this.getIdentifier()), unixTs, this.sourceManager.getAppSecret());
        String rSigHashed = QobuzAudioTrack.getMd5Hash(rSig);
        URIBuilder builder = new URIBuilder("https://www.qobuz.com/api.json/0.2/track/getFileUrl");
        builder.addParameter("request_ts", String.valueOf(unixTs));
        builder.addParameter("request_sig", rSigHashed);
        builder.addParameter("track_id", this.getIdentifier());
        builder.addParameter("format_id", "5");
        builder.addParameter("intent", "stream");
        JsonBrowser json2 = this.sourceManager.getJson(builder.toString());
        if (json2 == null || json2.get("url").isNull()) {
            throw new IllegalStateException("Failed to get track media URI");
        }
        if (!json2.get("sample").isNull() && json2.get("sample").asBoolean(true)) {
            throw new IllegalStateException("Premium account required to play the whole track");
        }
        return new URI(json2.get("url").text());
    }

    @Override
    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
             PersistentHttpStream stream = new PersistentHttpStream(httpInterface, this.getTrackMediaURI(), null);){
            this.processDelegate(new Mp3AudioTrack(this.trackInfo, stream), executor);
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new QobuzAudioTrack(this.trackInfo, this.albumName, this.albumUrl, this.artistUrl, this.artistArtworkUrl, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

