/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.ytdlp;

import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.ytdlp.YtdlpAudioPlaylist;
import com.github.topi314.lavasrc.ytdlp.YtdlpAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YtdlpAudioSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable {
    public static final String SEARCH_PREFIX = "ytsearch:";
    private static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.|m\\.|music\\.|)youtube\\.com/.*");
    private static final Pattern SHORT_URL_PATTERN = Pattern.compile("https?://(?:www\\.|)youtu\\.be/.*");
    private static final Logger log = LoggerFactory.getLogger(YtdlpAudioSourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager;
    private String path;
    private int searchLimit;
    private String[] customLoadArgs;
    private String[] customPlaybackArgs;

    public YtdlpAudioSourceManager() {
        this("yt-dlp", 0, null, null);
    }

    public YtdlpAudioSourceManager(String path) {
        this(path, 0, null, null);
    }

    public YtdlpAudioSourceManager(String path, int searchLimit, String[] customLoadArgs, String[] customPlaybackArgs) {
        this.path = path;
        this.searchLimit = searchLimit == 0 ? 10 : searchLimit;
        this.customLoadArgs = customLoadArgs == null || customLoadArgs.length == 0 ? new String[]{"-q", "--no-warnings", "--flat-playlist", "--skip-download", "-J"} : customLoadArgs;
        this.customPlaybackArgs = customPlaybackArgs == null || customPlaybackArgs.length == 0 ? new String[]{"-q", "--no-warnings", "-f", "bestaudio", "-J"} : customPlaybackArgs;
        this.httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    public String[] getCustomLoadArgs() {
        return this.customLoadArgs;
    }

    public void setCustomLoadArgs(String[] customLoadArgs) {
        this.customLoadArgs = customLoadArgs;
    }

    public String[] getCustomPlaybackArgs() {
        return this.customPlaybackArgs;
    }

    public void setCustomPlaybackArgs(String[] customPlaybackArgs) {
        this.customPlaybackArgs = customPlaybackArgs;
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "youtube";
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new YtdlpAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getItem(String.format("ytsearch%d:%s", this.searchLimit, identifier.substring(SEARCH_PREFIX.length())));
            }
            if (URL_PATTERN.matcher(identifier).matches() || SHORT_URL_PATTERN.matcher(identifier).matches()) {
                return this.getItem(identifier);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public AudioItem parsePlaylist(JsonBrowser json2) {
        String title = json2.get("title").text();
        List<JsonBrowser> entries = json2.get("entries").values();
        if (entries.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser entry : entries) {
            String ieKey = entry.get("ie_key").text();
            if (ieKey == null || !ieKey.equalsIgnoreCase("youtube")) continue;
            entry.put("extractor", json2.get("extractor").text());
            AudioTrack track = this.parseVideo(entry);
            if (track == null) continue;
            tracks.add(track);
        }
        if (json2.get("extractor").text().equals("youtube:search")) {
            return new BasicAudioPlaylist("Youtube Search: " + title, tracks, null, true);
        }
        String url = json2.get("webpage_url").text();
        String thumbnailUrl = json2.get("thumbnails").index(0).get("url").text();
        return new YtdlpAudioPlaylist(title, tracks, ExtendedAudioPlaylist.Type.PLAYLIST, url, thumbnailUrl, null, null);
    }

    public AudioTrack parseVideo(JsonBrowser json2) {
        String title = json2.get("title").text();
        String author = json2.get("uploader").text();
        String identifier = json2.get("id").text();
        String thumbnailUrl = json2.get("thumbnail").text();
        long duration = json2.get("duration").asLong(0L) * 1000L;
        boolean isLive = json2.get("is_live").asBoolean(false);
        String url = json2.get("url").text();
        return new YtdlpAudioTrack(new AudioTrackInfo(title, author, duration, identifier, isLive, url, thumbnailUrl, null), null, null, null, null, null, false, this);
    }

    public AudioItem getItem(String identifier) throws IOException {
        String type;
        ArrayList<String> args2 = new ArrayList<String>(List.of(this.customLoadArgs));
        args2.add(identifier);
        Process process = this.getProcess(args2);
        JsonBrowser json2 = this.getProcessJsonOutput(process);
        switch (type = json2.get("_type").text()) {
            case "playlist": {
                return this.parsePlaylist(json2);
            }
            case "video": {
                json2.put("url", json2.get("webpage_url").text());
                return this.parseVideo(json2);
            }
        }
        return null;
    }

    Process getProcess(List<String> args2) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.path);
        argList.addAll(args2);
        log.debug("Starting yt-dlp with args: {}", (Object)argList);
        ProcessBuilder processBuilder = new ProcessBuilder(argList);
        processBuilder.redirectErrorStream(true);
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            log.error("Failed to start yt-dlp process", e);
            throw new RuntimeException(e);
        }
    }

    JsonBrowser getProcessJsonOutput(Process process) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(process.getInputStream());){
            int exitCode;
            String data = IOUtils.toString((InputStream)stream, StandardCharsets.UTF_8);
            log.debug("yt-dlp process output: {}", (Object)data);
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("yt-dlp process was interrupted", e);
            }
            if (exitCode != 0) {
                throw new RuntimeException("Failed to retrieve item, error: " + data);
            }
            try {
                JsonBrowser e = JsonBrowser.parse(data);
                return e;
            }
            catch (IOException e) {
                throw new IOException("Failed to parse yt-dlp output as JSON: " + data, e);
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", e);
        }
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

