/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.mp3;

import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3DecoderLibrary;
import com.sedmelluq.lava.common.natives.NativeResourceHolder;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class Mp3Decoder
extends NativeResourceHolder {
    public static final long MPEG1_SAMPLES_PER_FRAME = 1152L;
    public static final long MPEG2_SAMPLES_PER_FRAME = 576L;
    public static final int HEADER_SIZE = 4;
    private static final int ERROR_NEED_MORE = -10;
    private static final int ERROR_NEW_FORMAT = -11;
    private final Mp3DecoderLibrary library = Mp3DecoderLibrary.getInstance();
    private final long instance = this.library.create();
    private static final int[] SAMPLE_RATE_BASE = new int[]{11025, 12000, 8000};

    public Mp3Decoder() {
        if (this.instance == 0L) {
            throw new IllegalStateException("Failed to create a decoder instance");
        }
    }

    public int decode(ByteBuffer directInput, ShortBuffer directOutput) {
        this.checkNotReleased();
        if (!directInput.isDirect() || !directOutput.isDirect()) {
            throw new IllegalArgumentException("Arguments must be direct buffers.");
        }
        int result = this.library.decode(this.instance, directInput, directInput.remaining(), directOutput, directOutput.remaining() * 2);
        while (result == -11) {
            result = this.library.decode(this.instance, directInput, 0, directOutput, directOutput.remaining() * 2);
        }
        if (result == -10) {
            result = 0;
        } else if (result < 0) {
            throw new IllegalStateException("Decoding failed with error " + result);
        }
        directOutput.position(result / 2);
        directOutput.flip();
        return result / 2;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }

    private static int getFrameBitRate(byte[] buffer, int offset) {
        return MpegVersion.getVersion(buffer, offset).getBitRate(buffer, offset);
    }

    public static int getFrameSampleRate(byte[] buffer, int offset) {
        return MpegVersion.getVersion(buffer, offset).getSampleRate(buffer, offset);
    }

    public static int getFrameChannelCount(byte[] buffer, int offset) {
        return (buffer[offset + 3] & 0xC0) == 192 ? 1 : 2;
    }

    public static boolean hasFrameSync(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) == 255 && (buffer[offset + 1] & 0xE0) == 224;
    }

    public static boolean isUnsupportedVersion(byte[] buffer, int offset) {
        return (buffer[offset + 1] & 0x18) >> 3 == 1;
    }

    public static boolean isValidFrame(byte[] buffer, int offset) {
        int second = buffer[offset + 1] & 0xFF;
        int third = buffer[offset + 2] & 0xFF;
        return (second & 6) == 2 && (third & 0xF0) != 0 && (third & 0xF0) != 240 && (third & 0xC) != 12;
    }

    public static int getFrameSize(byte[] buffer, int offset) {
        return MpegVersion.getVersion(buffer, offset).getFrameSize(buffer, offset);
    }

    public static double getAverageFrameSize(byte[] buffer, int offset) {
        return MpegVersion.getVersion(buffer, offset).getAverageFrameSize(buffer, offset);
    }

    public static long getSamplesPerFrame(byte[] buffer, int offset) {
        return MpegVersion.getVersion(buffer, offset).getSamplesPerFrame();
    }

    public static int getMaximumFrameSize() {
        return MpegVersion.MAX_FRAME_SIZE;
    }

    public static enum MpegVersion {
        MPEG_1(4, 1152, new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}),
        MPEG_2(2, 576, new int[]{8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}),
        MPEG_2_5(1, MpegVersion.MPEG_2.samplesPerFrame, MpegVersion.MPEG_2.bitrateIndex);

        public static final int MAX_FRAME_SIZE;
        private final int samplesPerFrame;
        private final int frameLengthMultiplier;
        private final int[] bitrateIndex;
        private final int[] samplerateIndex;

        public static MpegVersion getVersion(byte[] buffer, int offset) {
            int index = (buffer[offset + 1] & 0x18) >> 3;
            switch (index) {
                case 0: {
                    return MPEG_2_5;
                }
                case 2: {
                    return MPEG_2;
                }
                case 3: {
                    return MPEG_1;
                }
            }
            throw new IllegalArgumentException("Invalid version");
        }

        private static int getMaxFrameSize() {
            int bitRate = MpegVersion.MPEG_1.bitrateIndex[MpegVersion.MPEG_1.bitrateIndex.length - 1] * 1000;
            int sampleRate = MpegVersion.MPEG_1.samplerateIndex[2];
            return MPEG_1.calculateFrameSize(bitRate, sampleRate, true);
        }

        private MpegVersion(int samplerateMultiplier, int samplesPerFrame, int[] bitrateIndex) {
            this.samplesPerFrame = samplesPerFrame;
            this.frameLengthMultiplier = samplesPerFrame / 8;
            this.bitrateIndex = bitrateIndex;
            this.samplerateIndex = Arrays.stream(SAMPLE_RATE_BASE).map(r -> r * samplerateMultiplier).toArray();
        }

        public int getSamplesPerFrame() {
            return this.samplesPerFrame;
        }

        public int getFrameLengthMultiplier() {
            return this.frameLengthMultiplier;
        }

        public int getBitRate(byte[] buffer, int offset) {
            int index = (buffer[offset + 2] & 0xF0) >> 4;
            if (index == 0 || index == 15) {
                throw new IllegalArgumentException("Invalid bitrate");
            }
            return this.bitrateIndex[index - 1] * 1000;
        }

        public int getSampleRate(byte[] buffer, int offset) {
            int index = (buffer[offset + 2] & 0xC) >> 2;
            if (index == 3) {
                throw new IllegalArgumentException("Invalid samplerate");
            }
            return this.samplerateIndex[index];
        }

        public int getFrameSize(byte[] buffer, int offset) {
            return this.calculateFrameSize(this.getBitRate(buffer, offset), this.getSampleRate(buffer, offset), MpegVersion.hasPadding(buffer, offset));
        }

        public double getAverageFrameSize(byte[] buffer, int offset) {
            return (double)this.getFrameLengthMultiplier() * (double)this.getBitRate(buffer, offset) / (double)this.getSampleRate(buffer, offset);
        }

        private int calculateFrameSize(int bitRate, int sampleRate, boolean hasPadding) {
            return this.getFrameLengthMultiplier() * bitRate / sampleRate + (hasPadding ? 1 : 0);
        }

        private static boolean hasPadding(byte[] buffer, int offset) {
            return (buffer[offset + 2] & 2) != 0;
        }

        static {
            MAX_FRAME_SIZE = MpegVersion.getMaxFrameSize();
        }
    }
}

