/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMixLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

public class YoutubeMixProvider
implements YoutubeMixLoader {
    @Override
    public AudioPlaylist load(HttpInterface httpInterface, String mixId, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        String playlistTitle = "YouTube mix";
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/next");
        YoutubeClientConfig clientConfig = YoutubeClientConfig.ANDROID.copy().withRootField("videoId", selectedVideoId).withRootField("playlistId", mixId).setAttribute(httpInterface);
        StringEntity payload = new StringEntity(clientConfig.toJsonString(), "UTF-8");
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "mix response");
            JsonBrowser body = JsonBrowser.parse(response.getEntity().getContent());
            JsonBrowser playlist = body.get("contents").get("singleColumnWatchNextResults").get("playlist").get("playlist");
            JsonBrowser title = playlist.get("title");
            if (!title.isNull()) {
                playlistTitle = title.text();
            }
            this.extractPlaylistTracks(playlist.get("contents"), tracks, trackFactory);
        }
        catch (IOException e) {
            throw new FriendlyException("Could not read mix page.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        if (tracks.isEmpty()) {
            throw new FriendlyException("Could not find tracks from mix.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        AudioTrack selectedTrack = this.findSelectedTrack(tracks, selectedVideoId);
        return new BasicAudioPlaylist(playlistTitle, tracks, selectedTrack, false);
    }

    private void extractPlaylistTracks(JsonBrowser browser, List<AudioTrack> tracks, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        for (JsonBrowser video : browser.values()) {
            JsonBrowser renderer = video.get("playlistPanelVideoRenderer");
            if (!renderer.get("unplayableText").isNull()) {
                return;
            }
            String title = renderer.get("title").get("runs").index(0).get("text").text();
            String author = renderer.get("longBylineText").get("runs").index(0).get("text").text();
            String durationStr = renderer.get("lengthText").get("runs").index(0).get("text").text();
            long duration = DataFormatTools.durationTextToMillis(durationStr);
            String identifier = renderer.get("videoId").text();
            String uri = "https://www.youtube.com/watch?v=" + identifier;
            AudioTrackInfo trackInfo = new AudioTrackInfo(title, author, duration, identifier, false, uri, ThumbnailTools.getYouTubeThumbnail(renderer, identifier), null);
            tracks.add(trackFactory.apply(trackInfo));
        }
    }

    private AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }
}

