/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.cipher;

import com.grack.nanojson.JsonStringWriter;
import com.grack.nanojson.JsonWriter;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.lavalink.youtube.cipher.CipherManager;
import dev.lavalink.youtube.track.format.StreamFormat;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCipherManager
implements CipherManager {
    private static final Logger log = LoggerFactory.getLogger(RemoteCipherManager.class);
    private final Object cipherLoadLock = new Object();
    private final String remoteUrl;
    @Nullable
    private final String remotePass;
    protected volatile CipherManager.CachedPlayerScript cachedPlayerScript;

    public RemoteCipherManager(String remoteUrl, @Nullable String remotePass) {
        this.remoteUrl = remoteUrl;
        this.remotePass = remotePass;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Nullable
    public String getRemotePass() {
        return this.remotePass;
    }

    @Override
    @NotNull
    public URI resolveFormatUrl(@NotNull HttpInterface httpInterface, @NotNull String playerScript, @NotNull StreamFormat format) throws IOException {
        String signature = format.getSignature();
        String nParameter = format.getNParameter();
        URI initialUrl = format.getUrl();
        URIBuilder uri = new URIBuilder(initialUrl);
        if (!DataFormatTools.isNullOrEmpty(signature)) {
            return this.getUri(httpInterface, format.getSignature(), format.getSignatureKey(), nParameter, initialUrl, playerScript);
        }
        uri.setParameter("n", this.decipherN(httpInterface, nParameter, playerScript));
        try {
            return uri.build();
        }
        catch (URISyntaxException f) {
            throw new RuntimeException(f);
        }
    }

    private CipherManager.CachedPlayerScript getPlayerScript(@NotNull HttpInterface httpInterface) {
        Object object = this.cipherLoadLock;
        synchronized (object) {
            CipherManager.CachedPlayerScript cachedPlayerScript;
            block12: {
                CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/embed/"));
                try {
                    HttpClientTools.assertSuccessWithContent(response, "fetch player script (embed)");
                    String responseText = EntityUtils.toString(response.getEntity());
                    String scriptUrl = DataFormatTools.extractBetween(responseText, "\"jsUrl\":\"", "\"");
                    if (scriptUrl == null) {
                        throw ExceptionTools.throwWithDebugInfo(log, null, "no jsUrl found", "html", responseText);
                    }
                    cachedPlayerScript = this.cachedPlayerScript = new CipherManager.CachedPlayerScript(scriptUrl);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionTools.toRuntimeException(e);
                    }
                }
                response.close();
            }
            return cachedPlayerScript;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CipherManager.CachedPlayerScript getCachedPlayerScript(@NotNull HttpInterface httpInterface) {
        if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
                    return this.getPlayerScript(httpInterface);
                }
            }
        }
        return this.cachedPlayerScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTimestamp(HttpInterface httpInterface, String sourceUrl) throws IOException {
        Object object = this.cipherLoadLock;
        synchronized (object) {
            log.debug("Timestamp from script {}", (Object)sourceUrl);
            return this.getTimestampFromScript(httpInterface, sourceUrl);
        }
    }

    private String getRemoteEndpoint(String path) {
        return this.remoteUrl.endsWith("/") ? this.remoteUrl + path : this.remoteUrl + "/" + path;
    }

    private void applyPass(HttpRequest request) {
        if (this.remotePass != null && !this.remotePass.isEmpty()) {
            request.addHeader("Authorization", this.remotePass);
        }
    }

    private String decipherN(HttpInterface httpInterface, String n, String playerScript) throws IOException {
        HttpPost request = new HttpPost(this.getRemoteEndpoint("decrypt_signature"));
        log.debug("Deciphering N param: {} with script: {}", (Object)n, (Object)playerScript);
        String requestBody = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("player_url", playerScript)).value("n_param", n)).end()).done();
        request.setEntity(new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        this.applyPass(request);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            String responseBody;
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = responseBody = entity != null ? EntityUtils.toString(entity, StandardCharsets.UTF_8) : null;
            if (statusCode >= 200 && statusCode < 300) {
                if (DataFormatTools.isNullOrEmpty(responseBody)) {
                    throw new IOException("Received empty successful response from decryption proxy.");
                }
                JsonBrowser json2 = JsonBrowser.parse(responseBody);
                String returnedN = json2.get("decrypted_n_sig").text();
                log.debug("Received decrypted N: {}", (Object)returnedN);
                if (returnedN != null && !returnedN.isEmpty()) {
                    String string2 = returnedN;
                    return string2;
                }
                String string3 = "";
                return string3;
            }
            throw new IOException("Decryption proxy request failed with status code: " + statusCode + ". Response: " + responseBody);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI getUri(HttpInterface httpInterface, String sig, String sigKey, String nParam, URI initial, String playerScript) throws IOException {
        HttpPost request = new HttpPost(this.getRemoteEndpoint("decrypt_signature"));
        log.debug("Deciphering N param: {} and Signature: {} with script: {}", nParam, sig, playerScript);
        String requestBody = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("player_url", playerScript)).value("encrypted_signature", sig)).value("n_param", nParam)).value("signature_key", sigKey)).end()).done();
        request.setEntity(new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        this.applyPass(request);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseBody = entity != null ? EntityUtils.toString(entity, StandardCharsets.UTF_8) : null;
            if (statusCode < 200) throw new IOException("Decryption proxy request failed with status code: " + statusCode + ". Response: " + responseBody + " SIG: " + sig);
            if (statusCode >= 300) throw new IOException("Decryption proxy request failed with status code: " + statusCode + ". Response: " + responseBody + " SIG: " + sig);
            if (DataFormatTools.isNullOrEmpty(responseBody)) {
                throw new IOException("Received empty successful response from decryption proxy.");
            }
            JsonBrowser json2 = JsonBrowser.parse(responseBody);
            String returnedSignature = json2.get("decrypted_signature").text();
            String returnedN = json2.get("decrypted_n_sig").text();
            log.debug("Received Decrypted N: {} and Decrypted Sig: {}", (Object)returnedN, (Object)returnedSignature);
            URIBuilder uriBuilder = new URIBuilder(initial);
            if (!DataFormatTools.isNullOrEmpty(returnedSignature)) {
                if (sigKey == null || sigKey.trim().isEmpty()) {
                    log.error("Warning: Decrypted signature received, but sigKey is null or empty. Using default 'sig'.");
                    sigKey = "sig";
                }
                uriBuilder.setParameter(sigKey.trim(), returnedSignature);
            } else if (!DataFormatTools.isNullOrEmpty(sig)) {
                log.warn("Warning: Original signature parameter 's' was present, but no decrypted signature returned from proxy.");
            }
            if (!DataFormatTools.isNullOrEmpty(returnedN)) {
                uriBuilder.setParameter("n", returnedN);
            } else if (!DataFormatTools.isNullOrEmpty(nParam)) {
                log.error("Warning: Original parameter 'n' was present, but no decrypted n-parameter returned from proxy.");
            }
            URI uRI = uriBuilder.build();
            return uRI;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getTimestampFromScript(HttpInterface httpInterface, String playerScript) throws IOException {
        HttpPost request = new HttpPost(this.getRemoteEndpoint("get_sts"));
        log.debug("Getting timestamp for script: {}", (Object)playerScript);
        String requestBody = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("player_url", playerScript)).end()).done();
        request.setEntity(new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        this.applyPass(request);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            String responseBody;
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = responseBody = entity != null ? EntityUtils.toString(entity, StandardCharsets.UTF_8) : null;
            if (statusCode >= 200 && statusCode < 300) {
                if (DataFormatTools.isNullOrEmpty(responseBody)) {
                    throw new IOException("Received empty successful response from decryption proxy.");
                }
                log.debug("Received response from proxy: {}", (Object)responseBody);
                JsonBrowser json2 = JsonBrowser.parse(responseBody);
                String string2 = json2.get("sts").text();
                return string2;
            }
            throw new IOException("Decryption proxy request failed with status code: " + statusCode + ". Response: " + responseBody);
        }
    }
}

