/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.ChunkPositionComparator;
import org.jaudiotagger.audio.asf.util.Utils;

public class ChunkContainer
extends Chunk {
    private static final Set<GUID> MULTI_CHUNKS = new HashSet<GUID>();
    private final Map<GUID, List<Chunk>> chunkTable = new Hashtable<GUID, List<Chunk>>();

    protected static boolean chunkstartsUnique(ChunkContainer container) {
        boolean result = true;
        HashSet<Long> chunkStarts = new HashSet<Long>();
        Collection<Chunk> chunks = container.getChunks();
        for (Chunk curr : chunks) {
            result &= chunkStarts.add(curr.getPosition());
        }
        return result;
    }

    public ChunkContainer(GUID chunkGUID, long pos, BigInteger length) {
        super(chunkGUID, pos, length);
    }

    public void addChunk(Chunk toAdd) {
        List<Chunk> list = this.assertChunkList(toAdd.getGuid());
        if (!list.isEmpty() && !MULTI_CHUNKS.contains(toAdd.getGuid())) {
            throw new IllegalArgumentException("The GUID of the given chunk indicates, that there is no more instance allowed.");
        }
        list.add(toAdd);
        assert (ChunkContainer.chunkstartsUnique(this)) : "Chunk has equal start position like an already inserted one.";
    }

    protected List<Chunk> assertChunkList(GUID lookFor) {
        List<Chunk> result = this.chunkTable.get(lookFor);
        if (result == null) {
            result = new ArrayList<Chunk>();
            this.chunkTable.put(lookFor, result);
        }
        return result;
    }

    public Collection<Chunk> getChunks() {
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        for (List<Chunk> curr : this.chunkTable.values()) {
            result.addAll(curr);
        }
        return result;
    }

    protected Chunk getFirst(GUID lookFor, Class<? extends Chunk> instanceOf) {
        Chunk chunk;
        Chunk result = null;
        List<Chunk> list = this.chunkTable.get(lookFor);
        if (list != null && !list.isEmpty() && instanceOf.isAssignableFrom((chunk = list.get(0)).getClass())) {
            result = chunk;
        }
        return result;
    }

    public boolean hasChunkByGUID(GUID lookFor) {
        return this.chunkTable.containsKey(lookFor);
    }

    @Override
    public String prettyPrint(String prefix) {
        return this.prettyPrint(prefix, "");
    }

    public String prettyPrint(String prefix, String containerInfo) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.append(containerInfo);
        result.append(prefix).append("  |").append(Utils.LINE_SEPARATOR);
        ArrayList<Chunk> list = new ArrayList<Chunk>(this.getChunks());
        Collections.sort(list, new ChunkPositionComparator());
        for (Chunk curr : list) {
            result.append(curr.prettyPrint(prefix + "  |"));
            result.append(prefix).append("  |").append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    static {
        MULTI_CHUNKS.add(GUID.GUID_STREAM);
    }
}

