/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dsf;

import java.util.HashMap;
import java.util.Map;

public enum DsfChunkType {
    DSD("DSD "),
    FORMAT("fmt "),
    DATA("data"),
    ID3("ID3");

    private static final Map<String, DsfChunkType> CODE_TYPE_MAP;
    private String code;

    private DsfChunkType(String code) {
        this.code = code;
    }

    public static synchronized DsfChunkType get(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (DsfChunkType type : DsfChunkType.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, DsfChunkType>();
    }
}

