/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.wav.WavSubFormat;
import org.jaudiotagger.logging.Hex;

public class WavFormatChunk
extends Chunk {
    private static final int EXTENSIBLE_DATA_SIZE = 22;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.chunk");
    private boolean isValid = false;
    private int blockAlign;
    private int channelMask;
    private WavSubFormat wsf;
    private GenericAudioHeader info;

    public WavFormatChunk(ByteBuffer chunkData, ChunkHeader hdr, GenericAudioHeader info) throws IOException {
        super(chunkData, hdr);
        this.info = info;
    }

    @Override
    public boolean readChunk() throws IOException {
        int extensibleSize;
        int subFormatCode = Utils.u(this.chunkData.getShort());
        this.wsf = WavSubFormat.getByCode(subFormatCode);
        this.info.setChannelNumber(Utils.u(this.chunkData.getShort()));
        this.info.setSamplingRate(this.chunkData.getInt());
        this.info.setByteRate(this.chunkData.getInt());
        this.info.setBitRate(this.info.getByteRate() * Utils.BITS_IN_BYTE_MULTIPLIER / Utils.KILOBYTE_MULTIPLIER);
        this.info.setVariableBitRate(false);
        this.blockAlign = Utils.u(this.chunkData.getShort());
        this.info.setBitsPerSample(Utils.u(this.chunkData.getShort()));
        if (this.wsf != null && this.wsf == WavSubFormat.FORMAT_EXTENSIBLE && (extensibleSize = Utils.u(this.chunkData.getShort())) == 22) {
            this.info.setBitsPerSample(Utils.u(this.chunkData.getShort()));
            this.channelMask = this.chunkData.getInt();
            this.wsf = WavSubFormat.getByCode(Utils.u(this.chunkData.getShort()));
        }
        if (this.wsf != null) {
            if (this.info.getBitsPerSample() > 0) {
                this.info.setEncodingType(this.wsf.getDescription() + " " + this.info.getBitsPerSample() + " bits");
            } else {
                this.info.setEncodingType(this.wsf.getDescription());
            }
        } else {
            this.info.setEncodingType("Unknown Sub Format Code:" + Hex.asHex(subFormatCode));
        }
        return true;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

