/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringNullTerminated
extends AbstractString {
    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody, String value) {
        super(identifier, frameBody, value);
    }

    public TextEncodedStringNullTerminated(TextEncodedStringNullTerminated object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TextEncodedStringNullTerminated && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (offset >= arr.length) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        Charset charset = this.getTextEncodingCharSet();
        ByteBuffer buffer = ByteBuffer.wrap(arr, offset, arr.length - offset);
        int endPosition = 0;
        boolean nullIsOneByte = StandardCharsets.ISO_8859_1 == charset || StandardCharsets.UTF_8 == charset;
        boolean isNullTerminatorFound = false;
        while (buffer.hasRemaining()) {
            byte nextByte = buffer.get();
            if (nextByte == 0) {
                if (nullIsOneByte) {
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 1;
                    isNullTerminatorFound = true;
                    break;
                }
                if (buffer.hasRemaining()) {
                    nextByte = buffer.get();
                    if (nextByte != 0) continue;
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 2;
                    isNullTerminatorFound = true;
                    break;
                }
                buffer.mark();
                buffer.reset();
                endPosition = buffer.position() - 1;
                isNullTerminatorFound = true;
                break;
            }
            if (nullIsOneByte || !buffer.hasRemaining()) continue;
            buffer.get();
        }
        if (!isNullTerminatorFound) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        int size = endPosition - offset;
        ++size;
        if (!nullIsOneByte) {
            ++size;
        }
        this.setSize(size);
        int bufferSize = endPosition - offset;
        if (logger.isLoggable(Level.FINEST)) {
            // empty if block
        }
        if (bufferSize == 0) {
            this.value = "";
        } else {
            ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, bufferSize).slice();
            CharBuffer outBuffer = CharBuffer.allocate(bufferSize);
            CharsetDecoder decoder = this.getCorrectDecoder(inBuffer);
            CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
            if (coderResult.isError()) {
                // empty if block
            }
            decoder.flush(outBuffer);
            outBuffer.flip();
            this.value = outBuffer.toString();
        }
        if (logger.isLoggable(Level.CONFIG)) {
            // empty if block
        }
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data;
        Charset charset = this.getTextEncodingCharSet();
        try {
            if (StandardCharsets.UTF_16.equals(charset)) {
                if (TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian()) {
                    CharsetEncoder encoder2 = StandardCharsets.UTF_16LE.newEncoder();
                    encoder2.onMalformedInput(CodingErrorAction.IGNORE);
                    encoder2.onUnmappableCharacter(CodingErrorAction.IGNORE);
                    ByteBuffer bb = encoder2.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    data = new byte[bb.limit()];
                    bb.get(data, 0, bb.limit());
                } else {
                    CharsetEncoder encoder3 = StandardCharsets.UTF_16BE.newEncoder();
                    encoder3.onMalformedInput(CodingErrorAction.IGNORE);
                    encoder3.onUnmappableCharacter(CodingErrorAction.IGNORE);
                    ByteBuffer bb = encoder3.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    data = new byte[bb.limit()];
                    bb.get(data, 0, bb.limit());
                }
            } else {
                CharsetEncoder encoder4 = charset.newEncoder();
                encoder4.onMalformedInput(CodingErrorAction.IGNORE);
                encoder4.onUnmappableCharacter(CodingErrorAction.IGNORE);
                ByteBuffer bb = encoder4.encode(CharBuffer.wrap((String)this.value + '\u0000'));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            }
        }
        catch (CharacterCodingException ce) {
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    @Override
    protected Charset getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        Charset charset = TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
        return charset;
    }
}

