/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.wav;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jaudiotagger.audio.generic.GenericTag;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class WavInfoTag
extends GenericTag {
    private List<TagTextField> unrecognisedFields = new ArrayList<TagTextField>();
    private Long startLocationInFile = null;
    private Long endLocationInFile = null;

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder("Wav Info Tag:\n");
        if (this.getStartLocationInFile() != null) {
            output.append("\tstartLocation:" + Hex.asDecAndHex(this.getStartLocationInFile()) + "\n");
        }
        if (this.getEndLocationInFile() != null) {
            output.append("\tendLocation:" + Hex.asDecAndHex(this.getEndLocationInFile()) + "\n");
        }
        output.append(super.toString().replace("\u0000", ""));
        if (this.unrecognisedFields.size() > 0) {
            output.append("\nUnrecognized Tags:\n");
            for (TagTextField next : this.unrecognisedFields) {
                output.append("\t" + next.getId() + ":" + next.getContent().replace("\u0000", "") + "\n");
            }
        }
        return output.toString();
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    public Long getStartLocationInFile() {
        return this.startLocationInFile;
    }

    public void setStartLocationInFile(long startLocationInFile) {
        this.startLocationInFile = startLocationInFile;
    }

    public Long getEndLocationInFile() {
        return this.endLocationInFile;
    }

    public void setEndLocationInFile(long endLocationInFile) {
        this.endLocationInFile = endLocationInFile;
    }

    public long getSizeOfTag() {
        if (this.endLocationInFile == null || this.startLocationInFile == null) {
            return 0L;
        }
        return this.endLocationInFile - this.startLocationInFile - 8L;
    }

    public void addUnRecognizedField(String code, String contents) {
        this.unrecognisedFields.add(new GenericTag.GenericTagTextField(code, contents));
    }

    public List<TagTextField> getUnrecognisedFields() {
        return this.unrecognisedFields;
    }

    static {
        supportedKeys = EnumSet.of(FieldKey.ALBUM, new FieldKey[]{FieldKey.ARTIST, FieldKey.ALBUM_ARTIST, FieldKey.TITLE, FieldKey.TRACK, FieldKey.GENRE, FieldKey.COMMENT, FieldKey.YEAR, FieldKey.RECORD_LABEL, FieldKey.ISRC, FieldKey.COMPOSER, FieldKey.LYRICIST, FieldKey.ENCODER, FieldKey.CONDUCTOR, FieldKey.RATING, FieldKey.COPYRIGHT});
    }
}

