/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend;

import com.github.natanbc.lavadsp.timescale.TimescalePcmAudioFilter;
import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavasrc.applemusic.AppleMusicSourceManager;
import com.github.topi314.lavasrc.deezer.DeezerAudioSourceManager;
import com.github.topi314.lavasrc.flowerytts.FloweryTTSSourceManager;
import com.github.topi314.lavasrc.mirror.DefaultMirroringAudioTrackResolver;
import com.github.topi314.lavasrc.spotify.SpotifySourceManager;
import com.github.topi314.lavasrc.vkmusic.VkMusicSourceManager;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicSourceManager;
import com.github.topi314.lavasrc.youtube.YoutubeSearchManager;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.Pcm16AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.local.LocalAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AllocatingAudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.MusicWithThumbnail;
import dev.lavalink.youtube.clients.WebEmbeddedWithThumbnail;
import dev.lavalink.youtube.clients.WebWithThumbnail;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.waterplayer.WaterPlayer;
import ru.kelcuprum.waterplayer.backend.MusicManager;
import ru.kelcuprum.waterplayer.backend.TrackScheduler;
import ru.kelcuprum.waterplayer.backend.output.AudioOutput;
import ru.kelcuprum.waterplayer.backend.sources.directory.DirectoriesSource;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.LyricsWithoutException;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.WaterPlayerSource;

public class MusicPlayer {
    private final AudioPlayerManager audioPlayerManager;
    private final AudioDataFormat audioDataFormat;
    private final AudioPlayer audioPlayer;
    private final AudioOutput audioOutput;
    private final TrackScheduler trackScheduler;
    private final MusicManager musicManager;
    private final LyricsManager lyricsManager;
    public final LocalAudioSourceManager localAudioSourceManager = new LocalAudioSourceManager();
    public double speed = WaterPlayer.config.getNumber("CURRENT_MUSIC_SPEED", (Number)1).doubleValue();
    public double pitch = WaterPlayer.config.getNumber("CURRENT_MUSIC_PITCH", (Number)1).doubleValue();
    public YoutubeAudioSourceManager youtube;

    public MusicPlayer() {
        this.audioPlayerManager = new DefaultAudioPlayerManager();
        this.audioDataFormat = new Pcm16AudioDataFormat(2, 48000, 960, true);
        this.audioPlayer = this.audioPlayerManager.createPlayer();
        this.audioOutput = new AudioOutput(this);
        this.lyricsManager = new LyricsManager();
        this.trackScheduler = new TrackScheduler(this.audioPlayer);
        this.musicManager = new MusicManager(this.audioPlayer, this.trackScheduler);
        this.audioPlayer.setVolume(WaterPlayer.config.getNumber("CURRENT_MUSIC_VOLUME", (Number)3).intValue());
        if (WaterPlayer.config.getBoolean("EXPERIMENT.FILTERS", false)) {
            this.audioPlayer.setFilterFactory((track, format, output) -> {
                TimescalePcmAudioFilter filter2 = new TimescalePcmAudioFilter(output, format.channelCount, format.sampleRate);
                filter2.setSpeed(this.speed);
                filter2.setPitch(this.pitch);
                return Collections.singletonList(filter2);
            });
        }
        this.audioPlayerManager.getConfiguration().setFrameBufferFactory((bufferDuration, format, stopping) -> new AllocatingAudioFrameBuffer(this, bufferDuration, format, stopping){

            @Override
            public AudioFrame provide() {
                AudioFrame frame = super.provide();
                if (frame != null && !frame.isTerminator()) {
                    TrackScheduler.trackPosition += (long)((double)frame.getFormat().frameDuration() * TrackScheduler.trackSpeed);
                }
                return frame;
            }

            @Override
            public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
                AudioFrame frame = super.provide(timeout, unit);
                if (frame != null && !frame.isTerminator()) {
                    TrackScheduler.trackPosition += (long)((double)frame.getFormat().frameDuration() * TrackScheduler.trackSpeed);
                }
                return frame;
            }
        });
        this.audioPlayerManager.setFrameBufferDuration(1000);
        this.audioPlayerManager.setPlayerCleanupThreshold(Long.MAX_VALUE);
        this.audioPlayerManager.getConfiguration().setResamplingQuality(AudioConfiguration.ResamplingQuality.HIGH);
        this.audioPlayerManager.getConfiguration().setOpusEncodingQuality(10);
        this.audioPlayerManager.getConfiguration().setOutputFormat(this.audioDataFormat);
        this.registerSources();
    }

    public void updateFilter() {
        if (!WaterPlayer.config.getBoolean("EXPERIMENT.FILTERS", false)) {
            return;
        }
        this.audioPlayer.setFilterFactory((track, format, output) -> {
            TimescalePcmAudioFilter filter2 = new TimescalePcmAudioFilter(output, format.channelCount, format.sampleRate);
            filter2.setSpeed(this.speed);
            filter2.setPitch(this.pitch);
            return Collections.singletonList(filter2);
        });
    }

    private void registerSources() {
        Config config = WaterPlayer.config;
        WaterPlayerSource wps = new WaterPlayerSource();
        this.lyricsManager.registerLyricsManager(wps);
        if (config.getBoolean("ENABLE_YOUTUBE", true)) {
            this.youtube = new YoutubeAudioSourceManager(true, new MusicWithThumbnail(), new WebEmbeddedWithThumbnail(), new WebWithThumbnail());
            this.youtube.setPlaylistPageCount(100);
            String refreshToken = config.getString("YOUTUBE_REFRESH_TOKEN", "");
            if (!refreshToken.isBlank()) {
                this.youtube.useOauth2(refreshToken, true);
            }
            this.audioPlayerManager.registerSourceManager(this.youtube);
            YoutubeSearchManager ytSearch = new YoutubeSearchManager(() -> this.audioPlayerManager, "US");
            this.lyricsManager.registerLyricsManager(new LyricsWithoutException(ytSearch));
        }
        if (!config.getString("VK_MUSIC_TOKEN", "").isBlank() && config.getBoolean("ENABLE_VK_MUSIC", false)) {
            VkMusicSourceManager vk = new VkMusicSourceManager(config.getString("VK_MUSIC_TOKEN", ""));
            this.audioPlayerManager.registerSourceManager(vk);
            this.lyricsManager.registerLyricsManager(new LyricsWithoutException(vk));
        }
        if (!config.getString("YANDEX_MUSIC_TOKEN", "").isBlank()) {
            YandexMusicSourceManager ym = new YandexMusicSourceManager(config.getString("YANDEX_MUSIC_TOKEN", ""));
            this.audioPlayerManager.registerSourceManager(ym);
            this.lyricsManager.registerLyricsManager(new LyricsWithoutException(ym));
        }
        if (!config.getString("FLOWERY_TTS_VOICE", "Alena").isBlank()) {
            this.audioPlayerManager.registerSourceManager(new FloweryTTSSourceManager(config.getString("FLOWERY_TTS_VOICE", "Alena")));
        }
        if (!config.getString("DEEZER_DECRYPTION_KEY", "").isBlank()) {
            DeezerAudioSourceManager deezerAudioSourceManager = new DeezerAudioSourceManager(config.getString("DEEZER_DECRYPTION_KEY", ""));
            this.audioPlayerManager.registerSourceManager(deezerAudioSourceManager);
            this.lyricsManager.registerLyricsManager(new LyricsWithoutException(deezerAudioSourceManager));
        }
        if (!config.getString("APPLE_MUSIC_MEDIA_API_TOKEN", "").isBlank() && !config.getString("APPLE_MUSIC_COUNTRY_CODE", "us").isBlank()) {
            AppleMusicSourceManager appleMusicSourceManager = new AppleMusicSourceManager((String[])null, config.getString("APPLE_MUSIC_MEDIA_API_TOKEN", ""), config.getString("APPLE_MUSIC_COUNTRY_CODE", "us"), (Function)((Object)this.audioPlayerManager));
            this.audioPlayerManager.registerSourceManager(appleMusicSourceManager);
        }
        if (!(config.getString("SPOTIFY_CLIENT_ID", "").isBlank() || config.getString("SPOTIFY_CLIENT_SECRET", "").isBlank() || config.getString("SPOTIFY_COUNTRY_CODE", "US").isBlank())) {
            SpotifySourceManager spotifySourceManager;
            if (config.getString("SPOTIFY_SP_DC", "").isBlank()) {
                spotifySourceManager = new SpotifySourceManager(null, config.getString("SPOTIFY_CLIENT_ID", ""), config.getString("SPOTIFY_CLIENT_SECRET", ""), config.getString("SPOTIFY_COUNTRY_CODE", "US"), this.audioPlayerManager);
            } else {
                spotifySourceManager = new SpotifySourceManager(config.getString("SPOTIFY_CLIENT_ID", ""), config.getString("SPOTIFY_CLIENT_SECRET", ""), config.getString("SPOTIFY_SP_DC", ""), config.getString("SPOTIFY_COUNTRY_CODE", "US"), unused -> this.audioPlayerManager, new DefaultMirroringAudioTrackResolver(null));
                this.lyricsManager.registerLyricsManager(new LyricsWithoutException(spotifySourceManager));
            }
            this.audioPlayerManager.registerSourceManager(spotifySourceManager);
        }
        if (config.getBoolean("ENABLE_SOUNDCLOUD", true)) {
            SoundCloudAudioSourceManager soundCloudAudioSourceManager = SoundCloudAudioSourceManager.createDefault();
            this.audioPlayerManager.registerSourceManager(soundCloudAudioSourceManager);
        }
        if (config.getBoolean("ENABLE_BANDCAMP", true)) {
            BandcampAudioSourceManager bandcampAudioSourceManager = new BandcampAudioSourceManager();
            this.audioPlayerManager.registerSourceManager(bandcampAudioSourceManager);
        }
        if (config.getBoolean("ENABLE_VIMEO", true)) {
            VimeoAudioSourceManager vimeoAudioSourceManager = new VimeoAudioSourceManager();
            this.audioPlayerManager.registerSourceManager(vimeoAudioSourceManager);
        }
        if (config.getBoolean("ENABLE_TWITCH", false)) {
            TwitchStreamAudioSourceManager twitchStreamAudioSourceManager = new TwitchStreamAudioSourceManager();
            this.audioPlayerManager.registerSourceManager(twitchStreamAudioSourceManager);
        }
        if (config.getBoolean("ENABLE_BEAM", true)) {
            BeamAudioSourceManager beamAudioSourceManager = new BeamAudioSourceManager();
            this.audioPlayerManager.registerSourceManager(beamAudioSourceManager);
        }
        this.audioPlayerManager.registerSourceManager(new DirectoriesSource());
        this.audioPlayerManager.registerSourceManager(new HttpAudioSourceManager());
        this.audioPlayerManager.registerSourceManager(this.localAudioSourceManager);
        this.audioPlayerManager.registerSourceManager(wps);
    }

    public void setPosition(long position) {
        if (this.getAudioPlayer().getPlayingTrack() == null) {
            return;
        }
        TrackScheduler.trackPosition = position;
        this.getAudioPlayer().getPlayingTrack().setPosition(position);
    }

    public void loadMusic(String url, boolean isFirstLoadMusic) {
        if (url.isBlank()) {
            if (isFirstLoadMusic) {
                WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.load.add.blank")).buildAndShow();
            }
            return;
        }
        if (isFirstLoadMusic) {
            WaterPlayer.config.setString("LAST_REQUEST_MUSIC", url);
        }
        this.loadTracks(url);
        if (isFirstLoadMusic) {
            WaterPlayer.getToast().setMessage(Localization.getText((String)"waterplayer.load.add")).buildAndShow();
        }
    }

    private void loadTracks(String url) {
        final String finalUrl = url = url.replace("\\", "/");
        this.audioPlayerManager.loadItemOrdered((Object)this.musicManager, url, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                MusicPlayer.this.musicManager.scheduler.addTrack(track);
                WaterPlayer.log("Adding Track: " + track.getInfo().title);
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                List<AudioTrack> tracks = playlist.getTracks();
                tracks.forEach(MusicPlayer.this.musicManager.scheduler::addTrack);
                WaterPlayer.log("Adding Playlist: " + playlist.getName() + ". Tracks Count: " + playlist.getTracks().size());
            }

            @Override
            public void noMatches() {
                WaterPlayer.log("Nothing Found by " + finalUrl, Level.WARN);
            }

            @Override
            public void loadFailed(FriendlyException ex) {
                WaterPlayer.log("ERROR: " + (ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage()), Level.DEBUG);
            }
        });
    }

    public AudioDataFormat getAudioDataFormat() {
        return this.audioDataFormat;
    }

    public boolean isPaused() {
        return this.audioPlayer.isPaused();
    }

    public boolean changePaused() {
        return this.changePaused(!this.isPaused());
    }

    public boolean changePaused(boolean pause) {
        this.audioPlayer.setPaused(pause);
        return this.isPaused();
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    public LyricsManager getLyricsManager() {
        return this.lyricsManager;
    }

    public TrackScheduler getTrackScheduler() {
        return this.trackScheduler;
    }

    public AudioOutput getAudioOutput() {
        return this.audioOutput;
    }

    public void startAudioOutput() {
        this.audioOutput.start();
    }

    public int getVolume() {
        return this.audioPlayer.getVolume();
    }
}

