/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.waterplayer.backend.sources.waterplayer.lyrics;

import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.lyrics.LRCLyricsFormat;
import ru.kelcuprum.waterplayer.backend.sources.waterplayer.lyrics.SRTLyricsFormat;

public class FileLyrics
implements AudioLyrics {
    final AudioTrack track;
    List<AudioLyrics.Line> lines = null;
    String text;

    public FileLyrics(AudioTrack track, String text) {
        this.track = track;
        if (text.isBlank()) {
            this.text = null;
        }
        if (LRCLyricsFormat.isLrcFormat(text)) {
            LRCLyricsFormat lrc = new LRCLyricsFormat(track, text);
            this.lines = lrc.lines;
            this.text = lrc.text;
        } else if (SRTLyricsFormat.isSrtFormat(text)) {
            SRTLyricsFormat srt = new SRTLyricsFormat(track, text);
            this.lines = srt.lines;
            this.text = srt.text.toString();
        } else {
            this.text = text;
        }
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "file";
    }

    @Override
    @Nullable
    public String getProvider() {
        return this.track.getSourceManager().getSourceName();
    }

    @Override
    @Nullable
    public String getText() {
        return this.text;
    }

    @Override
    @Nullable
    public List<AudioLyrics.Line> getLines() {
        return this.lines;
    }
}

