/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.drippedout.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SidewaysDripBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> TIP_DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape NORTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)4.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);

    public SidewaysDripBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void onProjectileHit(@NotNull Level level, @NotNull BlockState state, BlockHitResult hitResult, @NotNull Projectile projectile) {
        ServerLevel serverlevel;
        BlockPos blockpos = hitResult.getBlockPos();
        if (level instanceof ServerLevel && projectile.mayInteract(serverlevel = (ServerLevel)level, blockpos) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockpos, true);
        }
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity, @NotNull InsideBlockEffectApplier applier, boolean intersects) {
        if (level instanceof ServerLevel) {
            LivingEntity livingEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity && (livingEntity.xOld != (livingEntity = (LivingEntity)entity).getX() || livingEntity.zOld != livingEntity.getZ())) {
                double d0 = Math.abs(livingEntity.getX() - livingEntity.xOld);
                double d1 = Math.abs(livingEntity.getZ() - livingEntity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    livingEntity.hurtServer(serverLevel, livingEntity.damageSources().stalagmite(), 1.0f);
                }
            }
        }
        super.entityInside(state, level, pos, entity, applier, intersects);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        switch ((Direction)state.getValue(TIP_DIRECTION)) {
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        Direction direction = (Direction)state.getValue(TIP_DIRECTION);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)levelReader, blockpos, direction);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos pos, Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        return direction.getOpposite() == state.getValue(TIP_DIRECTION) && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean includeData, @NotNull Player player) {
        return new ItemStack((ItemLike)Items.POINTED_DRIPSTONE);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(TIP_DIRECTION, (Comparable)rot.rotate((Direction)state.getValue(TIP_DIRECTION)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(TIP_DIRECTION)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{TIP_DIRECTION, WATERLOGGED});
    }
}

